/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.jades;

import eu.europa.esig.jws.AbstractJWSUtils;
import eu.europa.esig.jws.JWSUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class JAdESUtils
extends AbstractJWSUtils {
    private static final String JAdES_SCHEMA_DEFINITIONS_LOCATION = "/schema/19182-jsonSchema.json";
    private static final String JAdES_SCHEMA_DEFINITIONS_URI = "19182-jsonSchema.json";
    private static final String JAdES_PROTECTED_HEADER_SCHEMA_LOCATION = "/schema/19182-protected-jsonSchema.json";
    private static final String JAdES_UNPROTECTED_HEADER_SCHEMA_LOCATION = "/schema/19182-unprotected-jsonSchema.json";
    private static final String RFC_SUBDIRECTORY = "rfcs/";
    private static final String RFC7797_SCHEMA_LOCATION = "/schema/rfcs/rfc7797.json";
    private static final String RFC7797_SCHEMA_URI = "rfc7797.json";
    private Map<URI, JSONObject> definitions;
    private static JAdESUtils singleton;

    private JAdESUtils() {
    }

    public static JAdESUtils getInstance() {
        if (singleton == null) {
            singleton = new JAdESUtils();
        }
        return singleton;
    }

    public JSONObject getJWSSchemaJSON() {
        return JWSUtils.getInstance().getJWSSchemaJSON();
    }

    public Map<URI, JSONObject> getJWSSchemaDefinitions() {
        return JWSUtils.getInstance().getJWSSchemaDefinitions();
    }

    public JSONObject getJWSProtectedHeaderSchemaJSON() {
        return this.parseJson(JAdESUtils.class.getResourceAsStream(JAdES_PROTECTED_HEADER_SCHEMA_LOCATION));
    }

    public Map<URI, JSONObject> getJWSProtectedHeaderSchemaDefinitions() {
        return this.getJAdESDefinitions();
    }

    public JSONObject getJWSUnprotectedHeaderSchemaJSON() {
        return this.parseJson(JAdESUtils.class.getResourceAsStream(JAdES_UNPROTECTED_HEADER_SCHEMA_LOCATION));
    }

    public Map<URI, JSONObject> getJWSUnprotectedHeaderSchemaDefinitions() {
        return this.getJAdESDefinitions();
    }

    public Map<URI, JSONObject> getJAdESDefinitions() {
        if (this.definitions == null) {
            this.definitions = new HashMap<URI, JSONObject>();
            this.definitions.put(URI.create(JAdES_SCHEMA_DEFINITIONS_URI), this.parseJson(JAdESUtils.class.getResourceAsStream(JAdES_SCHEMA_DEFINITIONS_LOCATION)));
            Map rfcDefinitions = JWSUtils.getInstance().getRFCDefinitions();
            for (Map.Entry entry : rfcDefinitions.entrySet()) {
                this.definitions.put(URI.create(RFC_SUBDIRECTORY + ((URI)entry.getKey()).toString()), (JSONObject)entry.getValue());
            }
            this.definitions.put(URI.create("rfcs/rfc7797.json"), this.parseJson(JAdESUtils.class.getResourceAsStream(RFC7797_SCHEMA_LOCATION)));
        }
        return this.definitions;
    }
}

