/*
 * Decompiled with CFR 0.152.
 */
package eu.evops.maven.plugins.cucumber.parallel;

import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class Formatter
implements gherkin.formatter.Formatter {
    private static final Logger LOG = Logger.getLogger(Formatter.class.getName());
    private final File destination;
    private final Map<String, List<Integer>> featuresAndLineNumbers = new HashMap<String, List<Integer>>();
    private List<Integer> currentFeature;

    public Formatter(File destination) {
        this.destination = destination;
    }

    public void syntaxError(String s, String s1, List<String> list, String s2, Integer integer) {
    }

    public void uri(String s) {
        this.currentFeature = new ArrayList<Integer>();
        this.featuresAndLineNumbers.put(s, this.currentFeature);
    }

    public void feature(Feature feature) {
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.currentFeature.add(scenario.getLine());
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
    }

    public void step(Step step) {
    }

    public void done() {
        int i;
        ArrayList threadedGroups = new ArrayList();
        Set<Map.Entry<String, List<Integer>>> entries = this.featuresAndLineNumbers.entrySet();
        int numberOfThreads = this.getNumberOfThreads();
        int counter = 0;
        Iterator<Map.Entry<String, List<Integer>>> iterator = entries.iterator();
        for (i = 0; i < entries.size(); ++i) {
            Map.Entry<String, List<Integer>> entry = iterator.next();
            String feature = entry.getKey();
            List<Integer> lineNumbers = entry.getValue();
            for (Integer n : lineNumbers) {
                HashMap threadGroup;
                int n2 = counter % numberOfThreads;
                if (threadedGroups.size() < n2 + 1) {
                    threadedGroups.add(new HashMap());
                }
                if (!(threadGroup = (HashMap)threadedGroups.get(n2)).containsKey(feature)) {
                    threadGroup.put(feature, new ArrayList());
                }
                ((List)threadGroup.get(feature)).add(n);
                ++counter;
            }
        }
        for (i = 0; i < threadedGroups.size(); ++i) {
            HashMap scenarioList = (HashMap)threadedGroups.get(i);
            if (this.destination.exists()) {
                this.destination.delete();
            }
            this.destination.mkdirs();
            File threadFolder = new File(this.destination, String.format("thread-%d", i));
            File threadFile = new File(threadFolder, "run");
            if (threadFolder.exists()) {
                threadFolder.delete();
            }
            threadFolder.mkdirs();
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(threadFile, true);
                for (Map.Entry entry : scenarioList.entrySet()) {
                    fileWriter.write((String)entry.getKey());
                    List lineNumbers = (List)entry.getValue();
                    for (Integer lineNumber : lineNumbers) {
                        fileWriter.write(String.format(":%d", lineNumber));
                    }
                    fileWriter.write(" ");
                }
            }
            catch (IOException iOException) {
                LOG.severe(iOException.getMessage());
            }
            try {
                if (fileWriter == null) continue;
                fileWriter.close();
                continue;
            }
            catch (IOException iOException) {
                LOG.severe(iOException.getMessage());
            }
        }
    }

    public void close() {
    }

    public void eof() {
    }

    private int getNumberOfThreads() {
        return Integer.getInteger("cucumber-parallel-execution.threads", Runtime.getRuntime().availableProcessors());
    }
}

