/*
 * Decompiled with CFR 0.152.
 */
package eu.evops.maven.plugins.cucumber.parallel;

import eu.evops.maven.plugins.cucumber.parallel.CucumberArguments;
import eu.evops.maven.plugins.cucumber.parallel.Formatter;
import eu.evops.maven.plugins.cucumber.parallel.ProcessInThread;
import eu.evops.maven.plugins.cucumber.parallel.reporting.MergeException;
import eu.evops.maven.plugins.cucumber.parallel.reporting.Merger;
import eu.evops.maven.plugins.cucumber.parallel.reporting.formatters.StreamingJSONFormatter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
public class Run
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginDependencies;
    @Parameter(property="cucumberRunner.outputFolder", defaultValue="${project.build.directory}/cucumber")
    private File outputFolder;
    @Parameter(property="cucumberRunner.features")
    private List<String> features = Collections.singletonList("src/test/resources");
    @Parameter(property="cucumberRunner.includeTags")
    private List<String> includeTags = Collections.emptyList();
    @Parameter(property="cucumberRunner.excludeTags")
    private List<String> excludeTags = Collections.emptyList();
    @Parameter(property="cucumberRunner.jvmArgs")
    private String jvmArgs = "";
    @Parameter(property="cucumberRunner.rerunFailedTests")
    private int rerunFailedTests = 0;
    @Parameter(property="cucumberRunner.gluePaths")
    private List<String> gluePaths = new ArrayList<String>();
    @Parameter(property="cucumberRunner.plugins", defaultValue="json:")
    private List<String> plugins = Collections.emptyList();
    @Parameter(property="cucumberRunner.scenarioNames")
    private List<String> scenarioNames = Collections.emptyList();
    @Parameter(property="cucumberRunner.threadTimeout", defaultValue="60")
    private int threadTimeout;
    @Parameter(property="cucumberRunner.scenarioGeneratorTimeout", defaultValue="10")
    private int scenarioGeneratorTimeout;
    @Parameter(property="cucumberRunner.dryRun")
    boolean dryRun = false;
    @Parameter(property="cucumberRunner.enhancedJsonReporting")
    boolean enhancedJsonReporting = false;
    @Parameter
    boolean strict = true;
    @Parameter(property="cucumberRunner.threadCount")
    int threadCount;
    @Parameter(property="cucumberRunner.combineReports", defaultValue="true")
    boolean combineReports;
    @Parameter(property="cucumberRunner.test.failure.ignore")
    boolean testFailureIgnore;
    private File threadFolder;
    private String streamingFormatterClassName = StreamingJSONFormatter.class.getName();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setThreadCount();
        this.setOutputFolder();
        this.getLog().debug((CharSequence)String.format("Running cucumber in %s", this.features));
        List<String> threadedArgs = this.getThreadGeneratorArguments(this.getThreadFolder());
        try {
            this.getLog().debug((CharSequence)"Generating thread files");
            List classpath = this.project.getTestClasspathElements();
            classpath.addAll(this.getPluginDependencies());
            Properties threadGeneratorProperties = new Properties();
            threadGeneratorProperties.putAll((Map<?, ?>)this.project.getProperties());
            ProcessInThread main = this.createProcess(threadedArgs, classpath, threadGeneratorProperties);
            main.setLog(this.getLog());
            main.setStderr(new File(this.getThreadFolder(), "generator-stderr.log"));
            main.setStdout(new File(this.getThreadFolder(), "generator-stdout.log"));
            main.start();
            main.join(this.scenarioGeneratorTimeout * 1000);
            if (main.getState() != Thread.State.TERMINATED) {
                this.getLog().error((CharSequence)String.format("The generator thread timed out %s", main));
                main.interrupt();
            }
            if (main.getStatus() != 0) {
                throw new MojoFailureException("Failed to generate thread files");
            }
            this.getLog().debug((CharSequence)"Thread files have been generated");
            classpath.addAll(this.getFeatureFolders());
            ArrayList<ProcessInThread> threads = new ArrayList<ProcessInThread>();
            for (int i = 0; i < this.threadCount; ++i) {
                int threadId = i;
                File threadFolder = this.getThreadFolder(this.getThreadFolder(), i);
                if (!threadFolder.exists()) {
                    this.getLog().warn((CharSequence)String.format("Thread folder does not exist: %s. It is possible that there were less scenarios than number of threads required", threadFolder.getAbsolutePath()));
                    continue;
                }
                List<String> threadArguments = this.getThreadArguments(this.getThreadFolder(), i);
                File stdout = new File(String.format("%s/thread-%d/stdout.log", this.getThreadFolder().getAbsolutePath(), i));
                File stderr = new File(String.format("%s/thread-%d/stderr.log", this.getThreadFolder().getAbsolutePath(), i));
                Properties threadProperties = new Properties();
                threadProperties.putAll((Map<?, ?>)this.project.getProperties());
                ProcessInThread thread = this.createProcess(threadArguments, classpath, threadProperties, i);
                thread.setLog(this.getLog());
                thread.setStdout(stdout);
                thread.setStderr(stderr);
                threads.add(thread);
                thread.onFinish(t -> {
                    String status = t.getStatus() == 0 ? "passed" : "failed";
                    this.getLog().info((CharSequence)String.format("- Thread %d/%d has finished with status: %s", threadId + 1, this.threadCount, status));
                });
                thread.start();
            }
            this.getLog().info((CharSequence)"Cucumber execution configuration:");
            this.getLog().info((CharSequence)String.format("- Features:            %s", String.join((CharSequence)", ", this.features)));
            this.getLog().info((CharSequence)String.format("- Included tags:       %s", String.join((CharSequence)", ", this.includeTags)));
            this.getLog().info((CharSequence)String.format("- Excluded tags:       %s", String.join((CharSequence)", ", this.excludeTags)));
            this.getLog().info((CharSequence)String.format("- Glue paths:          %s", String.join((CharSequence)", ", this.gluePaths)));
            this.getLog().info((CharSequence)String.format("- Plugins:             %s", String.join((CharSequence)", ", this.plugins)));
            this.getLog().info((CharSequence)String.format("- Thread timeout:      %d minutes", this.threadTimeout));
            this.getLog().info((CharSequence)String.format("- Number of threads:   %d", this.threadCount));
            this.getLog().info((CharSequence)String.format("- Ignore test failure: %s", this.testFailureIgnore));
            this.getLog().info((CharSequence)String.format("- Report folder:       file://%s", this.outputFolder.getAbsolutePath()));
            this.getLog().info((CharSequence)"========================================================================");
            this.getLog().info((CharSequence)String.format("Running cucumber with %d threads, each thread will run up to 1 hour ...", threads.size()));
            while (this.hasRunningThreads(threads)) {
                Thread.sleep(1000L);
            }
            if (this.combineReports) {
                this.getLog().info((CharSequence)"Generating combined reports");
                this.combineReports();
                this.report();
            }
            if (!this.testFailureIgnore && !this.haveAllThreadsPassed(threads)) {
                throw new MojoFailureException(String.format("Some of the threads have failed, please inspect output folder: %s", this.getThreadFolder().getAbsolutePath()));
            }
        }
        catch (MojoFailureException mf) {
            throw mf;
        }
        catch (Throwable throwable) {
            throw new MojoFailureException("Error generating cucumber sets", throwable);
        }
    }

    private ProcessInThread createProcess(List<String> arguments, List<String> classpath, Properties properties) {
        return this.createProcess(arguments, classpath, properties, -1);
    }

    private void combineReports() throws MergeException, MojoFailureException {
        for (String plugin : this.plugins) {
            String pluginName = plugin.split(":")[0];
            if (!pluginName.matches(String.format("(json|junit|%s)", this.streamingFormatterClassName))) continue;
            Merger.get(pluginName).merge(this.getThreadFolder(), this.findReports(this.getReportFileName(pluginName)));
        }
    }

    private List<String> findReports(String reportFileName) throws MojoFailureException {
        ArrayList<String> reportFiles = new ArrayList<String>();
        NameFileFilter nameFileFilter = new NameFileFilter(reportFileName);
        Iterator files = FileUtils.iterateFiles((File)this.getThreadFolder(), (IOFileFilter)nameFileFilter, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        while (files.hasNext()) {
            reportFiles.add(((File)files.next()).getAbsolutePath());
        }
        return reportFiles;
    }

    private void setOutputFolder() {
    }

    private void report() throws MojoFailureException {
        File combinedReportOutputDirectory = new File(this.project.getBuild().getDirectory(), "cucumber/combined-html");
        List<String> combinedJsonFiles = Collections.singletonList(new File(this.getThreadFolder(), "combined.json").getAbsolutePath());
        this.generateReportForJsonFiles(combinedReportOutputDirectory, combinedJsonFiles);
    }

    private void generateReportForJsonFiles(File reportOutputDirectory, List<String> jsonFiles) {
        String jenkinsBasePath = "";
        String buildNumber = "1";
        String projectName = this.project.getName();
        Configuration configuration = new Configuration(reportOutputDirectory, projectName);
        configuration.setParallelTesting(false);
        configuration.setJenkinsBasePath(jenkinsBasePath);
        configuration.setRunWithJenkins(false);
        configuration.setBuildNumber(buildNumber);
        ReportBuilder reportBuilder = new ReportBuilder(jsonFiles, configuration);
        reportBuilder.generateReports();
        this.getLog().info((CharSequence)String.format("Cucumber HTML report has been generated at: %s/cucumber-html-reports/overview-features.html", reportOutputDirectory.getAbsolutePath()));
    }

    private boolean hasRunningThreads(List<ProcessInThread> threads) {
        return threads.stream().filter(Thread::isAlive).toArray().length > 0;
    }

    private boolean haveAllThreadsPassed(List<ProcessInThread> threads) {
        return threads.stream().filter(t -> t.getStatus() != 0).toArray().length == 0;
    }

    private List<String> getPluginDependencies() {
        ArrayList<String> pluginClasspath = new ArrayList<String>();
        for (Artifact pluginDependency : this.pluginDependencies) {
            pluginClasspath.add(pluginDependency.getFile().getAbsolutePath());
        }
        return pluginClasspath;
    }

    private List<String> getThreadArguments(File threadsFolder, int threadNumber) {
        List<String> args = this.getCommonArguments();
        File threadFolder = this.getThreadFolder(threadsFolder, threadNumber);
        args.add(String.format("@%s", new File(threadFolder, "run").getAbsolutePath()));
        args.add(CucumberArguments.Monochrome.getArg());
        if (this.strict) {
            args.add(CucumberArguments.Strict.getArg());
        }
        if (this.plugins.contains("json:") && this.plugins.contains(this.streamingFormatterClassName + ":")) {
            throw new RuntimeException("Cannot use json and streaming json formatters together");
        }
        for (String plugin : this.plugins) {
            args.add(CucumberArguments.Plugin.getArg());
            if (plugin.endsWith(":")) {
                String[] pluginDetails = plugin.split(":");
                String pluginName = pluginDetails[0];
                if (pluginName.equalsIgnoreCase("json") && this.enhancedJsonReporting) {
                    pluginName = this.streamingFormatterClassName;
                }
                File threadedReportFile = new File(threadFolder, "reports/" + this.getReportFileName(pluginName));
                args.add(String.format("%s:%s", pluginName, threadedReportFile.getAbsolutePath()));
                continue;
            }
            args.add(plugin.replace("%thread%", String.valueOf(threadNumber)));
        }
        if (this.rerunFailedTests > 0) {
            args.add(CucumberArguments.Plugin.getArg());
            args.add(String.format("rerun:%s", new File(threadFolder, "rerun.txt").getAbsolutePath()));
        }
        for (String gluePath : this.gluePaths) {
            args.add(CucumberArguments.Glue.getArg());
            args.add(gluePath);
        }
        this.getLog().debug((CharSequence)String.format("Thread arguments: %s", args));
        return args;
    }

    private String getReportFileName(String formatterName) {
        String streamingJsonFormatterClassName = StreamingJSONFormatter.class.getName();
        if (formatterName.equals("json") || formatterName.equals(streamingJsonFormatterClassName)) {
            return "report.json";
        }
        if (formatterName.equals("junit")) {
            return "report.xml";
        }
        if (formatterName.equals("rerun")) {
            return "rerun.txt";
        }
        return formatterName;
    }

    private File getThreadFolder(File threadsFolder, int threadNumber) {
        return new File(threadsFolder, String.format("thread-%d", threadNumber));
    }

    private File getThreadFolder() throws MojoFailureException {
        if (this.threadFolder != null) {
            return this.threadFolder;
        }
        this.threadFolder = new File(this.project.getBuild().getDirectory(), "cucumber/threads");
        try {
            org.codehaus.plexus.util.FileUtils.deleteDirectory((File)this.threadFolder);
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Cannot delete thread folder: %s", this.threadFolder.getAbsolutePath()), (Throwable)e);
        }
        if (!this.threadFolder.mkdirs()) {
            throw new MojoFailureException(String.format("Could not create thread folder at: %s", this.threadFolder.getAbsolutePath()));
        }
        return this.threadFolder;
    }

    private void setThreadCount() {
        if (this.threadCount == 0) {
            this.threadCount = Runtime.getRuntime().availableProcessors();
        }
        System.setProperty("cucumber-parallel-execution.threads", String.valueOf(this.threadCount));
    }

    private List<String> getCommonArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.dryRun) {
            arguments.add(CucumberArguments.DryRun.getArg());
        }
        return arguments;
    }

    private ProcessInThread createProcess(List<String> arguments, List<String> classpath, Properties properties, int threadNumber) {
        String workingDirectory = this.project.getBasedir().getAbsolutePath();
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        if (threadNumber > -1) {
            properties.put("cucumberRunner.threadNumber", String.valueOf(threadNumber));
            properties.put("cucumberRunner.threadCount", String.valueOf(this.threadCount));
            environmentVariables.put("THREAD_NUMBER", String.valueOf(threadNumber));
            environmentVariables.put("THREAD_COUNT", String.valueOf(this.threadCount));
        }
        return new ProcessInThread(arguments, this.jvmArgs, classpath, properties, environmentVariables, workingDirectory, this.threadTimeout);
    }

    private List<String> getThreadGeneratorArguments(File threadFolder) {
        List<String> args = this.getCommonArguments();
        args.add(CucumberArguments.DryRun.getArg());
        args.add(CucumberArguments.Plugin.getArg());
        args.add(String.format("%s:%s", Formatter.class.getCanonicalName(), threadFolder.getAbsolutePath()));
        args.add(CucumberArguments.Monochrome.getArg());
        for (String tag : this.excludeTags) {
            if (tag == null) continue;
            args.add(CucumberArguments.Tags.getArg());
            args.add(String.format("~%s", tag));
        }
        for (String tag : this.includeTags) {
            if (tag == null) continue;
            args.add(CucumberArguments.Tags.getArg());
            args.add(tag);
        }
        args.addAll(this.features);
        for (String scenarioName : this.scenarioNames) {
            args.add(CucumberArguments.ScenarioName.getArg());
            args.add(scenarioName);
        }
        return args;
    }

    private boolean isClassPathOrRerun(String feature) {
        return feature.startsWith("classpath:") || feature.startsWith("@");
    }

    private List<String> getFeatureFolders() {
        ArrayList<String> result = new ArrayList<String>();
        for (String feature : this.features) {
            if (this.isClassPathOrRerun(feature)) continue;
            result.add(feature.replace(".feature$", ""));
        }
        return result;
    }
}

