/*
 * Decompiled with CFR 0.152.
 */
package eu.evops.maven.plugins.cucumber.parallel.reporting;

import eu.evops.maven.plugins.cucumber.parallel.reporting.JsonResultMerger;
import eu.evops.maven.plugins.cucumber.parallel.reporting.JunitResultMerger;
import eu.evops.maven.plugins.cucumber.parallel.reporting.MergeException;
import eu.evops.maven.plugins.cucumber.parallel.reporting.ResultMerger;

public enum Merger {
    Junit(new JunitResultMerger()),
    Json(new JsonResultMerger("combined.json")),
    StreamingJsonFormatter(new JsonResultMerger("combined.json"));

    private ResultMerger merger;

    private Merger(ResultMerger merger) {
        this.merger = merger;
    }

    public ResultMerger getMerger() {
        return this.merger;
    }

    public static ResultMerger get(String merger) throws MergeException {
        for (Merger m : Merger.values()) {
            if (m.name().equalsIgnoreCase(merger)) {
                return m.getMerger();
            }
            if (!merger.contains("StreamingJSONFormatter")) continue;
            return StreamingJsonFormatter.getMerger();
        }
        throw new MergeException(String.format("Could not find result merger for %s", merger));
    }
}

