/*
 * Decompiled with CFR 0.152.
 */
package eu.evops.maven.plugins.cucumber.parallel.reporting.formatters;

import cucumber.runtime.formatter.CucumberJSONFormatter;
import gherkin.deps.com.google.gson.Gson;
import gherkin.formatter.Formatter;
import gherkin.formatter.JSONFormatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

public class StreamingJSONFormatter
implements Formatter,
Reporter {
    private final JSONFormatter jsonFormatter;
    private File file;

    public StreamingJSONFormatter(File file) {
        this.file = file;
        this.jsonFormatter = new CucumberJSONFormatter((Appendable)new StringBuffer());
    }

    public void syntaxError(String s, String s1, List<String> list, String s2, Integer integer) {
        this.jsonFormatter.syntaxError(s, s1, list, s2, integer);
    }

    public void uri(String s) {
        this.jsonFormatter.uri(s);
    }

    public void feature(Feature feature) {
        this.jsonFormatter.feature(feature);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.jsonFormatter.scenarioOutline(scenarioOutline);
    }

    public void examples(Examples examples) {
        this.jsonFormatter.examples(examples);
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.jsonFormatter.startOfScenarioLifeCycle(scenario);
    }

    public void background(Background background) {
        this.jsonFormatter.background(background);
    }

    public void scenario(Scenario scenario) {
        this.jsonFormatter.scenario(scenario);
    }

    public void step(Step step) {
        this.jsonFormatter.step(step);
    }

    private Gson getGson() {
        try {
            Method gsonMethod = JSONFormatter.class.getDeclaredMethod("gson", new Class[0]);
            gsonMethod.setAccessible(true);
            return (Gson)gsonMethod.invoke((Object)this.jsonFormatter, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Map<String, Object>> getFeatureMaps() {
        try {
            Field field = JSONFormatter.class.getDeclaredField("featureMaps");
            field.setAccessible(true);
            return (List)field.get(this.jsonFormatter);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        this.jsonFormatter.endOfScenarioLifeCycle(scenario);
        this.done();
    }

    public void done() {
        String json = this.getGson().toJson(this.getFeatureMaps());
        try {
            Path filePath = Paths.get(this.file.getAbsolutePath(), new String[0]);
            Files.write(filePath, json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.jsonFormatter.close();
    }

    public void eof() {
        this.jsonFormatter.eof();
    }

    public void before(Match match, Result result) {
        this.jsonFormatter.before(match, result);
    }

    public void result(Result result) {
        this.jsonFormatter.result(result);
    }

    public void after(Match match, Result result) {
        this.jsonFormatter.after(match, result);
    }

    public void match(Match match) {
        this.jsonFormatter.match(match);
    }

    public void embedding(String s, byte[] bytes) {
        this.jsonFormatter.embedding(s, bytes);
    }

    public void write(String s) {
        this.jsonFormatter.write(s);
    }
}

