/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.tools;

import java.util.Collections;
import java.util.List;

public class Statistics {
    public static double getMean(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).sum() / (double)DATA.size();
    }

    public static double getVariance(List<Double> DATA) {
        double mean = Statistics.getMean(DATA);
        double temp = 0.0;
        for (double a : DATA) {
            temp += (a - mean) * (a - mean);
        }
        return temp / (double)DATA.size();
    }

    public static double getStdDev(List<Double> DATA) {
        return Math.sqrt(Statistics.getVariance(DATA));
    }

    public static double getMedian(List<Double> DATA) {
        int size = DATA.size();
        Collections.sort(DATA);
        return size % 2 == 0 ? (DATA.get(size / 2 - 1) + DATA.get(size / 2)) / 2.0 : DATA.get(size / 2);
    }

    public static double getMin(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).min().orElse(0.0);
    }

    public static double getMax(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).max().orElse(0.0);
    }
}

