/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.antlr.database;

import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import eu.rssw.antlr.database.DescriptiveErrorListener;
import eu.rssw.antlr.database.DumpFileGrammarLexer;
import eu.rssw.antlr.database.DumpFileGrammarParser;
import eu.rssw.antlr.database.DumpFileVisitor;
import eu.rssw.antlr.database.objects.DatabaseDescription;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public final class DumpFileUtils {
    private DumpFileUtils() {
    }

    public static final ParseTree getDumpFileParseTree(File file) throws IOException {
        return DumpFileUtils.getDumpFileParseTree(new FileInputStream(file), null);
    }

    public static final ParseTree getDumpFileParseTree(InputStream stream, Charset defaultCharset) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        int len = stream.read(buffer);
        while (len != -1) {
            outStream.write(buffer, 0, len);
            len = stream.read(buffer);
        }
        ByteArrayInputStream buffdInput = new ByteArrayInputStream(outStream.toByteArray());
        DFCodePageProcessor charsetReader = new DFCodePageProcessor(defaultCharset);
        CharStreams.readLines((Readable)new InputStreamReader((InputStream)buffdInput, defaultCharset == null ? Charset.defaultCharset() : defaultCharset), (LineProcessor)charsetReader);
        buffdInput.reset();
        return DumpFileUtils.getDumpFileParseTree(new InputStreamReader((InputStream)buffdInput, (Charset)charsetReader.getResult()));
    }

    public static final ParseTree getDumpFileParseTree(Reader reader) throws IOException {
        DescriptiveErrorListener listener = new DescriptiveErrorListener();
        DumpFileGrammarLexer lexer = new DumpFileGrammarLexer((CharStream)org.antlr.v4.runtime.CharStreams.fromReader((Reader)reader));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        DumpFileGrammarParser parser = new DumpFileGrammarParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        return parser.dump();
    }

    public static final DatabaseDescription getDatabaseDescription(File file) throws IOException {
        return DumpFileUtils.getDatabaseDescription(file, Files.getNameWithoutExtension((String)file.getName()));
    }

    public static final DatabaseDescription getDatabaseDescription(File file, String dbName) throws IOException {
        DumpFileVisitor visitor = new DumpFileVisitor(dbName);
        visitor.visit(DumpFileUtils.getDumpFileParseTree(file));
        return visitor.getDatabase();
    }

    public static final DatabaseDescription getDatabaseDescription(InputStream stream, Charset cs, String dbName) throws IOException {
        DumpFileVisitor visitor = new DumpFileVisitor(dbName);
        visitor.visit(DumpFileUtils.getDumpFileParseTree(stream, cs));
        return visitor.getDatabase();
    }

    private static class DFCodePageProcessor
    implements LineProcessor<Charset> {
        private Charset charset = Charset.defaultCharset();

        public DFCodePageProcessor(Charset charset) {
            if (charset != null) {
                this.charset = charset;
            }
        }

        public Charset getResult() {
            return this.charset;
        }

        public boolean processLine(String arg0) throws IOException {
            if (arg0.startsWith("cpstream=")) {
                try {
                    this.charset = Charset.forName(arg0.substring(9));
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                    // empty catch block
                }
                return false;
            }
            return true;
        }
    }
}

