/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.antlr.database;

import eu.rssw.antlr.database.DumpFileGrammarBaseVisitor;
import eu.rssw.antlr.database.DumpFileGrammarParser;
import eu.rssw.antlr.database.objects.DatabaseDescription;
import eu.rssw.antlr.database.objects.Field;
import eu.rssw.antlr.database.objects.Index;
import eu.rssw.antlr.database.objects.IndexField;
import eu.rssw.antlr.database.objects.Sequence;
import eu.rssw.antlr.database.objects.Table;
import eu.rssw.antlr.database.objects.Trigger;
import eu.rssw.antlr.database.objects.TriggerType;
import java.util.ArrayDeque;
import java.util.Deque;
import org.antlr.v4.runtime.tree.RuleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpFileVisitor
extends DumpFileGrammarBaseVisitor<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(DumpFileVisitor.class);
    private DatabaseDescription db;
    private Deque<Table> tables = new ArrayDeque<Table>();
    private Deque<Field> fields = new ArrayDeque<Field>();
    private Deque<Sequence> sequences = new ArrayDeque<Sequence>();
    private Deque<Index> indexes = new ArrayDeque<Index>();

    public DumpFileVisitor(String dbName) {
        this.db = new DatabaseDescription(dbName);
    }

    public DatabaseDescription getDatabase() {
        return this.db;
    }

    @Override
    public Void visitAddField(DumpFileGrammarParser.AddFieldContext ctx) {
        Field field = new Field(ctx.field.getText(), ctx.dataType.getText());
        field.setFirstLine(ctx.getStart().getLine());
        field.setLastLine(ctx.getStop().getLine());
        this.fields.push(field);
        Table table = null;
        for (Table t : this.tables) {
            if (!t.getName().equalsIgnoreCase(ctx.table.getText())) continue;
            table = t;
        }
        if (table != null) {
            table.addField(field);
        }
        return (Void)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Void visitFieldDescription(DumpFileGrammarParser.FieldDescriptionContext ctx) {
        if (!this.fields.isEmpty()) {
            this.fields.peek().setDescription(ctx.val.getText());
        }
        return null;
    }

    @Override
    public Void visitFieldExtent(DumpFileGrammarParser.FieldExtentContext ctx) {
        if (!this.fields.isEmpty()) {
            this.fields.peek().setExtent(Integer.parseInt(ctx.val.getText()));
        }
        return null;
    }

    @Override
    public Void visitFieldFormat(DumpFileGrammarParser.FieldFormatContext ctx) {
        if (!this.fields.isEmpty()) {
            this.fields.peek().setFormat(ctx.val.getText());
        }
        return (Void)super.visitFieldFormat(ctx);
    }

    @Override
    public Void visitFieldMaxWidth(DumpFileGrammarParser.FieldMaxWidthContext ctx) {
        if (!this.fields.isEmpty()) {
            this.fields.peek().setMaxWidth(Integer.parseInt(ctx.val.getText()));
        }
        return null;
    }

    @Override
    public Void visitFieldOrder(DumpFileGrammarParser.FieldOrderContext ctx) {
        if (!this.fields.isEmpty()) {
            this.fields.peek().setOrder(Integer.parseInt(ctx.val.getText()));
        }
        return null;
    }

    @Override
    public Void visitFieldTrigger(DumpFileGrammarParser.FieldTriggerContext ctx) {
        if (this.fields.isEmpty()) {
            return null;
        }
        if (TriggerType.getTriggerType(ctx.type.getText()) != TriggerType.ASSIGN) {
            LOG.error("'{}' FIELD-TRIGGER found at line {}", (Object)ctx.type.getText(), (Object)ctx.type.getLine());
            return null;
        }
        Trigger trigger = new Trigger(TriggerType.ASSIGN, ctx.triggerProcedure.getText());
        if (ctx.crc != null) {
            trigger.setCrc(ctx.crc.getText());
        }
        if (ctx.noOverride != null) {
            trigger.setNoOverride(true);
        }
        this.fields.peek().addTrigger(trigger);
        return null;
    }

    @Override
    public Void visitAddTable(DumpFileGrammarParser.AddTableContext ctx) {
        Table table = new Table(ctx.table.getText());
        table.setFirstLine(ctx.getStart().getLine());
        table.setLastLine(ctx.getStop().getLine());
        this.tables.push(table);
        this.db.addTable(table);
        return (Void)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Void visitTableArea(DumpFileGrammarParser.TableAreaContext ctx) {
        if (!this.tables.isEmpty()) {
            this.tables.peek().setArea(ctx.val.getText());
        }
        return null;
    }

    @Override
    public Void visitTableDescription(DumpFileGrammarParser.TableDescriptionContext ctx) {
        if (!this.tables.isEmpty()) {
            this.tables.peek().setDescription(ctx.val.getText());
        }
        return null;
    }

    @Override
    public Void visitTableDumpName(DumpFileGrammarParser.TableDumpNameContext ctx) {
        if (!this.tables.isEmpty()) {
            this.tables.peek().setDumpName(ctx.val.getText());
        }
        return null;
    }

    @Override
    public Void visitTableValMsg(DumpFileGrammarParser.TableValMsgContext ctx) {
        if (!this.tables.isEmpty()) {
            this.tables.peek().setValMsg(ctx.val.getText());
        }
        return null;
    }

    @Override
    public Void visitTableTrigger(DumpFileGrammarParser.TableTriggerContext ctx) {
        if (this.tables.isEmpty()) {
            return null;
        }
        Trigger trigger = new Trigger(TriggerType.getTriggerType(ctx.type.getText()), ctx.triggerProcedure.getText());
        if (ctx.crc != null) {
            trigger.setCrc(ctx.crc.getText());
        }
        if (ctx.noOverride != null) {
            trigger.setNoOverride(true);
        }
        this.tables.peek().addTrigger(trigger);
        return null;
    }

    @Override
    public Void visitAddIndex(DumpFileGrammarParser.AddIndexContext ctx) {
        Index index = new Index(ctx.index.getText());
        index.setFirstLine(ctx.getStart().getLine());
        index.setLastLine(ctx.getStop().getLine());
        this.indexes.push(index);
        if (ctx.uniq != null) {
            index.setUnique(true);
        }
        Table table = null;
        for (Table t : this.tables) {
            if (!t.getName().equalsIgnoreCase(ctx.table.getText())) continue;
            table = t;
        }
        if (table != null) {
            table.addIndex(index);
        }
        return (Void)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Void visitIndexArea(DumpFileGrammarParser.IndexAreaContext ctx) {
        if (!this.indexes.isEmpty()) {
            this.indexes.peek().setArea(ctx.val.getText());
        }
        return null;
    }

    @Override
    public Void visitIndexUnique(DumpFileGrammarParser.IndexUniqueContext ctx) {
        if (!this.indexes.isEmpty()) {
            this.indexes.peek().setUnique(true);
        }
        return null;
    }

    @Override
    public Void visitIndexPrimary(DumpFileGrammarParser.IndexPrimaryContext ctx) {
        if (!this.indexes.isEmpty()) {
            this.indexes.peek().setPrimary(true);
        }
        return null;
    }

    @Override
    public Void visitIndexWord(DumpFileGrammarParser.IndexWordContext ctx) {
        if (!this.indexes.isEmpty()) {
            this.indexes.peek().setWord(true);
        }
        return null;
    }

    @Override
    public Void visitIndexField(DumpFileGrammarParser.IndexFieldContext ctx) {
        if (this.indexes.isEmpty()) {
            return null;
        }
        String tableName = ((DumpFileGrammarParser.AddIndexContext)ctx.parent).table.getText();
        Table table = null;
        for (Table t : this.tables) {
            if (!t.getName().equalsIgnoreCase(tableName)) continue;
            table = t;
        }
        if (table != null) {
            IndexField idxFld = new IndexField(table.getField(ctx.field.getText()), ctx.order == null || "ascending".equalsIgnoreCase(ctx.order.getText()));
            this.indexes.peek().addField(idxFld);
        }
        return null;
    }

    @Override
    public Void visitUpdateIndexBP(DumpFileGrammarParser.UpdateIndexBPContext ctx) {
        Index index;
        String tableName = ctx.table.getText();
        String indexName = ctx.index.getText();
        Table table = this.db.getTable(tableName);
        if (table != null && (index = table.getIndex(indexName)) != null) {
            index.setBufferPool(ctx.value.getText());
        }
        return null;
    }

    @Override
    public Void visitAddSequence(DumpFileGrammarParser.AddSequenceContext ctx) {
        Sequence seq = new Sequence(ctx.sequence.getText());
        seq.setFirstLine(ctx.getStart().getLine());
        seq.setLastLine(ctx.getStop().getLine());
        this.sequences.push(seq);
        this.db.addSequence(seq);
        return (Void)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Void visitSeqCycleOnLimit(DumpFileGrammarParser.SeqCycleOnLimitContext ctx) {
        if (!this.sequences.isEmpty()) {
            this.sequences.peek().setCycleOnLimit("yes".equalsIgnoreCase(ctx.val.getText()));
        }
        return null;
    }

    @Override
    public Void visitSeqIncrement(DumpFileGrammarParser.SeqIncrementContext ctx) {
        if (!this.sequences.isEmpty() && !"?".equals(ctx.val.getText())) {
            this.sequences.peek().setIncrement(Long.parseLong(ctx.val.getText()));
        }
        return null;
    }

    @Override
    public Void visitSeqInitial(DumpFileGrammarParser.SeqInitialContext ctx) {
        if (!this.sequences.isEmpty() && !"?".equals(ctx.val.getText())) {
            this.sequences.peek().setInitialValue(Long.parseLong(ctx.val.getText()));
        }
        return null;
    }

    @Override
    public Void visitSeqMinVal(DumpFileGrammarParser.SeqMinValContext ctx) {
        if (!this.sequences.isEmpty() && !"?".equals(ctx.val.getText())) {
            this.sequences.peek().setMinValue(Long.parseLong(ctx.val.getText()));
        }
        return null;
    }

    @Override
    public Void visitSeqMaxVal(DumpFileGrammarParser.SeqMaxValContext ctx) {
        if (!this.sequences.isEmpty() && !"?".equals(ctx.val.getText())) {
            this.sequences.peek().setMaxValue(Long.parseLong(ctx.val.getText()));
        }
        return null;
    }
}

