/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.antlr.database.objects;

import com.google.common.base.Splitter;
import eu.rssw.antlr.database.objects.Field;
import eu.rssw.antlr.database.objects.Index;
import eu.rssw.antlr.database.objects.IndexField;
import eu.rssw.antlr.database.objects.Sequence;
import eu.rssw.antlr.database.objects.Table;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseDescription {
    private String dbName;
    private Map<String, Sequence> sequences = new HashMap<String, Sequence>();
    private Map<String, Table> tables = new HashMap<String, Table>();

    public DatabaseDescription(String dbName) {
        this.dbName = dbName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Collection<Sequence> getSequences() {
        return this.sequences.values();
    }

    public Sequence getSequence(String name) {
        return this.sequences.get(name);
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public Table getTable(String name) {
        return this.tables.get(name);
    }

    public void addTable(Table tbl) {
        this.tables.put(tbl.getName(), tbl);
    }

    public void addSequence(Sequence seq) {
        this.sequences.put(seq.getName(), seq);
    }

    public void serialize(OutputStream out) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(out, Charset.forName("utf-8"));
             BufferedWriter writer = new BufferedWriter(osw);){
            for (Sequence s : this.sequences.values()) {
                writer.write("S" + s.getName());
                writer.newLine();
            }
            for (Table t : this.tables.values()) {
                writer.write("T" + t.getName());
                writer.newLine();
                for (Field f : t.getFields()) {
                    writer.write("F" + f.getName() + ":" + f.getDataType() + ":" + f.getExtent());
                    writer.newLine();
                }
                for (Index i : t.getIndexes()) {
                    writer.write("I" + i.getName() + ":" + (i.isPrimary() ? "P" : "") + (i.isUnique() ? "U" : ""));
                    for (IndexField ifld : i.getFields()) {
                        writer.write(":" + (ifld.isAscending() ? (char)'A' : 'D') + ifld.getField().getName());
                    }
                    writer.newLine();
                }
            }
        }
    }

    public static DatabaseDescription deserialize(InputStream in, String name) throws IOException {
        DatabaseDescription db = new DatabaseDescription(name);
        try (InputStreamReader isr = new InputStreamReader(in);
             BufferedReader reader = new BufferedReader(isr);){
            String line = null;
            Table currTbl = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("S")) {
                    db.addSequence(new Sequence(line.substring(1)));
                    continue;
                }
                if (line.startsWith("T")) {
                    currTbl = new Table(line.substring(1));
                    db.addTable(currTbl);
                    continue;
                }
                if (line.startsWith("F")) {
                    int ch1 = line.indexOf(58);
                    int ch2 = line.lastIndexOf(58);
                    if (currTbl == null || ch1 == -1 || ch2 == -1) {
                        throw new IOException("Invalid file format: " + line);
                    }
                    Field f = new Field(line.substring(1, ch1), line.substring(ch1 + 1, ch2));
                    f.setExtent(Integer.parseInt(line.substring(ch2 + 1)));
                    currTbl.addField(f);
                    continue;
                }
                if (!line.startsWith("I")) continue;
                if (currTbl == null) {
                    throw new IOException("No associated table for " + line);
                }
                List lst = Splitter.on((char)':').trimResults().splitToList((CharSequence)line);
                if (lst.size() < 3) {
                    throw new IOException("Invalid file format: " + line);
                }
                Index i = new Index(((String)lst.get(0)).substring(1));
                i.setUnique(((String)lst.get(1)).indexOf(85) > -1);
                i.setPrimary(((String)lst.get(1)).indexOf(80) > -1);
                for (int zz = 2; zz < lst.size(); ++zz) {
                    i.addField(new IndexField(currTbl.getField(((String)lst.get(zz)).substring(1)), ((String)lst.get(zz)).charAt(0) == 'A'));
                }
                currTbl.addIndex(i);
            }
        }
        return db;
    }
}

