/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.antlr.database.objects;

import eu.rssw.antlr.database.objects.Field;
import eu.rssw.antlr.database.objects.Index;
import eu.rssw.antlr.database.objects.Trigger;
import eu.rssw.antlr.database.objects.TriggerType;
import java.util.ArrayList;
import java.util.Collection;

public class Table {
    private final String name;
    private String area;
    private String label;
    private String description;
    private String dumpName;
    private String valMsg;
    private Collection<Field> fields = new ArrayList<Field>();
    private Collection<Index> indexes = new ArrayList<Index>();
    private Collection<Trigger> triggers = new ArrayList<Trigger>();
    private int firstLine;
    private int lastLine;

    public Table(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDumpName() {
        return this.dumpName;
    }

    public void setDumpName(String dumpName) {
        this.dumpName = dumpName;
    }

    public String getValMsg() {
        return this.valMsg;
    }

    public void setValMsg(String valMsg) {
        this.valMsg = valMsg;
    }

    public Collection<Field> getFields() {
        return this.fields;
    }

    public void setFields(Collection<Field> fields) {
        this.fields = fields;
    }

    public Collection<Index> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(Collection<Index> indexes) {
        this.indexes = indexes;
    }

    public Collection<Trigger> getTriggers() {
        return this.triggers;
    }

    public int getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(int firstLine) {
        this.firstLine = firstLine;
    }

    public int getLastLine() {
        return this.lastLine;
    }

    public void setLastLine(int lastLine) {
        this.lastLine = lastLine;
    }

    public Field getField(String name) {
        for (Field fld : this.fields) {
            if (!fld.getName().equalsIgnoreCase(name)) continue;
            return fld;
        }
        return null;
    }

    public Index getIndex(String name) {
        for (Index idx : this.indexes) {
            if (!idx.getName().equalsIgnoreCase(name)) continue;
            return idx;
        }
        return null;
    }

    public Trigger getTrigger(TriggerType type) {
        for (Trigger trig : this.triggers) {
            if (trig.getType() != type) continue;
            return trig;
        }
        return null;
    }

    public void addIndex(Index index) {
        this.indexes.add(index);
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public void addTrigger(Trigger trigger) {
        this.triggers.add(trigger);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            return ((Table)obj).name.equalsIgnoreCase(this.name);
        }
        return false;
    }

    public String toString() {
        return "Table " + this.name;
    }
}

