/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.listing;

import eu.rssw.listing.BlockType;
import java.util.ArrayList;
import java.util.Collection;

public class CodeBlock {
    private final BlockType type;
    private final int lineNumber;
    private final boolean transaction;
    private final String label;
    private Collection<String> buffers;
    private Collection<String> frames;

    public CodeBlock(BlockType type, int lineNumber, boolean transaction, String label) {
        this.type = type;
        this.lineNumber = lineNumber;
        this.transaction = transaction;
        this.label = label;
    }

    public BlockType getType() {
        return this.type;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isTransaction() {
        return this.transaction;
    }

    public String getLabel() {
        return this.label;
    }

    public void appendBuffer(String buffer) {
        if (this.buffers == null) {
            this.buffers = new ArrayList<String>();
        }
        this.buffers.add(buffer);
    }

    public void appendFrame(String frame) {
        if (this.frames == null) {
            this.frames = new ArrayList<String>();
        }
        this.frames.add(frame);
    }

    public Collection<String> getBuffers() {
        return this.buffers;
    }

    public Collection<String> getFrames() {
        return this.frames;
    }

    public String toString() {
        return this.type.name() + " - " + this.getLineNumber() + " - " + this.transaction + " - " + this.label;
    }
}

