/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.listing;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.primitives.Ints;
import eu.rssw.listing.BlockType;
import eu.rssw.listing.CodeBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListingParser {
    private static final Logger LOG = LoggerFactory.getLogger(ListingParser.class);
    private final List<CodeBlock> blocks = new ArrayList<CodeBlock>();
    private final String relativeName;

    public ListingParser(File file, String relativeName) throws IOException {
        if (file.getAbsolutePath().indexOf(32) != -1) {
            throw new IllegalArgumentException("File name shouldn't contain space character - '" + file.getAbsolutePath() + "'");
        }
        this.relativeName = relativeName;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            this.parseFile(reader);
        }
    }

    public ListingParser(BufferedReader reader, String relativeName) throws IOException {
        this.relativeName = relativeName;
        this.parseFile(reader);
    }

    public Collection<CodeBlock> getBlocks() {
        return this.blocks;
    }

    public Collection<CodeBlock> getTransactionBlocks() {
        return Collections2.filter(this.blocks, (Predicate)new Predicate<CodeBlock>(){

            public boolean apply(CodeBlock input) {
                return input.isTransaction();
            }
        });
    }

    public Collection<CodeBlock> getBlocksWithBuffer() {
        return Collections2.filter(this.blocks, (Predicate)new Predicate<CodeBlock>(){

            public boolean apply(CodeBlock input) {
                return input.getBuffers() != null;
            }
        });
    }

    public CodeBlock getMainBlock() {
        Iterator iter = Collections2.filter(this.blocks, (Predicate)new Predicate<CodeBlock>(){

            public boolean apply(CodeBlock input) {
                return input.getLineNumber() == 0;
            }
        }).iterator();
        if (iter.hasNext()) {
            return (CodeBlock)iter.next();
        }
        return null;
    }

    private void parseFile(BufferedReader reader) throws IOException {
        String str;
        boolean sourceDone = false;
        boolean newPage = true;
        boolean frames = false;
        int fileLineNumber = 0;
        while ((str = reader.readLine()) != null) {
            ++fileLineNumber;
            if (str.length() == 0) continue;
            if (newPage |= str.charAt(0) == '\f') {
                String str3;
                String str2;
                String str1;
                newPage = false;
                if (sourceDone) {
                    str1 = reader.readLine();
                    str2 = reader.readLine();
                    str3 = reader.readLine();
                    if (str1 == null || str2 == null || str3 == null) {
                        return;
                    }
                } else {
                    str1 = reader.readLine();
                    str2 = reader.readLine();
                    str3 = reader.readLine();
                    if (str1 != null && str2 != null && str3 != null && !str2.startsWith("{} Line Blk")) {
                        sourceDone = true;
                    }
                }
                fileLineNumber += 3;
                continue;
            }
            if (!sourceDone) continue;
            if (str.charAt(0) == ' ') {
                if ("frames:".equalsIgnoreCase(str.substring(0, 12).trim())) {
                    frames = true;
                }
                if (this.blocks.isEmpty()) {
                    LOG.error("No matching block in {} at line {}, please report issue", (Object)this.relativeName, (Object)fileLineNumber);
                    continue;
                }
                if (frames) {
                    this.blocks.get(this.blocks.size() - 1).appendFrame(str.substring(13));
                    continue;
                }
                this.blocks.get(this.blocks.size() - 1).appendBuffer(str.substring(13));
                continue;
            }
            List splitter = Splitter.on((char)' ').trimResults().omitEmptyStrings().limit(5).splitToList((CharSequence)str);
            if (splitter.size() < 4) {
                return;
            }
            Integer lineNumber = Ints.tryParse((String)((String)splitter.get(1)));
            BlockType type = BlockType.getBlockType(((String)splitter.get(2)).toUpperCase());
            boolean transaction = "Yes".equals(splitter.get(3));
            frames = false;
            if (type != null) {
                this.blocks.add(new CodeBlock(type, lineNumber == null ? -1 : lineNumber, transaction, splitter.size() == 5 ? (String)splitter.get(4) : ""));
                continue;
            }
            LOG.error("Unknown block type {} in {} at line {}, please report issue", new Object[]{((String)splitter.get(2)).toUpperCase(), this.relativeName, fileLineNumber});
        }
    }
}

