/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.antlr.profiler;

import eu.rssw.antlr.profiler.FileCoverage;
import eu.rssw.antlr.profiler.Module;
import java.util.ArrayList;
import java.util.Collection;

public class CoverageSession {
    private final Collection<FileCoverage> files = new ArrayList<FileCoverage>();

    public void addCoverage(Module module) {
        FileCoverage file = this.getFile(module.getModuleObject());
        if (file == null) {
            file = new FileCoverage(module.getModuleObject());
            this.files.add(file);
        }
        file.addLinesToCover(module.getLinesToCover());
        file.addCoveredLines(module.getCoveredLines());
    }

    public Collection<FileCoverage> getFiles() {
        return this.files;
    }

    public void mergeWith(CoverageSession session) {
        for (FileCoverage f : session.getFiles()) {
            FileCoverage file = this.getFile(f.getFileName());
            if (file == null) {
                file = new FileCoverage(f.getFileName());
                this.files.add(file);
            }
            file.addLinesToCover(f.getLinesToCover());
            file.addCoveredLines(f.getCoveredLines());
        }
    }

    private FileCoverage getFile(String name) {
        for (FileCoverage file : this.files) {
            if (!file.getFileName().equals(name)) continue;
            return file;
        }
        return null;
    }
}

