/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.antlr.profiler;

import java.util.Comparator;

public class LineData {
    private final int lineNumber;
    private final int execCount;
    private final float actualTime;
    private final float cumulativeTime;

    public LineData(int lineNumber, int execCount, float actualTime, float cumulativeTime) {
        this.lineNumber = lineNumber;
        this.execCount = execCount;
        this.actualTime = actualTime;
        this.cumulativeTime = cumulativeTime;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getExecCount() {
        return this.execCount;
    }

    public float getActualTime() {
        return this.actualTime;
    }

    public float getCumulativeTime() {
        return this.cumulativeTime;
    }

    public int hashCode() {
        return this.lineNumber;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            return ((LineData)obj).lineNumber == this.lineNumber;
        }
        return false;
    }

    public String toString() {
        return this.lineNumber + (this.execCount == 0 ? "" : " x" + this.execCount);
    }

    public static class CumulativeTimeComparator
    implements Comparator<LineData> {
        @Override
        public int compare(LineData o1, LineData o2) {
            return (int)(o1.getCumulativeTime() * 1000000.0f) - (int)(o2.getCumulativeTime() * 1000000.0f);
        }
    }
}

