/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.antlr.profiler;

import eu.rssw.antlr.profiler.LineData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Module
implements Comparable<Module> {
    private final int id;
    private final int crc;
    private final String name;
    private final String debugListingFile;
    private final Set<LineData> lineData = new HashSet<LineData>();

    public Module(int id, String name, String file, int crc) {
        this.id = id;
        this.name = name;
        this.debugListingFile = file;
        this.crc = crc;
    }

    public Module(int id, Module module) {
        this.id = id;
        this.name = module.getName();
        this.debugListingFile = module.getFile();
        this.crc = module.getCrc();
        this.lineData.addAll(module.getLineData());
    }

    public int getId() {
        return this.id;
    }

    public int getCrc() {
        return this.crc;
    }

    public String getName() {
        return this.name;
    }

    public Set<LineData> getLineData() {
        return this.lineData;
    }

    public String getModuleObject() {
        if (this.name.indexOf(32) > -1) {
            String tmp = this.name.substring(this.name.indexOf(32) + 1);
            if (tmp.indexOf(32) > -1) {
                return tmp.substring(0, tmp.indexOf(32));
            }
            return tmp;
        }
        return this.name;
    }

    public String getProcName() {
        if (this.name.indexOf(32) > -1) {
            return this.name.substring(0, this.name.indexOf(32));
        }
        return "";
    }

    public String getFile() {
        return this.debugListingFile;
    }

    public float getCumulativeTime() {
        float result = 0.0f;
        for (LineData data : this.lineData) {
            result += data.getActualTime();
        }
        return result;
    }

    public void addLineSummary(LineData data) {
        if (data.getLineNumber() == 0) {
            return;
        }
        this.lineData.add(data);
    }

    public void addLineToCover(int lineNumber) {
        if (lineNumber == 0) {
            return;
        }
        this.lineData.add(new LineData(lineNumber, 0, 0.0f, 0.0f));
    }

    public List<Integer> getLinesToCover() {
        ArrayList<Integer> rslt = new ArrayList<Integer>();
        for (LineData line : this.lineData) {
            rslt.add(line.getLineNumber());
        }
        Collections.sort(rslt);
        return rslt;
    }

    public List<Integer> getCoveredLines() {
        ArrayList<Integer> rslt = new ArrayList<Integer>();
        for (LineData line : this.lineData) {
            if (line.getExecCount() <= 0) continue;
            rslt.add(line.getLineNumber());
        }
        Collections.sort(rslt);
        return rslt;
    }

    public String toString() {
        return "Module " + this.id + " - " + this.name + " - " + this.debugListingFile + " - " + this.crc;
    }

    @Override
    public int compareTo(Module o) {
        return Integer.valueOf(this.id).compareTo(o.getId());
    }
}

