/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.antlr.profiler;

import eu.rssw.antlr.profiler.CoverageSession;
import eu.rssw.antlr.profiler.LineData;
import eu.rssw.antlr.profiler.Module;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ProfilerSession {
    private final String description;
    private final String user;
    private final int version;
    private Date timestamp;
    private Collection<Module> moduleList = new ArrayList<Module>();
    private Map<Integer, Module> allModules = new HashMap<Integer, Module>();
    private Map<Integer, Module> modules = new HashMap<Integer, Module>();
    private Map<String, Module> modulesLookup = new HashMap<String, Module>();
    private int[][] adjMatrix = null;
    private int highestModuleId = -1;
    private final DateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public ProfilerSession(String description, String user, String timestamp, String version) {
        this.description = description;
        this.user = user;
        int tmp = -1;
        try {
            tmp = Integer.parseInt(version);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.version = tmp;
        try {
            this.timestamp = this.dateFormatter.parse(timestamp);
        }
        catch (ParseException caught) {
            this.timestamp = new Date(System.currentTimeMillis());
        }
    }

    public int getVersionNumber() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUser() {
        return this.user;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void addCall(int callerId, int calleeId, int count) {
        int[] nArray = this.adjMatrix[callerId];
        int n = calleeId;
        nArray[n] = nArray[n] + count;
    }

    public void initializeCallTreeMatrix() {
        if (this.adjMatrix != null) {
            throw new RuntimeException("Matrix already initialized");
        }
        this.adjMatrix = new int[this.highestModuleId + 1][this.highestModuleId + 1];
    }

    public boolean isCallTreeInitialized() {
        return this.adjMatrix != null;
    }

    public int[][] getCallTreeData() {
        return this.adjMatrix;
    }

    public CoverageSession getCoverage() {
        CoverageSession session = new CoverageSession();
        for (Module module : this.moduleList) {
            session.addCoverage(module);
        }
        return session;
    }

    public void addModule(Module module) {
        this.allModules.put(module.getId(), module);
        Module m1 = this.modulesLookup.get(module.getModuleObject());
        int n = this.highestModuleId = module.getId() > this.highestModuleId ? module.getId() : this.highestModuleId;
        if (m1 == null) {
            this.moduleList.add(module);
            this.modules.put(module.getId(), module);
            this.modulesLookup.put(module.getName(), module);
        } else {
            this.modules.put(module.getId(), m1);
        }
    }

    public Collection<Module> getModules() {
        return this.moduleList;
    }

    public Module getModuleById(int id) {
        return this.modules.get(id);
    }

    public Module getFromAllModulesById(int id) {
        return this.allModules.get(id);
    }

    public Module getModuleByName(String name) {
        return this.modulesLookup.get(name);
    }

    public Map<String, Set<LineData>> getCoverageByFile() {
        HashMap<String, Set<LineData>> map = new HashMap<String, Set<LineData>>();
        for (Module module : this.modules.values()) {
            if (module.getLineData().isEmpty()) continue;
            map.put(module.getModuleObject(), module.getLineData());
        }
        return map;
    }

    public void printCallTree(PrintStream out) {
        for (int zz = 0; zz < this.adjMatrix.length; ++zz) {
            for (int yy = 0; yy < this.adjMatrix.length; ++yy) {
                out.print(this.adjMatrix[zz][yy] + " ");
            }
            out.println();
        }
        out.println("SESSION : ");
        this.printCallTreeLine(out, 0, 2);
    }

    private void printCallTreeLine(PrintStream out, int moduleId, int tabs) {
        for (int zz = 0; zz < this.moduleList.size(); ++zz) {
            int calleeId = this.adjMatrix[moduleId][zz];
            if (calleeId == 0) continue;
            for (int kk = 0; kk < tabs; ++kk) {
                out.print(" ");
            }
            out.println(moduleId + " -- " + this.modules.get(zz).toString());
            this.printCallTreeLine(out, zz, tabs + 1);
        }
    }
}

