/*
 * Decompiled with CFR 0.152.
 */
package eu.rssw.antlr.profiler;

import eu.rssw.antlr.profiler.LineData;
import eu.rssw.antlr.profiler.Module;
import eu.rssw.antlr.profiler.ProfilerGrammarBaseVisitor;
import eu.rssw.antlr.profiler.ProfilerGrammarParser;
import eu.rssw.antlr.profiler.ProfilerSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.tree.RuleNode;

public class ProfilerSessionVisitor
extends ProfilerGrammarBaseVisitor<Void> {
    private final List<Module> modules = new ArrayList<Module>();
    private ProfilerSession session;
    private Module lastModule;

    public ProfilerSession getSession() {
        return this.session;
    }

    @Override
    public Void visitDescription(ProfilerGrammarParser.DescriptionContext ctx) {
        if (this.session != null) {
            throw new IllegalStateException("Session already created");
        }
        this.session = new ProfilerSession(ctx.desc.getText(), ctx.author.getText(), ctx.date.getText() + " " + ctx.time.getText(), ctx.version.getText());
        return null;
    }

    @Override
    public Void visitModule_data_line(ProfilerGrammarParser.Module_data_lineContext ctx) {
        this.modules.add(new Module(Integer.parseInt(ctx.id.getText()), ctx.name.getText(), ctx.debugListingFile.getText(), Integer.parseInt(ctx.crc.getText())));
        return null;
    }

    @Override
    public Void visitCall_tree_data(ProfilerGrammarParser.Call_tree_dataContext ctx) {
        Collections.sort(this.modules);
        for (Module m : this.modules) {
            this.session.addModule(m);
        }
        this.session.initializeCallTreeMatrix();
        return (Void)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Void visitCall_tree_data_line(ProfilerGrammarParser.Call_tree_data_lineContext ctx) {
        this.session.addCall(Integer.parseInt(ctx.callerId.getText()), Integer.parseInt(ctx.calleeId.getText()), Integer.parseInt(ctx.callCount.getText()));
        return null;
    }

    @Override
    public Void visitLine_summary_line(ProfilerGrammarParser.Line_summary_lineContext ctx) {
        Module module = this.session.getModuleById(Integer.parseInt(ctx.moduleId.getText()));
        if (module != null) {
            module.addLineSummary(new LineData(Integer.parseInt(ctx.lineNumber.getText()), Integer.parseInt(ctx.execCount.getText()), Float.parseFloat(ctx.actualTime.getText()), Float.parseFloat(ctx.cumulativeTime.getText())));
        }
        return null;
    }

    @Override
    public Void visitCoverage_section(ProfilerGrammarParser.Coverage_sectionContext ctx) {
        this.lastModule = this.session.getModuleById(Integer.parseInt(ctx.moduleId.getText()));
        return (Void)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Void visitCoverage_section_line(ProfilerGrammarParser.Coverage_section_lineContext ctx) {
        this.lastModule.addLineToCover(Integer.parseInt(ctx.linenum.getText()));
        return null;
    }
}

