/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core;

import antlr.Token;
import antlr.collections.AST;
import antlr.collections.ASTEnumeration;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.AttributeKey;
import org.prorefactor.core.AttributeValue;
import org.prorefactor.core.FlatListBuilder;
import org.prorefactor.core.ICallback;
import org.prorefactor.core.JPNodeQuery;
import org.prorefactor.core.ProToken;
import org.prorefactor.treeparser.Call;
import org.prorefactor.treeparser.symbols.FieldContainer;
import org.prorefactor.treeparser.symbols.Symbol;

public class JPNode
implements AST {
    private ProToken token;
    private JPNode down;
    private JPNode right;
    private JPNode left;
    private JPNode up;
    private Map<Integer, Integer> attrMap;
    private Map<String, String> attrMapStrings;
    private Map<Integer, Object> linkMap;
    private Map<Integer, String> stringAttributes;
    private static final BiMap<Integer, String> attrStrEqs = HashBiMap.create();

    public JPNode(ProToken t) {
        this.token = t;
        this.setType(t.getType());
    }

    protected void backLink() {
        JPNode currNode = this.down;
        while (currNode != null) {
            currNode.up = this;
            currNode.backLink();
            JPNode nextNode = currNode.right;
            if (nextNode != null) {
                nextNode.left = currNode;
            }
            currNode = nextNode;
        }
    }

    protected void finalizeTrailingHidden() {
        ProToken lastT;
        JPNode tailNode = this.down;
        if (tailNode == null || tailNode.getNodeType() == ABLNodeType.PROGRAM_TAIL) {
            return;
        }
        JPNode lastNode = tailNode;
        while (tailNode != null && tailNode.getNodeType() != ABLNodeType.PROGRAM_TAIL) {
            lastNode = tailNode;
            tailNode = tailNode.getNextSibling();
        }
        if (tailNode == null || tailNode.getNodeType() != ABLNodeType.PROGRAM_TAIL) {
            return;
        }
        lastNode = lastNode.getLastDescendant();
        for (ProToken tempT = lastT = lastNode.getHiddenAfter(); tempT != null; tempT = (ProToken)tempT.getHiddenAfter()) {
            lastT = tempT;
        }
        tailNode.setHiddenBefore(lastT);
    }

    public void addChild(AST child) {
        if (child == null) {
            return;
        }
        JPNode node = this.down;
        if (node != null) {
            while (node.right != null) {
                node = node.right;
            }
            node.right = (JPNode)child;
        } else {
            this.down = (JPNode)child;
        }
    }

    public int getNumberOfChildren() {
        int n = 0;
        JPNode node = this.down;
        if (node != null) {
            n = 1;
            while (node.right != null) {
                node = node.right;
                ++n;
            }
            return n;
        }
        return n;
    }

    public void initialize(int t, String txt) {
        this.setType(t);
        this.setText(txt);
    }

    public void initialize(AST t) {
        this.setType(t.getType());
        this.setText(t.getText());
    }

    public void initialize(Token t) {
        this.token = (ProToken)t;
        this.setType(t.getType());
    }

    public JPNode getFirstChild() {
        return this.down;
    }

    public JPNode getNextSibling() {
        return this.right;
    }

    public String getText() {
        return this.token.getText();
    }

    public int getType() {
        return this.token.getType();
    }

    public int getLine() {
        return this.token.getLine();
    }

    public int getColumn() {
        return this.token.getColumn();
    }

    public void setFirstChild(AST c) {
        this.down = (JPNode)c;
    }

    public void setNextSibling(AST n) {
        this.right = (JPNode)n;
    }

    public void setText(String text) {
        this.token.setText(text);
    }

    public void setType(int type) {
        this.token.setType(type);
    }

    public void updateEndPosition(int file, int line, int col) {
        this.token = new ProToken(this.token.getNodeType(), this.token.getText(), this.token.getFileIndex(), this.token.getFilename(), this.token.getLine(), this.token.getColumn(), file, line, col, this.token.getMacroSourceNum(), this.token.getAnalyzeSuspend(), this.token.isSynthetic(), this.token.isMacroExpansion());
    }

    public boolean equals(AST t) {
        throw new UnsupportedOperationException();
    }

    public String toStringList() {
        throw new UnsupportedOperationException();
    }

    public String toStringTree() {
        throw new UnsupportedOperationException();
    }

    public boolean equalsList(AST t) {
        throw new UnsupportedOperationException();
    }

    public boolean equalsListPartial(AST sub) {
        throw new UnsupportedOperationException();
    }

    public boolean equalsTree(AST t) {
        throw new UnsupportedOperationException();
    }

    public boolean equalsTreePartial(AST sub) {
        throw new UnsupportedOperationException();
    }

    public ASTEnumeration findAll(AST target) {
        throw new UnsupportedOperationException();
    }

    public ASTEnumeration findAllPartial(AST sub) {
        throw new UnsupportedOperationException();
    }

    public ABLNodeType getNodeType() {
        return this.token.getNodeType();
    }

    public int getSourceNum() {
        return this.token.getMacroSourceNum();
    }

    public int getEndLine() {
        return this.token.getEndLine();
    }

    public int getEndColumn() {
        return this.token.getEndColumn();
    }

    public String getFilename() {
        return this.token.getFilename();
    }

    public int getFileIndex() {
        return this.token.getFileIndex();
    }

    public int getEndFileIndex() {
        return this.token.getEndFileIndex();
    }

    public ProToken getHiddenAfter() {
        return (ProToken)this.token.getHiddenAfter();
    }

    public ProToken getHiddenBefore() {
        return (ProToken)this.token.getHiddenBefore();
    }

    public boolean isMacroExpansion() {
        return this.token.isMacroExpansion();
    }

    public String getAnalyzeSuspend() {
        return this.token.getAnalyzeSuspend();
    }

    public JPNode getParent() {
        return this.up;
    }

    public JPNode getPreviousSibling() {
        return this.left;
    }

    public JPNode firstNaturalChild() {
        if (this.token.isNatural()) {
            return this;
        }
        JPNode n = this.down;
        while (n != null) {
            if (n.token.isNatural()) {
                return n;
            }
            n = n.down;
        }
        return null;
    }

    public JPNode getLastDescendant() {
        if (this.down == null) {
            return this;
        }
        JPNode node = this.down;
        while (node.right != null) {
            node = node.right;
        }
        return node.getLastDescendant();
    }

    public JPNode nextNode() {
        return this.down == null ? this.right : this.down;
    }

    public JPNode getPreviousNode() {
        return this.left == null ? this.up : this.left;
    }

    public List<JPNode> getDirectChildren() {
        ArrayList<JPNode> ret = new ArrayList<JPNode>();
        for (JPNode n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            ret.add(n);
        }
        return ret;
    }

    public List<JPNode> query(ABLNodeType type, ABLNodeType ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(type, findTypes);
        this.walk(query);
        return query.getResult();
    }

    public List<JPNode> queryMainFile(ABLNodeType type, ABLNodeType ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(false, true, null, type, findTypes);
        this.walk(query);
        return query.getResult();
    }

    public List<JPNode> queryStateHead(ABLNodeType type, ABLNodeType ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(true, type, findTypes);
        this.walk(query);
        return query.getResult();
    }

    public List<JPNode> queryCurrentStatement(ABLNodeType type, ABLNodeType ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(false, false, this.getStatement(), type, findTypes);
        this.walk(query);
        return query.getResult();
    }

    @Deprecated
    public List<JPNode> query(Integer ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(findTypes);
        this.walk(query);
        return query.getResult();
    }

    @Deprecated
    public List<JPNode> queryMainFile(Integer ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(false, true, null, findTypes);
        this.walk(query);
        return query.getResult();
    }

    @Deprecated
    public List<JPNode> queryStateHead(Integer ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(true, findTypes);
        this.walk(query);
        return query.getResult();
    }

    public ProToken findFirstHiddenAfterLastDescendant() {
        JPNode nextNatural = this.getNextSibling();
        if (nextNatural == null) {
            return null;
        }
        if (nextNatural.getNodeType() != ABLNodeType.PROGRAM_TAIL && (nextNatural = nextNatural.firstNaturalChild()) == null) {
            return null;
        }
        return nextNatural.getHiddenFirst();
    }

    public JPNode findDirectChild(ABLNodeType nodeType) {
        for (JPNode node = this.down; node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != nodeType) continue;
            return node;
        }
        return null;
    }

    public JPNode findDirectChild(int nodeType) {
        return this.findDirectChild(ABLNodeType.getNodeType(nodeType));
    }

    public int attrGet(int key) {
        if (this.attrMap != null && this.attrMap.containsKey(key)) {
            return this.attrMap.get(key);
        }
        switch (key) {
            case 1700: {
                return this.isAbbreviated() ? 1 : 0;
            }
            case 2300: {
                return this.token.getMacroSourceNum();
            }
        }
        return 0;
    }

    public String attrGetS(int attrNum) {
        if (attrNum != 2400) {
            throw new IllegalArgumentException("Invalid value " + attrNum);
        }
        if (this.stringAttributes != null && this.stringAttributes.containsKey(attrNum)) {
            return this.stringAttributes.get(attrNum);
        }
        return "";
    }

    public String attrGetS(String attrName) {
        String ret;
        if ("qualified-class".equalsIgnoreCase(attrName)) {
            throw new IllegalArgumentException("Invalid value " + attrName);
        }
        if (this.attrMapStrings != null && (ret = this.attrMapStrings.get(attrName)) != null) {
            return ret;
        }
        Integer intKey = JPNode.attrEq(attrName);
        if (intKey != null) {
            return this.attrGetS(intKey);
        }
        return "";
    }

    public void attrSet(int key, String value) {
        if (this.stringAttributes == null) {
            this.stringAttributes = new HashMap<Integer, String>();
        }
        this.stringAttributes.put(key, value);
    }

    public void attrSet(Integer key, int val) {
        if (this.attrMap == null) {
            this.initAttrMap();
        }
        this.attrMap.put(key, val);
    }

    public void attrSetS(String key, String value) {
        if (this.attrMapStrings == null) {
            this.attrMapStrings = new HashMap<String, String>();
        }
        this.attrMapStrings.put(key, value);
    }

    public void setOperator() {
        this.attrSet((Integer)1200, 1);
    }

    public Object getLink(Integer key) {
        if (this.linkMap == null) {
            return null;
        }
        return this.linkMap.get(key);
    }

    public JPNode getOriginal() {
        if (this.linkMap == null) {
            return null;
        }
        return (JPNode)this.linkMap.get(-216);
    }

    public int getState2() {
        return this.attrGet(1300);
    }

    public Call getCall() {
        return (Call)this.getLink(-218);
    }

    public void setStatementHead() {
        this.attrSet((Integer)1400, 1);
    }

    public void setStatementHead(int state2) {
        this.attrSet((Integer)1400, 1);
        if (state2 != 0) {
            this.attrSet((Integer)1300, state2);
        }
    }

    public Symbol getSymbol() {
        return (Symbol)this.getLink(-210);
    }

    private static Integer attrEq(String attrName) {
        return (Integer)attrStrEqs.inverse().get((Object)attrName);
    }

    public boolean hasTableBuffer() {
        return this.getLink(-210) != null;
    }

    public boolean hasBufferScope() {
        return this.getLink(-212) != null;
    }

    public boolean hasBlock() {
        return this.getLink(-214) != null;
    }

    public boolean hasProparseDirective(String directive) {
        for (ProToken tok = this.getHiddenBefore(); tok != null; tok = (ProToken)tok.getHiddenBefore()) {
            String str;
            if (tok.getNodeType() != ABLNodeType.PROPARSEDIRECTIVE || !(str = tok.getText().trim()).startsWith("prolint-nowarn(") || str.charAt(str.length() - 1) != ')') continue;
            for (String rule : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)str.substring(15, str.length() - 1))) {
                if (!rule.equals(directive)) continue;
                return true;
            }
        }
        if (this.token.isSynthetic()) {
            JPNode child = this.down;
            if (child != null && child.hasProparseDirective(directive)) {
                return true;
            }
            if (child != null && this.token.getNodeType() == ABLNodeType.ASSIGN && (child = child.getFirstChild()) != null && child.hasProparseDirective(directive)) {
                return true;
            }
        }
        return false;
    }

    public String getComments() {
        String ret = (String)this.getLink(-215);
        if (ret != null) {
            return ret;
        }
        StringBuilder buff = new StringBuilder();
        boolean hasComment = false;
        int filenum = this.getFileIndex();
        for (ProToken t = this.getHiddenBefore(); t != null && t.getFileIndex() == filenum; t = (ProToken)t.getHiddenBefore()) {
            if (t.getNodeType() == ABLNodeType.WS) {
                if (t.getText().indexOf(10) <= -1) continue;
                buff.insert(0, '\n');
                continue;
            }
            if (t.getNodeType() != ABLNodeType.COMMENT) break;
            buff.insert(0, t.getText());
            hasComment = true;
        }
        return hasComment ? buff.toString() : null;
    }

    public FieldContainer getFieldContainer() {
        return (FieldContainer)this.getLink(-217);
    }

    public ProToken getHiddenFirst() {
        ProToken t = this.getHiddenBefore();
        if (t != null) {
            ProToken ttemp = t;
            while (ttemp != null) {
                t = ttemp;
                ttemp = (ProToken)t.getHiddenBefore();
            }
        }
        return t;
    }

    public List<ProToken> getHiddenTokens() {
        LinkedList<ProToken> ret = new LinkedList<ProToken>();
        for (ProToken tkn = this.getHiddenBefore(); tkn != null; tkn = (ProToken)tkn.getHiddenBefore()) {
            ret.addFirst(tkn);
        }
        return ret;
    }

    public JPNode getStatement() {
        JPNode n;
        for (n = this; n != null && !n.isStateHead(); n = n.getParent()) {
        }
        return n;
    }

    public JPNode getParent(ABLNodeType type) {
        if (type == this.getNodeType()) {
            return this;
        }
        if (this.isStateHead()) {
            return null;
        }
        if (this.getParent() != null) {
            return this.getParent().getParent(type);
        }
        return null;
    }

    public String getAnnotationName() {
        if (this.getNodeType() != ABLNodeType.ANNOTATION) {
            return "";
        }
        StringBuilder annName = new StringBuilder(this.token.getText().substring(1));
        for (JPNode tok = this.down; tok != null && tok.getNodeType() != ABLNodeType.PERIOD && tok.getNodeType() != ABLNodeType.LEFTPAREN; tok = tok.getNextSibling()) {
            annName.append(tok.getText());
        }
        return annName.toString();
    }

    private void initAttrMap() {
        if (this.attrMap == null) {
            this.attrMap = new HashMap<Integer, Integer>();
        }
    }

    private void initLinkMap() {
        if (this.linkMap == null) {
            this.linkMap = new HashMap<Integer, Object>();
        }
    }

    public boolean isAbbreviated() {
        return this.token.getNodeType().isAbbreviated(this.getText());
    }

    public boolean isEditableInAB() {
        return this.firstNaturalChild().token.isEditableInAB();
    }

    public boolean isNatural() {
        return this.token.isNatural();
    }

    public boolean isStateHead() {
        return this.attrGet(1400) == 1;
    }

    public void setCall(Call call) {
        this.setLink(-218, call);
    }

    public void setComments(String comments) {
        this.setLink(-215, comments);
    }

    public void setFieldContainer(FieldContainer fieldContainer) {
        this.setLink(-217, fieldContainer);
    }

    public void setLink(Integer key, Object value) {
        if (this.linkMap == null) {
            this.initLinkMap();
        }
        this.linkMap.put(key, value);
    }

    public void setSymbol(Symbol symbol) {
        this.setLink(-210, symbol);
    }

    public void copyHiddenAfter(JPNode to) {
        to.setHiddenAfter(this.getHiddenAfter());
    }

    public void copyHiddenBefore(JPNode to) {
        to.setHiddenBefore(this.getHiddenBefore());
    }

    public void setHiddenAfter(ProToken t) {
        this.token.setHiddenAfter(t);
    }

    public void setHiddenBefore(ProToken t) {
        this.token.setHiddenBefore(t);
    }

    public void setNextSiblingWithLinks(AST n) {
        JPNode next;
        for (next = this.getNextSibling(); next != null; next = next.getNextSibling()) {
            next.up = null;
        }
        this.setNextSibling(n);
        for (next = this.getNextSibling(); next != null; next = next.getNextSibling()) {
            next.up = this.up;
        }
    }

    public int size() {
        int sz = 1;
        for (JPNode node : this.getDirectChildren()) {
            sz += node.size();
        }
        return sz;
    }

    public int naturalSize() {
        int sz = this.isNatural() ? 1 : 0;
        for (JPNode node : this.getDirectChildren()) {
            sz += node.naturalSize();
        }
        return sz;
    }

    public int compareTo(org.prorefactor.proparse.antlr4.JPNode other, int level) {
        if (this.token.getNodeType() == ABLNodeType.EOF && other.getNodeType() == ABLNodeType.EOF_ANTLR4) {
            return 0;
        }
        if (other == null) {
            System.err.println(CharBuffer.allocate(level).toString().replace('\u0000', ' ') + " -- No token");
            return 1;
        }
        if (!this.token.getText().equals(other.getText()) || this.token.getNodeType() != other.getNodeType()) {
            System.err.println(CharBuffer.allocate(level).toString().replace('\u0000', ' ') + " -- Token: " + this.token + " -- " + other.getText() + " ** " + (Object)((Object)other.getNodeType()));
            return 2;
        }
        if (this.attrMap != null) {
            for (Map.Entry<Object, Object> entry : this.attrMap.entrySet()) {
                if (((Integer)entry.getValue()).equals(other.attrGet((Integer)entry.getKey()))) continue;
                System.err.println(CharBuffer.allocate(level).toString().replace('\u0000', ' ') + " -- AttrMap[" + entry.getKey() + "]: " + entry.getValue() + " -- " + other.attrGet((Integer)entry.getKey()));
                return 7;
            }
        }
        if (this.attrMapStrings != null) {
            for (Map.Entry<Object, Object> entry : this.attrMapStrings.entrySet()) {
                if (((String)entry.getValue()).equals(other.attrGetS((String)entry.getKey()))) continue;
                System.err.println(CharBuffer.allocate(level).toString().replace('\u0000', ' ') + " -- AttrMapStrings[" + (String)entry.getKey() + "]: " + (String)entry.getValue() + " -- " + other.attrGetS((String)entry.getKey()));
                return 8;
            }
        }
        if (this.stringAttributes != null) {
            for (Map.Entry<Object, Object> entry : this.stringAttributes.entrySet()) {
                if (((String)entry.getValue()).equals(other.attrGetS((Integer)entry.getKey()))) continue;
                System.err.println(CharBuffer.allocate(level).toString().replace('\u0000', ' ') + " -- StringAttributes[" + entry.getKey() + "]: " + (String)entry.getValue() + " -- " + other.attrGetS((Integer)entry.getKey()));
                return 9;
            }
        }
        if (this.down == null && other.getFirstChild() != null) {
            System.err.println(CharBuffer.allocate(level + 1).toString().replace('\u0000', ' ') + " -- No down: " + this);
            return 3;
        }
        if (this.down != null && this.down.compareTo(other.getFirstChild(), level + 1) != 0) {
            System.err.println(CharBuffer.allocate(level + 1).toString().replace('\u0000', ' ') + " -- Down:  " + this.down + " -- " + other.getFirstChild());
            return 4;
        }
        if (this.right == null && other.getNextSibling() != null) {
            System.err.println(CharBuffer.allocate(level).toString().replace('\u0000', ' ') + " -- No right: " + this);
            return 5;
        }
        if (this.right != null && this.right.compareTo(other.getNextSibling(), level) != 0) {
            System.err.println(CharBuffer.allocate(level).toString().replace('\u0000', ' ') + " -- Right: " + this.right + " -- " + other.getNextSibling());
            return 6;
        }
        return 0;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append((Object)this.token.getNodeType()).append(" \"").append(this.getText()).append("\" F").append(this.getFileIndex()).append('/').append(this.getLine()).append(':').append(this.getColumn());
        return buff.toString();
    }

    public String toStringFulltext() {
        FlatListBuilder callback = new FlatListBuilder();
        this.walk(callback);
        List list = (List)callback.getResult();
        StringBuilder bldr = new StringBuilder();
        for (JPNode node : list) {
            for (ProToken t = node.getHiddenFirst(); t != null; t = t.getNext()) {
                if (t.getNodeType() != ABLNodeType.COMMENT && t.getNodeType() != ABLNodeType.WS) continue;
                bldr.append(t.getText());
            }
            bldr.append(node.getText());
        }
        return bldr.toString();
    }

    public void walk(ICallback<?> callback) {
        if (this.attrGet(1200) == 1) {
            this.getFirstChild().walk(callback);
            callback.visitNode(this);
            this.getFirstChild().getNextSibling().walk(callback);
        } else if (callback.visitNode(this)) {
            for (JPNode child : this.getDirectChildren()) {
                child.walk(callback);
            }
        }
    }

    public String allLeadingHiddenText() {
        String ret = "";
        for (ProToken t = this.getHiddenFirst(); t != null; t = (ProToken)t.getHiddenAfter()) {
            ret = ret + t.getText();
        }
        return ret;
    }

    static {
        for (AttributeKey attributeKey : AttributeKey.values()) {
            attrStrEqs.put((Object)attributeKey.getKey(), (Object)attributeKey.getName());
        }
        for (Enum enum_ : AttributeValue.values()) {
            attrStrEqs.put((Object)((AttributeValue)enum_).getKey(), (Object)((AttributeValue)enum_).getName());
        }
    }
}

