/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core;

import java.io.IOException;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Set;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.JPNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonNodeLister {
    private static final Logger LOG = LoggerFactory.getLogger(JsonNodeLister.class);
    private final JPNode topNode;
    private final Writer ofile;
    private final Set<ABLNodeType> ignored;

    public JsonNodeLister(JPNode topNode, Writer writer, ABLNodeType ignoredKw, ABLNodeType ... ignoredKws) {
        this.topNode = topNode;
        this.ofile = writer;
        this.ignored = EnumSet.of(ignoredKw, ignoredKws);
    }

    public void print() {
        try {
            this.printSub(this.topNode, true);
        }
        catch (IOException uncaught) {
            LOG.error("Unable to write output");
        }
    }

    private boolean printSub(JPNode node, boolean firstElem) throws IOException {
        if (this.ignored.contains((Object)node.getNodeType())) {
            return false;
        }
        if (!firstElem) {
            this.ofile.write(44);
        }
        this.ofile.write(123);
        this.printAttributes(node);
        if (!node.getDirectChildren().isEmpty()) {
            boolean firstChild = true;
            this.ofile.write(", \"children\": [");
            for (JPNode child : node.getDirectChildren()) {
                firstChild &= !this.printSub(child, firstChild);
            }
            this.ofile.write(93);
        }
        this.ofile.write(125);
        return true;
    }

    private void printAttributes(JPNode node) throws IOException {
        this.ofile.write("\"name\": \"" + (Object)((Object)node.getNodeType()));
        if (node.getNodeType() == ABLNodeType.ID) {
            this.ofile.write(" [");
            this.ofile.write(node.getText().replace('\'', ' ').replace('\"', ' '));
            this.ofile.write("]");
        }
        this.ofile.write("\", \"head\": " + (node.isStateHead() ? "true" : "false") + ", \"line\": " + node.getLine() + ", \"column\": " + node.getColumn() + ", \"file\": " + node.getFileIndex());
    }
}

