/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core;

import antlr.CommonHiddenStreamToken;
import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.prorefactor.core.ABLNodeType;

public class ProToken
extends CommonHiddenStreamToken
implements Serializable {
    private static final long serialVersionUID = 6330218429653110333L;
    private ABLNodeType nodeType;
    private final boolean synthetic;
    private final int fileIndex;
    private final String fileName;
    private final int macroSourceNum;
    private final int endFile;
    private final int endLine;
    private final int endColumn;
    private final String analyzeSuspend;
    private final boolean macroExpansion;

    public ProToken(ABLNodeType type, String txt) {
        this(type, txt, 0, "", 0, 0, 0, 0, 0, 0, "", true, false);
    }

    public ProToken(@Nonnull ABLNodeType type, @Nonnull String txt, int file, String fileName, int line, int col, int endFile, int endLine, int endCol, int macroSourceNum, @Nonnull String analyzeSuspend, boolean synthetic, boolean macroExpansion) {
        super(0, txt);
        this.nodeType = type;
        this.fileIndex = file;
        this.fileName = fileName;
        this.macroSourceNum = macroSourceNum;
        this.line = line;
        this.col = col;
        this.endFile = endFile;
        this.endLine = endLine;
        this.endColumn = endCol;
        this.analyzeSuspend = analyzeSuspend;
        this.synthetic = synthetic;
        this.macroExpansion = macroExpansion;
    }

    public int getType() {
        return this.nodeType.getType();
    }

    public void setType(int type) {
        this.nodeType = ABLNodeType.getNodeType(type);
        if (this.nodeType == null) {
            throw new IllegalArgumentException("Invalid type number " + type);
        }
    }

    public ABLNodeType getNodeType() {
        return this.nodeType;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public int getMacroSourceNum() {
        return this.macroSourceNum;
    }

    public String getFilename() {
        return this.fileName;
    }

    public ProToken getNext() {
        return (ProToken)this.getHiddenAfter();
    }

    public ProToken getPrev() {
        return (ProToken)this.getHiddenBefore();
    }

    public void setHiddenAfter(ProToken t) {
        super.setHiddenAfter((CommonHiddenStreamToken)t);
    }

    public void setHiddenBefore(ProToken t) {
        super.setHiddenBefore((CommonHiddenStreamToken)t);
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndFileIndex() {
        return this.endFile;
    }

    public String getAnalyzeSuspend() {
        return this.analyzeSuspend;
    }

    public boolean isMacroExpansion() {
        return this.macroExpansion;
    }

    public boolean isEditableInAB() {
        return this.analyzeSuspend == null || ProToken.isEditableInAB(this.analyzeSuspend);
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean isNatural() {
        return !this.synthetic;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProToken) {
            ProToken tok = (ProToken)obj;
            return tok.nodeType == this.nodeType && tok.text.equals(this.text) && tok.line == this.line && tok.col == this.col && tok.fileIndex == this.fileIndex && tok.endFile == this.endFile && tok.endLine == this.endLine && tok.endColumn == this.endColumn && tok.macroSourceNum == this.macroSourceNum;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.text, this.line, this.col, this.fileIndex, this.endFile, this.endLine, this.endColumn, this.macroSourceNum});
    }

    public String toString() {
        return "[\"" + this.getText().replace('\r', ' ').replace('\n', ' ') + "\",<" + (Object)((Object)this.nodeType) + ">,macro=" + this.macroSourceNum + ",file=" + this.fileIndex + ":" + this.endFile + ",line=" + this.line + ":" + this.endLine + ",col=" + this.col + ":" + this.endColumn + "]";
    }

    public static boolean isEditableInAB(@Nonnull String str) {
        List attrs = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)str);
        if (attrs.isEmpty() || !"_UIB-CODE-BLOCK".equalsIgnoreCase((String)attrs.get(0))) {
            return false;
        }
        if (attrs.size() >= 3 && "_CUSTOM".equalsIgnoreCase((String)attrs.get(1)) && "_DEFINITIONS".equalsIgnoreCase((String)attrs.get(2))) {
            return true;
        }
        if (attrs.size() >= 2 && "_CONTROL".equalsIgnoreCase((String)attrs.get(1))) {
            return true;
        }
        if (attrs.size() == 4 && "_PROCEDURE".equals(attrs.get(1))) {
            return true;
        }
        if (attrs.size() == 5 && "_PROCEDURE".equals(attrs.get(1)) && "_FREEFORM".equals(attrs.get(4))) {
            return true;
        }
        return attrs.size() >= 2 && "_FUNCTION".equals(attrs.get(1));
    }
}

