/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core;

public class ProgressString {
    private final char quote;
    private final String text;
    private final String attributes;

    public ProgressString(String quotedString) {
        this.quote = quotedString.charAt(0);
        int secondQuote = quotedString.lastIndexOf(this.quote);
        this.text = quotedString.substring(1, secondQuote);
        this.attributes = secondQuote < quotedString.length() - 1 ? quotedString.substring(secondQuote + 1) : "";
    }

    public String getAttributes() {
        return this.attributes;
    }

    public char getQuote() {
        return this.quote;
    }

    public String getText() {
        return this.text;
    }

    public boolean isTrans() {
        return this.attributes.indexOf(85) < 0 && this.attributes.indexOf(117) < 0;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.quote).append(this.text).append(this.quote).append(this.attributes);
        return buff.toString();
    }

    public static boolean isQuoted(String checkMe) {
        char c = checkMe.charAt(0);
        return c == '\'' || c == '\"';
    }

    public static String dequote(String orig) {
        if (ProgressString.isQuoted(orig)) {
            ProgressString pstring = new ProgressString(orig);
            return pstring.getText().trim();
        }
        return orig;
    }
}

