/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core;

import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.EnumSet;
import java.util.Set;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.JPNode;
import org.prorefactor.proparse.ParserSupport;
import org.prorefactor.proparse.SymbolScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNodeLister {
    private static final Logger LOG = LoggerFactory.getLogger(TreeNodeLister.class);
    private final JPNode topNode;
    private final Writer ofile;
    private final Set<ABLNodeType> ignored;
    private final ParserSupport support;

    public TreeNodeLister(JPNode topNode, ParserSupport support, Writer writer, ABLNodeType ignoredKw, ABLNodeType ... ignoredKws) {
        this.topNode = topNode;
        this.ofile = writer;
        this.ignored = EnumSet.of(ignoredKw, ignoredKws);
        this.support = support;
    }

    public void print() {
        try {
            this.printSub(this.topNode, 0);
            this.ofile.write("\n\n\n");
            this.support.getUnitScope().writeScope(this.ofile);
            this.ofile.write("\n\n\n");
            for (SymbolScope scope : this.support.getInnerScopes()) {
                scope.writeScope(this.ofile);
                this.ofile.write("\n\n\n");
            }
        }
        catch (IOException uncaught) {
            LOG.error("Unable to write output", (Throwable)uncaught);
        }
    }

    private boolean printSub(JPNode node, int tabs) throws IOException {
        if (this.ignored.contains((Object)node.getNodeType())) {
            return false;
        }
        this.printAttributes(node, tabs);
        if (!node.getDirectChildren().isEmpty()) {
            for (JPNode child : node.getDirectChildren()) {
                this.printSub(child, tabs + 1);
            }
        }
        return true;
    }

    private void printAttributes(JPNode node, int tabs) throws IOException {
        if (node.getNodeType() == ABLNodeType.EOF) {
            return;
        }
        this.ofile.write(String.format("%3s %s", tabs, CharBuffer.allocate(tabs).toString().replace('\u0000', ' ')));
        this.ofile.write((Object)((Object)node.getNodeType()) + (node.isStateHead() ? "^ " : " ") + (node.isStateHead() && node.getState2() != 0 ? Integer.valueOf(node.getState2()) : ""));
        if (node.attrGet(1200) == 1) {
            this.ofile.write("*OP* ");
        }
        if (node.attrGet(2000) == 1) {
            this.ofile.write("*IN* ");
        }
        if (node.getNodeType() != ABLNodeType.FIELD_REF && node.attrGet(1100) > 0) {
            this.ofile.write("StoreType " + node.attrGet(1100) + " ");
        }
        if (node.getNodeType() == ABLNodeType.ID || node.getNodeType() == ABLNodeType.TYPE_NAME) {
            this.ofile.write("[");
            this.ofile.write(node.getText().replace('\'', ' ').replace('\"', ' '));
            this.ofile.write("] ");
        }
        if (!"".equals(node.attrGetS(2400))) {
            this.ofile.write(" Qualified name: '" + node.attrGetS(2400) + "'");
        }
        this.ofile.write(String.format("@F%d:%d:%d", node.getFileIndex(), node.getLine(), node.getColumn()));
        this.ofile.write("\n");
    }
}

