/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.schema;

import org.prorefactor.core.JPNode;
import org.prorefactor.core.schema.Constants;
import org.prorefactor.core.schema.IField;
import org.prorefactor.core.schema.ITable;
import org.prorefactor.treeparser.ClassSupport;
import org.prorefactor.treeparser.DataType;
import org.prorefactor.treeparser.Primative;

public class Field
implements IField {
    private final String name;
    private int extent;
    private DataType dataType;
    private String className = null;
    private ITable table;

    public Field(String inName, ITable table) {
        this.name = inName;
        this.table = table;
        if (table != null) {
            table.add(this);
        }
    }

    Field(String inName) {
        this.name = inName;
        this.table = Constants.nullTable;
    }

    @Override
    public void assignAttributesLike(Primative likePrim) {
        this.dataType = likePrim.getDataType();
        this.className = likePrim.getClassName();
        this.extent = likePrim.getExtent();
    }

    @Override
    public IField copyBare(ITable toTable) {
        Field f = new Field(this.name, toTable);
        f.dataType = this.dataType;
        f.extent = this.extent;
        f.className = this.className;
        return f;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getExtent() {
        return this.extent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ITable getTable() {
        return this.table;
    }

    @Override
    public Primative setClassName(String s) {
        this.className = s;
        return this;
    }

    @Override
    public Primative setClassName(JPNode typeNameNode) {
        this.className = ClassSupport.qualifiedClassName(typeNameNode);
        return this;
    }

    @Override
    public Primative setDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public Primative setExtent(int extent) {
        this.extent = extent;
        return this;
    }

    @Override
    public void setTable(ITable table) {
        this.table = table;
        table.add(this);
    }

    public static class Name {
        private final String db;
        private final String table;
        private final String field;

        public Name(String dbPart, String tablePart, String fieldPart) {
            this.db = dbPart;
            this.table = tablePart;
            this.field = fieldPart;
        }

        public Name(String name) {
            String[] parts = name.split("\\.");
            if (parts.length == 1) {
                this.db = null;
                this.table = null;
                this.field = parts[0];
            } else if (parts.length == 2) {
                this.db = null;
                this.table = parts[0];
                this.field = parts[1];
            } else {
                this.db = parts[0];
                this.table = parts[1];
                this.field = parts[2];
            }
        }

        public String getDb() {
            return this.db;
        }

        public String getTable() {
            return this.table;
        }

        public String getField() {
            return this.field;
        }

        public String generateName() {
            StringBuilder buff = new StringBuilder();
            if (this.table != null && this.table.length() > 0) {
                if (this.db != null && this.db.length() > 0) {
                    buff.append(this.db);
                    buff.append(".");
                }
                buff.append(this.table);
                buff.append(".");
            }
            buff.append(this.field);
            return buff.toString();
        }
    }
}

