/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.schema;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.prorefactor.core.schema.Constants;
import org.prorefactor.core.schema.Database;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.IDatabase;
import org.prorefactor.core.schema.IField;
import org.prorefactor.core.schema.ISchema;
import org.prorefactor.core.schema.ITable;
import org.prorefactor.core.schema.Index;
import org.prorefactor.core.schema.Table;
import org.prorefactor.treeparser.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema
implements ISchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(Schema.class);
    private static final Comparator<ITable> ALLTABLES_ORDER = new Comparator<ITable>(){

        @Override
        public int compare(ITable s1, ITable s2) {
            int ret = s1.getName().compareToIgnoreCase(s2.getName());
            if (ret != 0) {
                return ret;
            }
            return s1.getDatabase().getName().compareToIgnoreCase(s2.getDatabase().getName());
        }
    };
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final SortedSet<IDatabase> dbSet = new TreeSet<IDatabase>(Constants.DB_NAME_ORDER);
    private final SortedSet<ITable> allTables = new TreeSet<ITable>(ALLTABLES_ORDER);

    public Schema(String file) throws IOException {
        this(file, false);
    }

    public Schema(String file, boolean injectMetaSchema) throws IOException {
        this.loadSchema(file);
        if (injectMetaSchema) {
            this.injectMetaSchema();
        }
    }

    public Schema(IDatabase ... dbs) {
        for (IDatabase db : dbs) {
            this.dbSet.add(db);
            for (ITable tbl : db.getTableSet()) {
                this.allTables.add(tbl);
            }
        }
        this.injectMetaSchema();
    }

    public SortedSet<IDatabase> getDbSet() {
        return this.dbSet;
    }

    @Override
    public void createAlias(String aliasName, String dbName) {
        if (this.lookupDatabase2(dbName) == null) {
            LOGGER.error("Creating alias {} for unknown database {}", (Object)aliasName, (Object)dbName);
        }
        this.aliases.put(aliasName.toLowerCase(Locale.ENGLISH), dbName);
    }

    @Override
    public void deleteAlias(String aliasName) {
        if (Strings.isNullOrEmpty((String)aliasName)) {
            this.aliases.clear();
        } else {
            this.aliases.remove(aliasName.toLowerCase(Locale.ENGLISH));
        }
    }

    public Iterator<ITable> getAllTablesIterator() {
        return this.allTables.iterator();
    }

    public final void injectMetaSchema() {
        for (IDatabase db : this.dbSet) {
            SchemaLineProcessor lineProcessor = new SchemaLineProcessor(db);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/meta.txt")));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null && lineProcessor.processLine(line)) {
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException caught) {
                LOGGER.error("Unable to open file 'meta.txt'", (Throwable)caught);
            }
        }
    }

    private final void loadSchema(File file) throws IOException {
        Database db = new Database(Files.getNameWithoutExtension((String)file.getName()));
        this.dbSet.add(db);
        Files.asCharSource((File)file, (Charset)Charset.defaultCharset()).readLines((LineProcessor)new SchemaLineProcessor(db));
    }

    private final void loadSchema(String from) throws IOException {
        this.loadSchema(new File(from));
    }

    @Override
    public IDatabase lookupDatabase(String inName) {
        IDatabase db = this.lookupDatabase2(inName);
        if (db != null) {
            return db;
        }
        String realName = this.aliases.get(inName.toLowerCase());
        if (realName == null) {
            return null;
        }
        return this.lookupDatabase2(realName);
    }

    @Override
    public IField lookupField(String dbName, String tableName, String fieldName) {
        ITable table = this.lookupTable(dbName, tableName);
        if (table == null) {
            return null;
        }
        return table.lookupField(fieldName);
    }

    @Override
    public ITable lookupTable(String inName) {
        if (inName.indexOf(46) > -1) {
            ITable firstTry = this.lookupTable2(inName);
            if (firstTry != null) {
                return firstTry;
            }
            return this.lookupMetaTable(inName);
        }
        return this.lookupTableCheckName(this.allTables.tailSet(new Table(inName)), inName);
    }

    @Override
    public ITable lookupTable(String dbName, String tableName) {
        IDatabase db = this.lookupDatabase(dbName);
        if (db == null) {
            return null;
        }
        return this.lookupTableCheckName(db.getTableSet().tailSet(new Table(tableName)), tableName);
    }

    @Override
    public IField lookupUnqualifiedField(String name) {
        for (ITable table : this.allTables) {
            IField field = table.lookupField(name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    private IDatabase lookupDatabase2(String inName) {
        SortedSet<IDatabase> dbTailSet = this.dbSet.tailSet(new Database(inName));
        if (dbTailSet.isEmpty()) {
            return null;
        }
        IDatabase db = dbTailSet.first();
        if (db == null || db.getName().compareToIgnoreCase(inName) != 0) {
            return null;
        }
        return db;
    }

    private ITable lookupTableCheckName(SortedSet<ITable> set, String name) {
        ITable next;
        String lname = name.toLowerCase();
        Iterator it = set.iterator();
        if (!it.hasNext()) {
            return null;
        }
        ITable table = (ITable)it.next();
        if (!table.getName().toLowerCase().startsWith(lname)) {
            return null;
        }
        if (lname.length() < table.getName().length() && it.hasNext() && (next = (ITable)it.next()).getName().toLowerCase().startsWith(lname)) {
            return null;
        }
        return table;
    }

    private ITable lookupTable2(String inName) {
        String[] parts = inName.split("\\.");
        if (parts == null) {
            return null;
        }
        return this.lookupTable(parts[0], parts[1]);
    }

    private ITable lookupMetaTable(String inName) {
        String[] parts = inName.split("\\.");
        IDatabase db = this.lookupDatabase(parts[0]);
        if (db == null || parts[1] == null || !parts[1].startsWith("_")) {
            return null;
        }
        return this.lookupTableCheckName(db.getTableSet().tailSet(new Table(parts[1])), parts[1]);
    }

    private class SchemaLineProcessor
    implements LineProcessor<Void> {
        private IDatabase currDatabase;
        private Table currTable;

        public SchemaLineProcessor(IDatabase currDatabase) {
            this.currDatabase = currDatabase;
        }

        public boolean processLine(String line) throws IOException {
            if (!line.startsWith("S")) {
                if (line.startsWith("T")) {
                    this.currTable = new Table(line.substring(1), this.currDatabase);
                    this.currDatabase.add(this.currTable);
                    Schema.this.allTables.add(this.currTable);
                } else if (line.startsWith("F")) {
                    int ch1 = line.indexOf(58);
                    int ch2 = line.lastIndexOf(58);
                    if (this.currTable == null || ch1 == -1 || ch2 == -1) {
                        throw new IOException("Invalid file format: " + line);
                    }
                    Field f = new Field(line.substring(1, ch1), this.currTable);
                    f.setDataType(DataType.getDataType(line.substring(ch1 + 1, ch2).toUpperCase()));
                    if (f.getDataType() == null) {
                        throw new IOException("Unknown datatype: " + line.substring(ch1 + 1, ch2));
                    }
                    f.setExtent(Integer.parseInt(line.substring(ch2 + 1)));
                    this.currTable.add(f);
                } else if (line.startsWith("I")) {
                    if (this.currTable == null) {
                        throw new IOException("No associated table for " + line);
                    }
                    List lst = Splitter.on((char)':').trimResults().splitToList((CharSequence)line);
                    if (lst.size() < 3) {
                        throw new IOException("Invalid file format: " + line);
                    }
                    Index i = new Index(this.currTable, ((String)lst.get(0)).substring(1), ((String)lst.get(1)).indexOf(85) > -1, ((String)lst.get(1)).indexOf(80) > -1);
                    for (int zz = 2; zz < lst.size(); ++zz) {
                        i.addField(this.currTable.lookupField(((String)lst.get(zz)).substring(1)));
                    }
                    this.currTable.add(i);
                }
            }
            return true;
        }

        public Void getResult() {
            return null;
        }
    }
}

