/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.core.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.prorefactor.core.schema.Constants;
import org.prorefactor.core.schema.Field;
import org.prorefactor.core.schema.IDatabase;
import org.prorefactor.core.schema.IField;
import org.prorefactor.core.schema.IIndex;
import org.prorefactor.core.schema.ITable;
import org.prorefactor.treeparser.TreeParserRootSymbolScope;

public class Table
implements ITable {
    private final IDatabase database;
    private final String name;
    private final int storetype;
    private List<IField> fieldPosOrder = new ArrayList<IField>();
    private List<IIndex> indexes = new ArrayList<IIndex>();
    private SortedSet<IField> fieldSet = new TreeSet<IField>(Constants.FIELD_NAME_ORDER);

    public Table(String name, IDatabase database) {
        this.name = name;
        this.database = database;
        this.storetype = 1102;
        database.add(this);
    }

    public Table(String name, int storetype) {
        this.name = name;
        this.storetype = storetype;
        this.database = Constants.nullDatabase;
    }

    public Table(String name) {
        this.name = name;
        this.storetype = 1102;
        this.database = Constants.nullDatabase;
    }

    @Override
    public void add(IField field) {
        this.fieldSet.add(field);
        this.fieldPosOrder.add(field);
    }

    @Override
    public void add(IIndex index) {
        this.indexes.add(index);
    }

    public ITable copyBare(TreeParserRootSymbolScope scope) {
        ITable t = scope.lookupTableDefinition(this.name);
        if (t != null) {
            return t;
        }
        t = new Table(this.name, this.storetype);
        for (IField field : this.fieldPosOrder) {
            field.copyBare(t);
        }
        return t;
    }

    @Override
    public IDatabase getDatabase() {
        return this.database;
    }

    @Override
    public List<IField> getFieldPosOrder() {
        return this.fieldPosOrder;
    }

    @Override
    public SortedSet<IField> getFieldSet() {
        return this.fieldSet;
    }

    @Override
    public List<IIndex> getIndexes() {
        return this.indexes;
    }

    @Override
    public IIndex lookupIndex(String name) {
        for (IIndex idx : this.indexes) {
            if (!idx.getName().equalsIgnoreCase(name)) continue;
            return idx;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getStoretype() {
        return this.storetype;
    }

    @Override
    public IField lookupField(String lookupName) {
        SortedSet<IField> fieldTailSet = this.fieldSet.tailSet(new Field(lookupName));
        if (fieldTailSet.isEmpty()) {
            return null;
        }
        IField field = fieldTailSet.first();
        if (field == null || !field.getName().toLowerCase().startsWith(lookupName.toLowerCase())) {
            return null;
        }
        return field;
    }

    public String toString() {
        return (this.storetype == 1102 ? "DB Table" : (this.storetype == 1103 ? "Temp-table" : "Work-table")) + ' ' + this.name;
    }

    public static class Name {
        private final String db;
        private final String table;

        public Name(String dbPart, String tablePart) {
            this.db = dbPart;
            this.table = tablePart;
        }

        public Name(String name) {
            String[] parts = name.split("\\.");
            if (parts.length == 1) {
                this.db = null;
                this.table = parts[0];
            } else {
                this.db = parts[0];
                this.table = parts[1];
            }
        }

        public String getDb() {
            return this.db;
        }

        public String getTable() {
            return this.table;
        }

        public String generateName() {
            StringBuilder buff = new StringBuilder();
            if (this.db != null && this.db.length() > 0) {
                buff.append(this.db);
                buff.append(".");
            }
            buff.append(this.table);
            return buff.toString();
        }
    }
}

