/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.macrolevel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.prorefactor.macrolevel.MacroDef;
import org.prorefactor.macrolevel.MacroRef;

public class IncludeRef
extends MacroRef {
    private List<MacroDef> includeArgs = new ArrayList<MacroDef>();
    private Map<String, MacroDef> argMap = new HashMap<String, MacroDef>();
    private String fileRefName = "";
    private int fileIndex;
    private boolean usesNamedArgs;

    public IncludeRef(MacroRef parent, int line, int column) {
        super(parent, line, column);
    }

    public IncludeRef(MacroRef parent, int line, int column, int fileIndex) {
        super(parent, line, column);
        this.fileIndex = fileIndex;
    }

    public void addNamedArg(MacroDef arg) {
        this.usesNamedArgs = true;
        this.includeArgs.add(arg);
        this.argMap.put(arg.getName().toLowerCase(), arg);
    }

    public void addNumberedArg(MacroDef arg) {
        this.includeArgs.add(arg);
    }

    public MacroDef getArgNumber(int num) {
        if (num > 0 && num <= this.includeArgs.size()) {
            return this.includeArgs.get(num - 1);
        }
        return null;
    }

    @Override
    public int getFileIndex() {
        return this.fileIndex;
    }

    public String getFileRefName() {
        return this.fileRefName;
    }

    public MacroDef lookupNamedArg(String name) {
        if (!this.usesNamedArgs) {
            return null;
        }
        return this.argMap.get(name.toLowerCase());
    }

    public int numArgs() {
        return this.includeArgs.size();
    }

    public void setFileRefName(String fileRefName) {
        this.fileRefName = fileRefName;
    }

    public MacroDef undefine(String name) {
        MacroDef theArg = this.argMap.get(name);
        if (theArg != null) {
            this.argMap.remove(name);
            this.argMap.put("", theArg);
            return theArg;
        }
        return null;
    }
}

