/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.macrolevel;

import java.util.ArrayList;
import org.prorefactor.macrolevel.IncludeRef;
import org.prorefactor.macrolevel.MacroDef;
import org.prorefactor.macrolevel.MacroEvent;
import org.prorefactor.macrolevel.MacroRef;
import org.prorefactor.macrolevel.NamedMacroRef;

public class MacroLevel {
    private MacroLevel() {
    }

    public static int[] getDefinitionPosition(MacroDef def) {
        int[] ret = new int[3];
        if (def.includeRef == null) {
            if (def.getParent() instanceof NamedMacroRef) {
                return MacroLevel.getDefinitionPosition(((NamedMacroRef)def.getParent()).getMacroDef());
            }
            ret[0] = ((IncludeRef)def.getParent()).getFileIndex();
            ret[1] = def.getPosition().getLine();
            ret[2] = def.getPosition().getColumn();
        } else {
            if (!(def.includeRef.getParent() instanceof IncludeRef)) {
                return MacroLevel.getDefinitionPosition(((NamedMacroRef)def.includeRef.getParent()).getMacroDef());
            }
            ret[0] = ((IncludeRef)def.includeRef.getParent()).getFileIndex();
            ret[1] = def.includeRef.getLine();
            ret[2] = def.includeRef.getColumn();
        }
        return ret;
    }

    public static MacroRef[] sourceArray(MacroRef top) {
        ArrayList<MacroRef> list = new ArrayList<MacroRef>();
        MacroLevel.sourceArray2(top, list);
        MacroRef[] ret = new MacroRef[list.size()];
        return list.toArray(ret);
    }

    private static void sourceArray2(MacroRef macroNode, ArrayList<MacroRef> list) {
        list.add(macroNode);
        for (MacroEvent event : macroNode.macroEventList) {
            if (!(event instanceof MacroRef)) continue;
            MacroLevel.sourceArray2((MacroRef)event, list);
        }
    }
}

