/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.macrolevel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.prorefactor.macrolevel.IncludeRef;
import org.prorefactor.macrolevel.MacroDef;
import org.prorefactor.macrolevel.MacroEvent;
import org.prorefactor.macrolevel.MacroPosition;
import org.prorefactor.macrolevel.NamedMacroRef;

public abstract class MacroRef
implements MacroEvent {
    private final MacroRef parent;
    private final int refColumn;
    private final int refLine;
    public final List<MacroEvent> macroEventList = new ArrayList<MacroEvent>();

    public MacroRef(MacroRef parent, int line, int column) {
        this.parent = parent;
        this.refLine = line;
        this.refColumn = column;
    }

    @Override
    public MacroRef getParent() {
        return this.parent;
    }

    public int getLine() {
        return this.refLine;
    }

    public int getColumn() {
        return this.refColumn;
    }

    public List<MacroEvent> findExternalMacroReferences() {
        ArrayList<MacroEvent> ret = new ArrayList<MacroEvent>();
        Iterator<MacroEvent> it = this.macroEventList.iterator();
        while (it.hasNext()) {
            this.findExternalMacroReferences(it.next(), ret);
        }
        return ret;
    }

    public List<MacroEvent> findExternalMacroReferences(int[] begin, int[] end) {
        ArrayList<MacroEvent> ret = new ArrayList<MacroEvent>();
        for (MacroEvent next : this.macroEventList) {
            MacroPosition pos = next.getPosition();
            if (!MacroRef.isInRange(pos.getLine(), pos.getColumn(), begin, end)) continue;
            this.findExternalMacroReferences(next, ret);
        }
        return ret;
    }

    private void findExternalMacroReferences(MacroEvent obj, List<MacroEvent> list) {
        if (obj == null) {
            return;
        }
        if (obj instanceof IncludeRef) {
            list.add(obj);
            return;
        }
        if (obj instanceof MacroDef) {
            MacroDef def = (MacroDef)obj;
            if (def.getType() == 3) {
                if (def.undefWhat.getType() == 4) {
                    list.add(def);
                    return;
                }
                if (!this.isMine(def.undefWhat.getParent())) {
                    list.add(def);
                }
            }
            return;
        }
        if (!(obj instanceof NamedMacroRef)) {
            return;
        }
        NamedMacroRef ref = (NamedMacroRef)obj;
        if (!this.isMine(ref)) {
            list.add(ref);
            return;
        }
        Iterator it = ref.macroEventList.iterator();
        while (it.hasNext()) {
            this.findExternalMacroReferences((MacroEvent)it.next(), list);
        }
    }

    public List<IncludeRef> findIncludeReferences(int fileIndex) {
        ArrayList<IncludeRef> ret = new ArrayList<IncludeRef>();
        this.findIncludeReferences(fileIndex, this, ret);
        return ret;
    }

    private void findIncludeReferences(int fileIndex, MacroRef ref, List<IncludeRef> list) {
        IncludeRef incl;
        if (ref == null) {
            return;
        }
        if (ref instanceof IncludeRef && (incl = (IncludeRef)ref).getFileIndex() == fileIndex) {
            list.add(incl);
        }
        for (MacroEvent next : ref.macroEventList) {
            if (!(next instanceof MacroRef)) continue;
            this.findIncludeReferences(fileIndex, (MacroRef)next, list);
        }
    }

    public abstract int getFileIndex();

    @Override
    public MacroPosition getPosition() {
        return new MacroPosition(this.parent == null ? 0 : this.parent.getFileIndex(), this.refLine, this.refColumn);
    }

    public static boolean isInRange(int x, int y, int[] begin, int[] end) {
        if (begin != null && (x < begin[0] || x == begin[0] && y < begin[1])) {
            return false;
        }
        return end == null || x <= end[0] && (x != end[0] || y <= end[1]);
    }
}

