/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.macrolevel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.prorefactor.core.ProToken;
import org.prorefactor.macrolevel.IPreprocessorEventListener;
import org.prorefactor.macrolevel.IncludeRef;
import org.prorefactor.macrolevel.MacroDef;
import org.prorefactor.macrolevel.MacroRef;
import org.prorefactor.macrolevel.NamedMacroRef;

public class PreprocessorEventListener
implements IPreprocessorEventListener {
    private final IncludeRef root;
    private boolean appBuilderCode = false;
    private final List<EditableCodeSection> sections = new ArrayList<EditableCodeSection>();
    private Deque<Scope> scopeStack = new LinkedList<Scope>();
    private IncludeRef currInclude;
    private Map<String, MacroDef> globalDefMap = new HashMap<String, MacroDef>();
    private MacroRef currRef;
    private EditableCodeSection currSection;

    public PreprocessorEventListener() {
        this.root = new IncludeRef(null, 0, 0);
        this.currRef = this.root;
        this.currInclude = this.root;
        this.scopeStack.addFirst(new Scope(this.root));
    }

    public IncludeRef getMacroGraph() {
        return this.root;
    }

    @Override
    public void define(int line, int column, String name, String value, int type) {
        MacroDef newDef = new MacroDef(this.currRef, type, line, column, name, value);
        if (type == 1) {
            this.globalDefMap.put(name, newDef);
        }
        if (type == 2) {
            Scope currScope = this.scopeStack.getFirst();
            currScope.defMap.put(name, newDef);
        }
        this.currRef.macroEventList.add(newDef);
    }

    @Override
    public void preproElse(int line, int column) {
    }

    @Override
    public void preproElseIf(int line, int column) {
    }

    @Override
    public void preproEndIf(int line, int column) {
    }

    @Override
    public void preproIf(int line, int column, boolean value) {
    }

    @Override
    public void include(int line, int column, int currentFile, String incFile) {
        IncludeRef newRef = new IncludeRef(this.currRef, line, column, currentFile);
        this.scopeStack.addFirst(new Scope(newRef));
        this.currRef.macroEventList.add(newRef);
        this.currInclude = newRef;
        this.currRef = newRef;
        newRef.setFileRefName(incFile);
    }

    @Override
    public void includeArgument(String argName, String value) {
        MacroDef newArg;
        int argNum = 0;
        try {
            argNum = Integer.parseInt(argName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (argNum == 0 || argNum != this.currInclude.numArgs() + 1) {
            newArg = new MacroDef(this.currInclude.getParent(), 4);
            newArg.setName(argName);
            this.currInclude.addNamedArg(newArg);
        } else {
            newArg = new MacroDef(this.currInclude.getParent(), 5);
            this.currInclude.addNumberedArg(newArg);
        }
        newArg.setValue(value);
        newArg.includeRef = this.currInclude;
    }

    @Override
    public void includeEnd() {
        this.scopeStack.removeFirst();
        this.currInclude = this.scopeStack.getFirst().includeRef;
        this.currRef = this.currRef.getParent();
    }

    @Override
    public void macroRef(int line, int column, String macroName) {
        NamedMacroRef newRef = new NamedMacroRef(this.findMacroDef(macroName), this.currRef, line, column);
        this.currRef.macroEventList.add(newRef);
        this.currRef = newRef;
    }

    @Override
    public void macroRefEnd() {
        this.currRef = this.currRef.getParent();
    }

    @Override
    public void undefine(int line, int column, String name) {
        MacroDef newDef = new MacroDef(this.currRef, 3, line, column, name, "");
        this.currRef.macroEventList.add(newDef);
        Scope currScope = this.scopeStack.getFirst();
        if (currScope.defMap.containsKey(name)) {
            newDef.undefWhat = currScope.defMap.remove(name);
            return;
        }
        newDef.undefWhat = this.currInclude.undefine(name);
        if (newDef.undefWhat != null) {
            return;
        }
        Iterator<Scope> it = this.scopeStack.iterator();
        it.next();
        while (it.hasNext()) {
            currScope = it.next();
            if (!currScope.defMap.containsKey(name)) continue;
            newDef.undefWhat = currScope.defMap.remove(name);
            return;
        }
        newDef.undefWhat = this.globalDefMap.remove(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void analyzeSuspend(String str, int line) {
        this.appBuilderCode = true;
        if (this.currInclude.getFileIndex() == 0 && ProToken.isEditableInAB(str)) {
            this.currSection = new EditableCodeSection();
            this.currSection.fileNum = this.currInclude.getFileIndex();
            this.currSection.startLine = line;
        }
    }

    @Override
    public void analyzeResume(int line) {
        if (this.currSection != null && this.currInclude.getFileIndex() == this.currSection.fileNum) {
            this.currSection.endLine = line;
            this.sections.add(this.currSection);
        }
        this.currSection = null;
    }

    public boolean isAppBuilderCode() {
        return this.appBuilderCode;
    }

    public boolean isLineInEditableSection(int file, int line) {
        for (EditableCodeSection range : this.sections) {
            if (range.fileNum != file || range.startLine > line || range.endLine < line) continue;
            return true;
        }
        return false;
    }

    private MacroDef findMacroDef(String name) {
        Scope currScope = this.scopeStack.getFirst();
        MacroDef ret = currScope.defMap.get(name);
        if (ret != null) {
            return ret;
        }
        ret = this.currInclude.lookupNamedArg(name);
        if (ret != null) {
            return ret;
        }
        Iterator<Scope> it = this.scopeStack.iterator();
        it.next();
        while (it.hasNext()) {
            currScope = it.next();
            ret = currScope.defMap.get(name);
            if (ret == null) continue;
            return ret;
        }
        ret = this.globalDefMap.get(name);
        return ret;
    }

    public List<EditableCodeSection> getEditableCodeSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public static class EditableCodeSection {
        private int fileNum;
        private int startLine;
        private int endLine;

        public int getFileNum() {
            return this.fileNum;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }
    }

    private static class Scope {
        Map<String, MacroDef> defMap = new HashMap<String, MacroDef>();
        IncludeRef includeRef;

        public Scope(IncludeRef ref) {
            this.includeRef = ref;
        }
    }
}

