/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.prorefactor.refactor.RefactorSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFinder.class);
    private RefactorSession session;
    private List<String> paths = new ArrayList<String>();
    private Map<String, String> namesMap = new HashMap<String, String>();

    public ClassFinder(RefactorSession session) {
        this.session = session;
    }

    void addPath(String nodeText) {
        LOGGER.trace("Entering addPath {}", (Object)nodeText);
        String dequoted = ClassFinder.dequote(nodeText);
        if (dequoted.length() == 0) {
            return;
        }
        if (dequoted.endsWith("*")) {
            this.paths.add(dequoted.replace('.', '/').substring(0, dequoted.length() - 1));
        } else {
            int dotPos = dequoted.lastIndexOf(46);
            String unqualified = dotPos > 0 ? dequoted.substring(dotPos + 1) : dequoted;
            if (!this.namesMap.containsKey(unqualified = unqualified.toLowerCase())) {
                this.namesMap.put(unqualified, dequoted);
            }
        }
    }

    static String dequote(String s1) {
        StringBuilder s2 = new StringBuilder();
        int len = s1.length();
        char[] c1 = s1.toCharArray();
        int numQuotes = 0;
        for (int i = 0; i < len; ++i) {
            char c = c1[i];
            if (c == '\"' || c == '\'') {
                if (++numQuotes <= 1 || i + 1 >= len || c1[i + 1] != ':') continue;
                break;
            }
            s2.append(c);
        }
        return s2.toString();
    }

    String findClassFile(String qualClassName) {
        String slashName = qualClassName.replace('.', '/');
        return this.session.findFile(slashName + ".cls");
    }

    String lookup(String rawRefName) {
        LOGGER.trace("Entering lookup {}", (Object)rawRefName);
        String dequotedName = ClassFinder.dequote(rawRefName);
        if (dequotedName.contains(".")) {
            return dequotedName;
        }
        String ret = this.namesMap.get(dequotedName.toLowerCase());
        if (ret != null) {
            return ret;
        }
        String withExtension = dequotedName + ".cls";
        for (String path : this.paths) {
            String classFile = this.session.findFile(path + withExtension);
            if (classFile.length() == 0) continue;
            ret = path.replace('/', '.') + dequotedName;
            this.namesMap.put(dequotedName.toLowerCase(), ret);
            return ret;
        }
        if (this.session.findFile(dequotedName + ".cls").length() > 0) {
            this.namesMap.put(dequotedName.toLowerCase(), dequotedName);
            return dequotedName;
        }
        return "";
    }

    public int compareTo(ClassFinder other) {
        if (!String.join((CharSequence)",", this.paths).equals(String.join((CharSequence)",", other.paths))) {
            System.err.println("ClassFinder paths: " + String.join((CharSequence)",", this.paths) + " *** " + String.join((CharSequence)",", other.paths));
            return 1;
        }
        return 0;
    }
}

