/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;

public class IntegerIndex<T> {
    private final BiMap<Integer, T> biMap = HashBiMap.create();
    private int nextIndex;

    public int add(T val) {
        Integer ret = (Integer)this.biMap.inverse().get(val);
        if (ret != null) {
            return ret;
        }
        ret = this.nextIndex++;
        this.biMap.put((Object)ret, val);
        return ret;
    }

    public void clear() {
        this.biMap.clear();
        this.nextIndex = 0;
    }

    public int getIndex(T val) {
        Integer ret = (Integer)this.biMap.inverse().get(val);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    public T getValue(int index) {
        return (T)this.biMap.get((Object)index);
    }

    public List<T> getValues() {
        ArrayList<Object> list = new ArrayList<Object>(this.nextIndex);
        for (int i = 0; i < this.nextIndex; ++i) {
            list.add(this.biMap.get((Object)i));
        }
        return list;
    }

    public boolean hasIndex(int index) {
        return this.biMap.containsKey((Object)index);
    }

    public boolean hasValue(T value) {
        return this.biMap.containsValue(value);
    }

    public int size() {
        return this.nextIndex;
    }
}

