/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse;

import antlr.ASTFactory;
import antlr.Token;
import antlr.collections.AST;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.ProToken;
import org.prorefactor.core.nodetypes.BlockNode;
import org.prorefactor.core.nodetypes.FieldRefNode;
import org.prorefactor.core.nodetypes.ProgramRootNode;
import org.prorefactor.core.nodetypes.ProparseDirectiveNode;
import org.prorefactor.core.nodetypes.RecordNameNode;

public class NodeFactory
extends ASTFactory {
    public NodeFactory() {
        this.setASTNodeClass(JPNode.class);
    }

    public AST create() {
        return this.create(0);
    }

    public AST create(int type) {
        return this.create(type, "");
    }

    public AST create(int type, String text) {
        ABLNodeType nodeType = ABLNodeType.getNodeType(type);
        if (nodeType == null) {
            throw new IllegalArgumentException("Invalid type number " + type);
        }
        ProToken token = new ProToken(nodeType, text);
        switch (nodeType) {
            case FIELD_REF: {
                return new FieldRefNode(token);
            }
            case PROGRAM_ROOT: {
                return new ProgramRootNode(token);
            }
            case PROPERTY_GETTER: 
            case PROPERTY_SETTER: {
                return new BlockNode(token);
            }
        }
        return new JPNode(token);
    }

    public AST create(Token token, String s) {
        switch (ABLNodeType.getNodeType(token.getType())) {
            case RECORD_NAME: {
                return new RecordNameNode((ProToken)token);
            }
            case PROPARSEDIRECTIVE: {
                return new ProparseDirectiveNode((ProToken)token);
            }
            case DO: 
            case FOR: 
            case REPEAT: 
            case FUNCTION: 
            case PROCEDURE: 
            case CONSTRUCTOR: 
            case DESTRUCTOR: 
            case METHOD: 
            case CANFIND: 
            case CATCH: 
            case ON: {
                return new BlockNode((ProToken)token);
            }
        }
        throw new IllegalArgumentException("Proparse error creating AST node " + token.toString() + ", " + s);
    }
}

