/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse;

import antlr.Token;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.RuleNode;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.ProToken;
import org.prorefactor.proparse.ClassFinder;
import org.prorefactor.proparse.IntegerIndex;
import org.prorefactor.proparse.RootSymbolScope;
import org.prorefactor.proparse.SymbolScope;
import org.prorefactor.proparse.antlr4.JPNode;
import org.prorefactor.refactor.RefactorSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ParserSupport.class);
    private final RefactorSession session;
    private final ClassFinder classFinder;
    private final RootSymbolScope unitScope;
    private final IntegerIndex<String> fileNameList;
    private SymbolScope currentScope;
    private boolean schemaTablePriority = false;
    private boolean unitIsInterface = false;
    private boolean allowUnknownMethodCalls = true;
    private Map<String, SymbolScope> funcScopeMap = new HashMap<String, SymbolScope>();
    private String className = "";
    private org.prorefactor.core.JPNode lastFieldRefNode;
    private org.prorefactor.core.JPNode lastFieldIDNode;
    private String lastFieldIDStr;
    private ParseTreeProperty<SymbolScope.FieldType> recordExpressions = new ParseTreeProperty();
    private ParseTreeProperty<JPNode> nodes = new ParseTreeProperty();
    private List<SymbolScope> innerScopes = new ArrayList<SymbolScope>();
    private Map<RuleContext, SymbolScope> innerScopesMap = new HashMap<RuleContext, SymbolScope>();

    public ParserSupport(RefactorSession session, IntegerIndex<String> fileNameList) {
        this.session = session;
        this.unitScope = new RootSymbolScope(session);
        this.currentScope = this.unitScope;
        this.classFinder = new ClassFinder(session);
        this.fileNameList = fileNameList;
    }

    public String getClassName() {
        return this.className;
    }

    public int abbrevDatatype(String text) {
        String s = text.toLowerCase();
        if ("cha".startsWith(s)) {
            return 103;
        }
        if ("da".equals(s) || "dat".equals(s)) {
            return 166;
        }
        if ("de".equals(s)) {
            return 183;
        }
        if ("i".equals(s) || "in".equals(s)) {
            return 385;
        }
        if ("logical".startsWith(s)) {
            return 439;
        }
        if ("rec".equals(s) || "reci".equals(s)) {
            return 643;
        }
        if ("rowi".equals(s)) {
            return 679;
        }
        if ("widget-h".startsWith(s) && s.length() >= 4) {
            return 856;
        }
        return 0;
    }

    public void visitorResetScope(RuleContext ctx) {
        this.currentScope = this.unitScope;
    }

    public void visitorEnterScope(RuleContext ctx) {
        SymbolScope scope = this.innerScopesMap.get(ctx);
        if (scope != null) {
            this.currentScope = scope;
        }
    }

    public void visitorExitScope(RuleContext ctx) {
        SymbolScope scope = this.innerScopesMap.get(ctx);
        if (scope != null) {
            this.currentScope = this.currentScope.getSuperScope();
        }
    }

    public void addInnerScope() {
        this.currentScope = new SymbolScope(this.session, this.currentScope);
        this.innerScopes.add(this.currentScope);
    }

    public void addInnerScope(RuleContext ctx) {
        this.addInnerScope();
        this.innerScopesMap.put(ctx, this.currentScope);
    }

    public RootSymbolScope getUnitScope() {
        return this.unitScope;
    }

    public List<SymbolScope> getInnerScopes() {
        return this.innerScopes;
    }

    public void defBuffer(String bufferName, String tableName) {
        LOG.trace("defBuffer {} to {}", (Object)bufferName, (Object)tableName);
        this.currentScope.defineBuffer(bufferName, tableName);
    }

    void defineClass(org.prorefactor.core.JPNode classNode) {
        this.defineClass(classNode.getFirstChild().getText());
    }

    public void defineClass(String name) {
        LOG.trace("defineClass '{}'", (Object)name);
        this.className = ClassFinder.dequote(name);
        this.unitScope.attachTypeInfo(this.session.getTypeInfo(this.className));
    }

    void defInterface(org.prorefactor.core.JPNode interfaceNode) {
        this.defInterface(interfaceNode.getFirstChild().getText());
    }

    public void defInterface(String name) {
        LOG.trace("defineInterface");
        this.unitIsInterface = true;
        this.className = ClassFinder.dequote(name);
    }

    void defMethod(org.prorefactor.core.JPNode idNode) {
    }

    public void defTable(String name, SymbolScope.FieldType ttype) {
        this.currentScope.defineTable(name.toLowerCase(), ttype);
    }

    public void defVar(String name) {
        this.currentScope.defineVar(name);
    }

    public void defVarInline() {
        if (this.lastFieldIDNode == null) {
            LOG.warn("Trying to define inline variable, but no ID symbol availble");
        } else {
            this.currentScope.defineInlineVar(this.lastFieldIDNode.getText());
            this.lastFieldRefNode.attrSet((Integer)2000, 1);
        }
    }

    public void defVarInlineAntlr4() {
        if (this.lastFieldIDStr == null) {
            LOG.warn("Trying to define inline variable, but no ID symbol availble");
        } else {
            this.currentScope.defineInlineVar(this.lastFieldIDStr);
        }
    }

    public void dropInnerScope() {
        assert (this.currentScope != this.unitScope);
        this.currentScope = this.currentScope.getSuperScope();
    }

    public void fieldReference(org.prorefactor.core.JPNode refNode, org.prorefactor.core.JPNode idNode) {
        this.lastFieldRefNode = refNode;
        this.lastFieldIDNode = idNode;
    }

    public void fieldReference(String idNode) {
        this.lastFieldIDStr = idNode;
    }

    public void filenameMerge(org.prorefactor.core.JPNode node) {
        org.prorefactor.core.JPNode currNode = node;
        org.prorefactor.core.JPNode nextNode = node.getNextSibling();
        while (nextNode != null) {
            if (currNode.getNodeType() == ABLNodeType.FILENAME && nextNode.getNodeType() == ABLNodeType.FILENAME && nextNode.getHiddenBefore() == null) {
                currNode.setHiddenAfter(nextNode.getHiddenAfter());
                currNode.setText(currNode.getText() + nextNode.getText());
                currNode.setNextSibling(nextNode.getNextSibling());
                currNode.updateEndPosition(nextNode.getEndFileIndex(), nextNode.getEndLine(), nextNode.getEndColumn());
                nextNode = currNode.getNextSibling();
                continue;
            }
            currNode = currNode.getNextSibling();
            nextNode = currNode.getNextSibling();
        }
    }

    void funcBegin(org.prorefactor.core.JPNode idNode) {
        this.funcBegin(idNode.getText(), null);
    }

    public void funcBegin(String name, RuleContext ctx) {
        String lowername = name.toLowerCase();
        SymbolScope ss = this.funcScopeMap.get(lowername);
        if (ss != null) {
            this.currentScope = ss;
        } else {
            this.currentScope = new SymbolScope(this.session, this.currentScope);
            this.innerScopes.add(this.currentScope);
            if (ctx != null) {
                this.innerScopesMap.put(ctx, this.currentScope);
            }
            this.funcScopeMap.put(lowername, this.currentScope);
            this.unitScope.defFunc(lowername);
        }
    }

    public void funcEnd() {
        this.currentScope = this.currentScope.getSuperScope();
    }

    public void usingState(org.prorefactor.core.JPNode typeNameNode) {
        this.classFinder.addPath(typeNameNode.getText());
    }

    public void usingState(String typeName) {
        this.classFinder.addPath(typeName);
    }

    public boolean recordSemanticPredicate(org.antlr.v4.runtime.Token lt1, org.antlr.v4.runtime.Token lt2, org.antlr.v4.runtime.Token lt3) {
        String recname = lt1.getText();
        if (lt2.getType() == ABLNodeType.NAMEDOT.getType()) {
            recname = recname + ".";
            recname = recname + lt3.getText();
        }
        return (this.schemaTablePriority ? this.isTableSchemaFirst(recname.toLowerCase()) : this.isTable(recname.toLowerCase())) != null;
    }

    public void pushNode(RuleNode ctx, JPNode node) {
        this.nodes.put((ParseTree)ctx, (Object)node);
    }

    public void pushRecordExpression(RuleContext ctx, String recName) {
        this.recordExpressions.put((ParseTree)ctx, (Object)(this.schemaTablePriority ? this.currentScope.isTableSchemaFirst(recName.toLowerCase()) : this.currentScope.isTable(recName.toLowerCase())));
    }

    public SymbolScope.FieldType getRecordExpression(RuleContext ctx) {
        return (SymbolScope.FieldType)((Object)this.recordExpressions.get((ParseTree)ctx));
    }

    public SymbolScope.FieldType isTable(String inName) {
        return this.currentScope.isTable(inName);
    }

    public SymbolScope.FieldType isTableSchemaFirst(String inName) {
        return this.currentScope.isTableSchemaFirst(inName);
    }

    boolean isTableName(Token lt1, Token lt2, Token lt3, Token lt4) {
        String name = lt1.getText();
        if (lt2.getType() == 5) {
            if (lt4.getType() == 5) {
                return false;
            }
            name = name + "." + lt3.getText();
        }
        if (this.isVar(name)) {
            return false;
        }
        return null != this.isTable(name.toLowerCase());
    }

    public boolean isTableNameANTLR4(org.antlr.v4.runtime.Token lt1) {
        int numDots = CharMatcher.is((char)'.').countIn((CharSequence)lt1.getText());
        if (numDots >= 2) {
            return false;
        }
        if (this.isVar(lt1.getText())) {
            return false;
        }
        return null != this.isTable(lt1.getText().toLowerCase());
    }

    public boolean isVar(String name) {
        return this.currentScope.isVariable(name);
    }

    public boolean isInlineVar(String name) {
        return this.currentScope.isInlineVariable(name);
    }

    public int isMethodOrFunc(String name) {
        return this.unitScope.isMethodOrFunction(name);
    }

    public int isMethodOrFunc(org.antlr.v4.runtime.Token token) {
        if (token == null) {
            return 0;
        }
        return this.unitScope.isMethodOrFunction(token.getText());
    }

    public boolean isClass() {
        return !Strings.isNullOrEmpty((String)this.className);
    }

    public boolean isInterface() {
        return this.unitIsInterface;
    }

    public boolean isSchemaTablePriority() {
        return this.schemaTablePriority;
    }

    public void setSchemaTablePriority(boolean priority) {
        this.schemaTablePriority = priority;
    }

    public void allowUnknownMethodCalls() {
        this.allowUnknownMethodCalls = true;
    }

    public void disallowUnknownMethodCalls() {
        this.allowUnknownMethodCalls = false;
    }

    public boolean unknownMehodCallsAllowed() {
        return this.allowUnknownMethodCalls;
    }

    public String lookupClassName(String text) {
        return this.classFinder.lookup(text);
    }

    public void attrTypeNameLookup(org.prorefactor.core.JPNode node) {
        node.attrSet(2400, this.classFinder.lookup(node.getText()));
    }

    public void attrTypeName(org.prorefactor.core.JPNode node) {
        if (node == null) {
            LOG.error("Unable to assign attribute QUALIFIED_CLASS_INT");
        } else {
            node.attrSet(2400, this.className);
        }
    }

    public String getFilename(int fileIndex) {
        return this.fileNameList.getValue(fileIndex);
    }

    static boolean hasHiddenAfter(Token token) {
        return ((ProToken)token).getHiddenAfter() != null;
    }

    public static boolean hasHiddenBefore(Token token) {
        return ((ProToken)token).getHiddenBefore() != null;
    }

    public int compareTo(ParserSupport other) {
        if (this.classFinder.compareTo(other.classFinder) != 0) {
            return 4;
        }
        if (this.unitScope.compareTo(other.unitScope) != 0) {
            return 3;
        }
        Iterator<SymbolScope> iter1 = this.innerScopes.iterator();
        Iterator<SymbolScope> iter2 = this.innerScopes.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (iter1.next().compareTo(iter2.next()) == 0) continue;
            return 5;
        }
        if (iter1.hasNext() || iter2.hasNext()) {
            System.err.println("Remaining scopes...");
            return 6;
        }
        if (!this.className.equals(other.className)) {
            System.err.println("Classname: " + this.className + " -- " + other.className);
            return 1;
        }
        if (this.unitIsInterface != other.unitIsInterface) {
            System.err.println("Interface: " + this.unitIsInterface + " -- " + other.unitIsInterface);
            return 2;
        }
        return 0;
    }
}

