/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse;

import eu.rssw.pct.TypeInfo;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.proparse.SymbolScope;
import org.prorefactor.refactor.RefactorSession;

public class RootSymbolScope
extends SymbolScope {
    private TypeInfo typeInfo;
    private final Set<String> functionSet = new HashSet<String>();

    public RootSymbolScope(RefactorSession session) {
        super(session);
    }

    public void attachTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    void defFunc(String name) {
        this.functionSet.add(name.toLowerCase());
    }

    @Override
    boolean isVariable(String name) {
        if (super.isVariable(name)) {
            return true;
        }
        TypeInfo info = this.typeInfo;
        while (info != null) {
            if (info.hasProperty(name)) {
                return true;
            }
            info = this.getSession().getTypeInfo(info.getParentTypeName());
        }
        return false;
    }

    @Override
    SymbolScope.FieldType isTableDef(String inName) {
        SymbolScope.FieldType ft = super.isTableDef(inName);
        if (ft != null) {
            return ft;
        }
        TypeInfo info = this.typeInfo;
        while (info != null) {
            if (info.hasBuffer(inName)) {
                return SymbolScope.FieldType.TTABLE;
            }
            info = this.getSession().getTypeInfo(info.getParentTypeName());
        }
        return null;
    }

    @Override
    int isMethodOrFunction(String name) {
        String lname = name.toLowerCase();
        TypeInfo info = this.typeInfo;
        while (info != null) {
            if (info.hasMethod(name)) {
                return ABLNodeType.LOCAL_METHOD_REF.getType();
            }
            info = this.getSession().getTypeInfo(info.getParentTypeName());
        }
        if (this.functionSet.contains(lname)) {
            return ABLNodeType.USER_FUNC.getType();
        }
        return 0;
    }

    public int compareTo(RootSymbolScope other) {
        if (super.compareTo(other) != 0) {
            return 3;
        }
        if (!String.join((CharSequence)",", this.functionSet).equals(String.join((CharSequence)",", other.functionSet))) {
            System.err.println("Functions: " + String.join((CharSequence)",", this.functionSet) + " *** " + String.join((CharSequence)",", other.functionSet));
            return 1;
        }
        return 0;
    }

    @Override
    public void writeScope(Writer writer) throws IOException {
        writer.write("*** RootSymbolScope *** \n");
        super.writeScope(writer);
        this.functionSet.stream().sorted().forEach(e -> {
            try {
                writer.write("Function " + e + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

