/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.prorefactor.core.schema.ITable;
import org.prorefactor.core.schema.Table;
import org.prorefactor.refactor.RefactorSession;

public class SymbolScope {
    private final RefactorSession session;
    private final SymbolScope superScope;
    private final Map<String, TableRef> tableMap = new HashMap<String, TableRef>();
    private final Set<String> varSet = new HashSet<String>();
    private final Set<String> inlineVarSet = new HashSet<String>();

    SymbolScope(RefactorSession session) {
        this(session, null);
    }

    SymbolScope(RefactorSession session, SymbolScope superScope) {
        this.session = session;
        this.superScope = superScope;
    }

    public RefactorSession getSession() {
        return this.session;
    }

    SymbolScope getSuperScope() {
        return this.superScope;
    }

    void defineBuffer(String bufferName, String tableName) {
        tableName = tableName.toLowerCase();
        FieldType bufferType = this.isTableSchemaFirst(tableName);
        bufferName = bufferName.toLowerCase();
        TableRef newRef = new TableRef();
        newRef.bufferFor = tableName;
        newRef.tableType = bufferType;
        this.tableMap.put(bufferName, newRef);
        if (newRef.tableType == FieldType.DBTABLE) {
            ITable table = this.session.getSchema().lookupTable(tableName);
            if (table != null) {
                newRef.dbName = table.getDatabase().getName();
                newRef.fullName = newRef.dbName + "." + table.getName();
            }
            Table.Name tn = new Table.Name(tableName);
            String dbRefName = (tn.getDb() != null ? tn.getDb() : table.getDatabase().getName()) + "." + bufferName;
            TableRef dbRef = new TableRef();
            dbRef.bufferFor = tableName;
            dbRef.tableType = bufferType;
            this.tableMap.put(dbRefName, dbRef);
        }
    }

    void defineTable(String name, FieldType ttype) {
        TableRef newTable = new TableRef();
        newTable.tableType = ttype;
        this.tableMap.put(name.toLowerCase(), newTable);
    }

    void defineVar(String name) {
        this.varSet.add(name.toLowerCase());
    }

    void defineInlineVar(String name) {
        this.defineVar(name);
        this.inlineVarSet.add(name.toLowerCase());
    }

    FieldType isTable(String inName) {
        ITable table = this.session.getSchema().lookupTable(inName);
        if (table != null && inName.contains(".")) {
            return FieldType.DBTABLE;
        }
        FieldType ret = this.isTableDef(inName);
        if (ret != null) {
            return ret;
        }
        if (table != null) {
            return FieldType.DBTABLE;
        }
        if ("proc-text-buffer".equals(inName)) {
            return FieldType.TTABLE;
        }
        return null;
    }

    FieldType isTableDef(String inName) {
        FieldType ft;
        if (this.tableMap.containsKey(inName)) {
            return this.tableMap.get((Object)inName).tableType;
        }
        if (this.superScope != null && (ft = this.superScope.isTableDef(inName)) != null) {
            return ft;
        }
        return null;
    }

    FieldType isTableSchemaFirst(String inName) {
        ITable table = this.session.getSchema().lookupTable(inName);
        if (table != null) {
            Table.Name name = new Table.Name(inName);
            if (table.getName().length() == name.getTable().length()) {
                return FieldType.DBTABLE;
            }
        }
        return this.isTable(inName);
    }

    boolean isVariable(String name) {
        if (this.varSet.contains(name.toLowerCase())) {
            return true;
        }
        if (this.superScope != null) {
            return this.superScope.isVariable(name);
        }
        return false;
    }

    boolean isInlineVariable(String name) {
        return this.inlineVarSet.contains(name.toLowerCase());
    }

    int isMethodOrFunction(String name) {
        return this.superScope.isMethodOrFunction(name);
    }

    public int compareTo(SymbolScope other) {
        if (!String.join((CharSequence)",", this.varSet).equals(String.join((CharSequence)",", other.varSet))) {
            System.err.println("Variables: " + String.join((CharSequence)",", this.varSet) + " *** " + String.join((CharSequence)",", other.varSet));
            return 1;
        }
        return 0;
    }

    public void writeScope(Writer writer) throws IOException {
        writer.write("** SymbolScope ** \n");
        this.varSet.stream().sorted().forEach(e -> {
            try {
                writer.write("Variable " + e + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.tableMap.entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).forEach(e -> {
            try {
                writer.write("Table " + (String)e.getKey() + ": " + ((TableRef)e.getValue()).fullName + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static class TableRef {
        FieldType tableType;
        String bufferFor;
        String fullName;
        String dbName;

        private TableRef() {
        }
    }

    public static enum FieldType {
        VARIABLE(1),
        DBTABLE(2),
        TTABLE(3),
        WTABLE(4);

        int intval;

        private FieldType(int intval) {
            this.intval = intval;
        }
    }
}

