/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.prorefactor.proparse.antlr4.InputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludeFile.class);
    private final Map<String, String> defdNames = new HashMap<String, String>();
    private final Deque<InputSource> inputVector = new LinkedList<InputSource>();
    private final List<String> numberedArgs = new ArrayList<String>();
    private final Map<String, String> namedArgs = new HashMap<String, String>();
    private final List<NamedArgument> namedArgsIn = new ArrayList<NamedArgument>();

    public IncludeFile(String referencedWithName, InputSource is) {
        LOGGER.trace("New IncludeFile object for '{}'", (Object)referencedWithName);
        this.inputVector.add(is);
        this.numberedArgs.add(referencedWithName);
    }

    public void addInputSource(InputSource source) {
        this.inputVector.add(source);
    }

    public InputSource pop() {
        if (this.inputVector.size() > 1) {
            this.inputVector.removeLast();
            return this.inputVector.getLast();
        }
        return null;
    }

    public InputSource getLastSource() {
        return this.inputVector.getLast();
    }

    public void addArgument(String arg) {
        this.numberedArgs.add(arg);
    }

    public void addNamedArgument(String name, String arg) {
        this.namedArgsIn.add(new NamedArgument(name, arg));
        String lname = name.toLowerCase();
        if (!this.namedArgs.containsKey(lname)) {
            this.namedArgs.put(lname, arg);
        }
        this.numberedArgs.add(arg);
    }

    public String getAllNamedArgs() {
        StringBuilder out = new StringBuilder();
        for (NamedArgument arg : this.namedArgsIn) {
            if (out.length() > 0) {
                out.append(' ');
            }
            out.append('&').append(arg.name).append("=\"").append(arg.arg).append("\"");
        }
        return out.toString();
    }

    public String getAllArguments() {
        if (this.numberedArgs.size() <= 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : this.numberedArgs.subList(1, this.numberedArgs.size())) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public String getNumberedArgument(int num) {
        if (num >= this.numberedArgs.size()) {
            return "";
        }
        return this.numberedArgs.get(num);
    }

    public String getNamedArg(String name) {
        if (name.length() == 0) {
            for (NamedArgument nargin : this.namedArgsIn) {
                if (nargin.name.length() != 0) continue;
                return nargin.arg;
            }
            return null;
        }
        return this.namedArgs.get(name.toLowerCase());
    }

    public String getValue(String name) {
        return this.defdNames.get(name);
    }

    public boolean isNameDefined(String name) {
        return this.defdNames.containsKey(name);
    }

    public void scopeDefine(String name, String value) {
        this.defdNames.put(name, value);
    }

    public void removeVariable(String name) {
        this.defdNames.remove(name);
    }

    boolean undefNamedArg(String name) {
        String lname = name.toLowerCase();
        boolean found = false;
        for (NamedArgument nargin : this.namedArgsIn) {
            if (!nargin.name.equalsIgnoreCase(name)) continue;
            nargin.name = "";
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        found = false;
        for (NamedArgument nargin : this.namedArgsIn) {
            if (!nargin.name.equalsIgnoreCase(name)) continue;
            this.namedArgs.put(lname, nargin.arg);
            found = true;
            break;
        }
        if (!found) {
            this.namedArgs.remove(lname);
        }
        return true;
    }

    private static final class NamedArgument {
        private String name;
        private String arg;

        NamedArgument(String name, String arg) {
            this.name = name;
            this.arg = arg;
        }
    }
}

