/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.prorefactor.proparse.antlr4.XCodedFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputSource.class);
    private final boolean primaryInput;
    private final int sourceNum;
    private final String fileContent;
    private final int fileIndex;
    private final boolean macroExpansion;
    private int nextCol = 1;
    private int nextLine = 1;
    private int currPos;
    private String currAnalyzeSuspend = null;

    public InputSource(int sourceNum, String str, int fileIndex, int line, int col) {
        LOGGER.trace("New InputSource object for macro element '{}'", (Object)str);
        this.sourceNum = sourceNum;
        this.primaryInput = false;
        this.fileContent = str;
        this.fileIndex = fileIndex;
        this.macroExpansion = true;
        this.nextLine = line;
        this.nextCol = col;
    }

    public InputSource(int sourceNum, File file, Charset charset, int fileIndex) throws IOException {
        this(sourceNum, file, charset, fileIndex, false);
    }

    public InputSource(int sourceNum, File file, Charset charset, int fileIndex, boolean isPrimary) throws IOException {
        this(sourceNum, file.getName(), new FileInputStream(file), charset, fileIndex, isPrimary);
    }

    public InputSource(int sourceNum, String fileName, InputStream file, Charset charset, int fileIndex, boolean isPrimary) throws IOException {
        LOGGER.trace("New InputSource object for include stream '{}'", (Object)fileName);
        this.sourceNum = sourceNum;
        this.primaryInput = isPrimary;
        this.fileIndex = fileIndex;
        ByteSource src = ByteSource.wrap((byte[])ByteStreams.toByteArray((InputStream)file));
        if (((Boolean)src.read((ByteProcessor)new XCodedFileByteProcessor())).booleanValue()) {
            throw new XCodedFileException(fileName);
        }
        this.fileContent = src.asCharSource(charset).read();
        this.macroExpansion = false;
    }

    public int get() {
        if (this.currPos >= this.fileContent.length()) {
            return -1;
        }
        char currChar = this.fileContent.charAt(this.currPos++);
        if (!this.macroExpansion) {
            if (currChar == '\n') {
                ++this.nextLine;
                this.nextCol = 1;
            } else {
                ++this.nextCol;
            }
        }
        return currChar;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public boolean isMacroExpansion() {
        return this.macroExpansion;
    }

    public int getSourceNum() {
        return this.sourceNum;
    }

    public int getNextCol() {
        return this.nextCol;
    }

    public int getNextLine() {
        return this.nextLine;
    }

    @CheckForNull
    public String getAnalyzeSuspend() {
        return this.currAnalyzeSuspend;
    }

    public void setAnalyzeSuspend(@Nonnull String str) {
        this.currAnalyzeSuspend = str;
    }

    public boolean isPrimaryInput() {
        return this.primaryInput;
    }

    public void setNextCol(int nextCol) {
        this.nextCol = nextCol;
    }

    public void setNextLine(int nextLine) {
        this.nextLine = nextLine;
    }

    private class XCodedFileByteProcessor
    implements ByteProcessor<Boolean> {
        private boolean isXCoded = false;

        private XCodedFileByteProcessor() {
        }

        public boolean processBytes(byte[] buf, int off, int len) throws IOException {
            this.isXCoded = len > 0 && (buf[0] == 17 || buf[0] == 19);
            return false;
        }

        public Boolean getResult() {
            return this.isXCoded;
        }
    }
}

