/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.RuleNode;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.AttributeKey;
import org.prorefactor.core.AttributeValue;
import org.prorefactor.proparse.ParserSupport;
import org.prorefactor.proparse.SymbolScope;
import org.prorefactor.proparse.antlr4.AST;
import org.prorefactor.proparse.antlr4.ICallback;
import org.prorefactor.proparse.antlr4.JPNodeQuery;
import org.prorefactor.proparse.antlr4.ProToken;
import org.prorefactor.proparse.antlr4.nodetypes.BlockNode;
import org.prorefactor.proparse.antlr4.nodetypes.FieldRefNode;
import org.prorefactor.proparse.antlr4.nodetypes.ProgramRootNode;
import org.prorefactor.treeparser.Call;
import org.prorefactor.treeparser.symbols.FieldContainer;
import org.prorefactor.treeparser.symbols.Symbol;

public class JPNode
implements AST {
    private ProToken token;
    private JPNode down;
    private JPNode right;
    private JPNode left;
    private JPNode up;
    private Map<Integer, Integer> attrMap;
    private Map<String, String> attrMapStrings;
    private Map<Integer, Object> linkMap;
    private Map<Integer, String> stringAttributes;
    private static final BiMap<Integer, String> attrStrEqs = HashBiMap.create();

    protected JPNode(ProToken t) {
        this.token = t;
    }

    public void addChild(AST child) {
        if (child == null) {
            return;
        }
        JPNode node = this.down;
        if (node != null) {
            while (node.right != null) {
                node = node.right;
            }
            node.right = (JPNode)child;
        } else {
            this.down = (JPNode)child;
        }
    }

    @Override
    public int getNumberOfChildren() {
        int n = 0;
        JPNode node = this.down;
        if (node != null) {
            n = 1;
            while (node.right != null) {
                node = node.right;
                ++n;
            }
            return n;
        }
        return n;
    }

    @Override
    public JPNode getFirstChild() {
        return this.down;
    }

    @Override
    public JPNode getNextSibling() {
        return this.right;
    }

    @Override
    public String getText() {
        return this.token.getText();
    }

    @Override
    public int getType() {
        return this.token.getNodeType().getType();
    }

    @Override
    public int getLine() {
        return this.token.getLine();
    }

    @Override
    public int getColumn() {
        return this.token.getCharPositionInLine();
    }

    @Override
    public ABLNodeType getNodeType() {
        return this.token.getNodeType();
    }

    public int getSourceNum() {
        return this.token.getMacroSourceNum();
    }

    public int getEndLine() {
        return this.token.getEndLine();
    }

    public int getEndColumn() {
        return this.token.getEndCharPositionInLine();
    }

    public int getFileIndex() {
        return this.token.getFileIndex();
    }

    public int getEndFileIndex() {
        return this.token.getEndFileIndex();
    }

    public String getAnalyzeSuspend() {
        return this.token.getAnalyzeSuspend();
    }

    public JPNode getParent() {
        return this.up;
    }

    public JPNode getPreviousSibling() {
        return this.left;
    }

    public JPNode firstNaturalChild() {
        return null;
    }

    public JPNode getLastDescendant() {
        if (this.down == null) {
            return this;
        }
        JPNode node = this.down;
        while (node.right != null) {
            node = node.right;
        }
        return node.getLastDescendant();
    }

    public JPNode nextNode() {
        return this.down == null ? this.right : this.down;
    }

    public JPNode getPreviousNode() {
        return this.left == null ? this.up : this.left;
    }

    public List<JPNode> getDirectChildren() {
        ArrayList<JPNode> ret = new ArrayList<JPNode>();
        for (JPNode n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            ret.add(n);
        }
        return ret;
    }

    public List<JPNode> query(ABLNodeType type, ABLNodeType ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(type, findTypes);
        this.walk(query);
        return query.getResult();
    }

    public List<JPNode> queryMainFile(ABLNodeType type, ABLNodeType ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(false, true, null, type, findTypes);
        this.walk(query);
        return query.getResult();
    }

    public List<JPNode> queryStateHead(ABLNodeType type, ABLNodeType ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(true, type, findTypes);
        this.walk(query);
        return query.getResult();
    }

    public List<JPNode> queryCurrentStatement(ABLNodeType type, ABLNodeType ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(false, false, this.getStatement(), type, findTypes);
        this.walk(query);
        return query.getResult();
    }

    @Deprecated
    public List<JPNode> query(Integer ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(findTypes);
        this.walk(query);
        return query.getResult();
    }

    @Deprecated
    public List<JPNode> queryMainFile(Integer ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(false, true, null, findTypes);
        this.walk(query);
        return query.getResult();
    }

    @Deprecated
    public List<JPNode> queryStateHead(Integer ... findTypes) {
        JPNodeQuery query = new JPNodeQuery(true, findTypes);
        this.walk(query);
        return query.getResult();
    }

    public ProToken findFirstHiddenAfterLastDescendant() {
        JPNode nextNatural = this.getNextSibling();
        if (nextNatural == null) {
            return null;
        }
        if (nextNatural.getNodeType() != ABLNodeType.PROGRAM_TAIL && (nextNatural = nextNatural.firstNaturalChild()) == null) {
            return null;
        }
        return nextNatural.getHiddenFirst();
    }

    public JPNode findDirectChild(ABLNodeType nodeType) {
        for (JPNode node = this.down; node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != nodeType) continue;
            return node;
        }
        return null;
    }

    public JPNode findDirectChild(int nodeType) {
        return this.findDirectChild(ABLNodeType.getNodeType(nodeType));
    }

    public int attrGet(int key) {
        if (this.attrMap != null && this.attrMap.containsKey(key)) {
            return this.attrMap.get(key);
        }
        switch (key) {
            case 1700: {
                return this.isAbbreviated() ? 1 : 0;
            }
            case 2300: {
                return this.token.getMacroSourceNum();
            }
        }
        return 0;
    }

    public String attrGetS(int attrNum) {
        if (attrNum != 2400) {
            throw new IllegalArgumentException("Invalid value " + attrNum);
        }
        if (this.stringAttributes != null && this.stringAttributes.containsKey(attrNum)) {
            return this.stringAttributes.get(attrNum);
        }
        return "";
    }

    public String attrGetS(String attrName) {
        String ret;
        if ("qualified-class".equalsIgnoreCase(attrName)) {
            throw new IllegalArgumentException("Invalid value " + attrName);
        }
        if (this.attrMapStrings != null && (ret = this.attrMapStrings.get(attrName)) != null) {
            return ret;
        }
        Integer intKey = JPNode.attrEq(attrName);
        if (intKey != null) {
            return this.attrGetS(intKey);
        }
        return "";
    }

    public void attrSet(int key, String value) {
        if (this.stringAttributes == null) {
            this.stringAttributes = new HashMap<Integer, String>();
        }
        this.stringAttributes.put(key, value);
    }

    public void attrSet(Integer key, int val) {
        if (this.attrMap == null) {
            this.initAttrMap();
        }
        this.attrMap.put(key, val);
    }

    public void attrSetS(String key, String value) {
        if (this.attrMapStrings == null) {
            this.attrMapStrings = new HashMap<String, String>();
        }
        this.attrMapStrings.put(key, value);
    }

    public void setOperator() {
        this.attrSet((Integer)1200, 1);
    }

    public Object getLink(Integer key) {
        if (this.linkMap == null) {
            return null;
        }
        return this.linkMap.get(key);
    }

    public JPNode getOriginal() {
        if (this.linkMap == null) {
            return null;
        }
        return (JPNode)this.linkMap.get(-216);
    }

    public int getState2() {
        return this.attrGet(1300);
    }

    public Call getCall() {
        return (Call)this.getLink(-218);
    }

    public void setStatementHead() {
        this.attrSet((Integer)1400, 1);
    }

    public void setStatementHead(int state2) {
        this.attrSet((Integer)1400, 1);
        if (state2 != 0) {
            this.attrSet((Integer)1300, state2);
        }
    }

    public Symbol getSymbol() {
        return (Symbol)this.getLink(-210);
    }

    private static Integer attrEq(String attrName) {
        return (Integer)attrStrEqs.inverse().get((Object)attrName);
    }

    public boolean hasTableBuffer() {
        return this.getLink(-210) != null;
    }

    public boolean hasBufferScope() {
        return this.getLink(-212) != null;
    }

    public boolean hasBlock() {
        return this.getLink(-214) != null;
    }

    public boolean hasProparseDirective(String directive) {
        return false;
    }

    public String getComments() {
        return null;
    }

    public FieldContainer getFieldContainer() {
        return (FieldContainer)this.getLink(-217);
    }

    public ProToken getHiddenFirst() {
        return null;
    }

    public List<ProToken> getHiddenTokens() {
        LinkedList<ProToken> ret = new LinkedList<ProToken>();
        return ret;
    }

    public JPNode getStatement() {
        JPNode n;
        for (n = this; n != null && !n.isStateHead(); n = n.getParent()) {
        }
        return n;
    }

    public JPNode getParent(ABLNodeType type) {
        if (type == this.getNodeType()) {
            return this;
        }
        if (this.isStateHead()) {
            return null;
        }
        if (this.getParent() != null) {
            return this.getParent().getParent(type);
        }
        return null;
    }

    public String getAnnotationName() {
        if (this.getNodeType() != ABLNodeType.ANNOTATION) {
            return "";
        }
        StringBuilder annName = new StringBuilder(this.token.getText().substring(1));
        for (JPNode tok = this.down; tok != null && tok.getNodeType() != ABLNodeType.PERIOD && tok.getNodeType() != ABLNodeType.LEFTPAREN; tok = tok.getNextSibling()) {
            annName.append(tok.getText());
        }
        return annName.toString();
    }

    private void initAttrMap() {
        if (this.attrMap == null) {
            this.attrMap = new HashMap<Integer, Integer>();
        }
    }

    private void initLinkMap() {
        if (this.linkMap == null) {
            this.linkMap = new HashMap<Integer, Object>();
        }
    }

    public boolean isAbbreviated() {
        return this.token.getNodeType().isAbbreviated(this.getText());
    }

    public boolean isEditableInAB() {
        return false;
    }

    public boolean isNatural() {
        return false;
    }

    public boolean isStateHead() {
        return this.attrGet(1400) == 1;
    }

    public void setCall(Call call) {
        this.setLink(-218, call);
    }

    public void setComments(String comments) {
        this.setLink(-215, comments);
    }

    public void setFieldContainer(FieldContainer fieldContainer) {
        this.setLink(-217, fieldContainer);
    }

    public void setLink(Integer key, Object value) {
        if (this.linkMap == null) {
            this.initLinkMap();
        }
        this.linkMap.put(key, value);
    }

    public void setSymbol(Symbol symbol) {
        this.setLink(-210, symbol);
    }

    public int size() {
        int sz = 1;
        for (JPNode node : this.getDirectChildren()) {
            sz += node.size();
        }
        return sz;
    }

    public int naturalSize() {
        int sz = this.isNatural() ? 1 : 0;
        for (JPNode node : this.getDirectChildren()) {
            sz += node.naturalSize();
        }
        return sz;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append((Object)this.token.getNodeType()).append(" \"").append(this.getText()).append("\" F").append(this.getFileIndex()).append('/').append(this.getLine()).append(':').append(this.getColumn());
        return buff.toString();
    }

    public void walk(ICallback<?> callback) {
        if (this.attrGet(1200) == 1) {
            this.getFirstChild().walk(callback);
            callback.visitNode(this);
            this.getFirstChild().getNextSibling().walk(callback);
        } else {
            boolean visitChildren = callback.visitNode(this);
            if (visitChildren) {
                for (JPNode child : this.getDirectChildren()) {
                    child.walk(callback);
                }
            }
        }
    }

    public String allLeadingHiddenText() {
        return null;
    }

    static {
        for (AttributeKey attributeKey : AttributeKey.values()) {
            attrStrEqs.put((Object)attributeKey.getKey(), (Object)attributeKey.getName());
        }
        for (Enum enum_ : AttributeValue.values()) {
            attrStrEqs.put((Object)((AttributeValue)enum_).getKey(), (Object)((AttributeValue)enum_).getName());
        }
    }

    public static class Builder {
        private ProToken tok;
        private RuleNode ctx;
        private Builder right;
        private Builder down;
        private boolean stmt;
        private ABLNodeType stmt2;
        private boolean operator;
        private SymbolScope.FieldType tabletype;
        private String className;
        private boolean inline;

        public Builder(ProToken tok) {
            this.tok = tok;
        }

        public Builder(ABLNodeType type) {
            this(type, "");
        }

        public Builder(ABLNodeType type, String text) {
            this(new ProToken(type, text));
        }

        public Builder setRuleNode(RuleNode ctx) {
            this.ctx = ctx;
            return this;
        }

        public Builder setRight(Builder right) {
            this.right = right;
            return this;
        }

        public Builder setDown(Builder down) {
            this.down = down;
            return this;
        }

        public Builder getDown() {
            return this.down;
        }

        public Builder getRight() {
            return this.right;
        }

        public Builder changeType(ABLNodeType type) {
            this.tok.setNodeType(type);
            return this;
        }

        public Builder getLast() {
            if (this.right == null) {
                return this;
            }
            return this.right.getLast();
        }

        public Builder setStatement() {
            this.stmt = true;
            return this;
        }

        public Builder setStatement(ABLNodeType stmt2) {
            this.stmt = true;
            this.stmt2 = stmt2;
            return this;
        }

        public Builder setOperator() {
            this.operator = true;
            return this;
        }

        public Builder setStoreType(SymbolScope.FieldType tabletype) {
            this.tabletype = tabletype;
            return this;
        }

        public Builder setClassname(String name) {
            this.className = name;
            return this;
        }

        public ABLNodeType getNodeType() {
            return this.tok.getNodeType();
        }

        public Builder setInlineVar() {
            this.inline = true;
            return this;
        }

        public Builder moveRightToDown() {
            if (this.right == null) {
                throw new NullPointerException();
            }
            if (this.down == null) {
                this.down = this.right;
                this.right = this.down.right;
                this.down.right = null;
            } else {
                Builder target = this.down;
                while (target.getRight() != null) {
                    target = target.getRight();
                }
                target.right = this.right;
                this.right = target.right.right;
                target.right.right = null;
            }
            return this;
        }

        public JPNode build(ParserSupport support) {
            JPNode node;
            switch (this.tok.getNodeType()) {
                case FIELD_REF: {
                    node = new FieldRefNode(this.tok);
                    break;
                }
                case PROGRAM_ROOT: {
                    node = new ProgramRootNode(this.tok);
                    break;
                }
                case PROPERTY_GETTER: 
                case PROPERTY_SETTER: {
                    node = new BlockNode(this.tok);
                    break;
                }
                default: {
                    node = new JPNode(this.tok);
                }
            }
            if (this.className != null) {
                node.attrSet(2400, this.className);
            }
            if (this.stmt) {
                node.setStatementHead(this.stmt2 == null ? 0 : this.stmt2.getType());
            }
            if (this.operator) {
                node.setOperator();
            }
            if (this.inline) {
                node.attrSet((Integer)2000, 1);
            }
            if (this.tabletype != null) {
                switch (this.tabletype) {
                    case DBTABLE: {
                        node.attrSet((Integer)1100, 1102);
                        break;
                    }
                    case TTABLE: {
                        node.attrSet((Integer)1100, 1103);
                        break;
                    }
                    case WTABLE: {
                        node.attrSet((Integer)1100, 1104);
                        break;
                    }
                }
            }
            if (this.down != null) {
                node.down = this.down.build(support);
                node.down.up = node;
            }
            if (this.right != null) {
                node.right = this.right.build(support);
                node.right.left = node;
            }
            if (this.ctx != null) {
                support.pushNode(this.ctx, node);
            }
            return node;
        }
    }
}

