/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.proparse.antlr4.ICallback;
import org.prorefactor.proparse.antlr4.JPNode;

class JPNodeQuery
implements ICallback<List<JPNode>> {
    private final List<JPNode> result = new ArrayList<JPNode>();
    private final Set<ABLNodeType> findTypes;
    private final boolean stateHeadOnly;
    private final boolean mainFileOnly;
    private final JPNode currStatement;

    @Deprecated
    public JPNodeQuery(Integer ... types) {
        this(false, false, null, types);
    }

    @Deprecated
    public JPNodeQuery(boolean stateHeadOnly, Integer ... types) {
        this(stateHeadOnly, false, null, types);
    }

    @Deprecated
    public JPNodeQuery(boolean stateHeadOnly, boolean mainFileOnly, JPNode currentStatement, Integer ... types) {
        this.stateHeadOnly = stateHeadOnly;
        this.mainFileOnly = mainFileOnly;
        this.currStatement = currentStatement != null && currentStatement.getStatement() != null ? currentStatement.getStatement() : null;
        this.findTypes = new HashSet<ABLNodeType>();
        for (Integer i : types) {
            this.findTypes.add(ABLNodeType.getNodeType(i));
        }
    }

    public JPNodeQuery(ABLNodeType type, ABLNodeType ... types) {
        this(false, false, null, type, types);
    }

    public JPNodeQuery(boolean stateHeadOnly, ABLNodeType type, ABLNodeType ... types) {
        this(stateHeadOnly, false, null, type, types);
    }

    public JPNodeQuery(boolean stateHeadOnly, boolean mainFileOnly, JPNode currentStatement, ABLNodeType type, ABLNodeType ... types) {
        this.stateHeadOnly = stateHeadOnly;
        this.mainFileOnly = mainFileOnly;
        this.currStatement = currentStatement;
        this.findTypes = EnumSet.of(type, types);
    }

    @Override
    public List<JPNode> getResult() {
        return this.result;
    }

    @Override
    public boolean visitNode(JPNode node) {
        if (this.currStatement != null && node.getStatement() != this.currStatement) {
            return false;
        }
        if (this.mainFileOnly && node.getFileIndex() > 0) {
            return true;
        }
        if (this.stateHeadOnly && !node.isStateHead()) {
            return true;
        }
        if (this.findTypes.isEmpty() || this.findTypes.contains((Object)node.getNodeType())) {
            this.result.add(node);
        }
        return true;
    }
}

