/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.proparse.ParserSupport;
import org.prorefactor.proparse.antlr4.JPNode;
import org.prorefactor.proparse.antlr4.ProToken;
import org.prorefactor.proparse.antlr4.Proparse;
import org.prorefactor.proparse.antlr4.ProparseBaseVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPNodeVisitor
extends ProparseBaseVisitor<JPNode.Builder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPNodeVisitor.class);
    private final ParserSupport support;
    private final BufferedTokenStream stream;

    public JPNodeVisitor(ParserSupport support, BufferedTokenStream stream) {
        this.support = support;
        this.stream = stream;
    }

    @Override
    public JPNode.Builder visitProgram(Proparse.ProgramContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.PROGRAM_ROOT, ABLNodeType.PROGRAM_TAIL);
    }

    @Override
    public JPNode.Builder visitCode_block(Proparse.Code_blockContext ctx) {
        this.support.visitorEnterScope((RuleContext)ctx.getParent());
        JPNode.Builder retVal = this.createTree((RuleNode)ctx, ABLNodeType.CODE_BLOCK);
        this.support.visitorExitScope((RuleContext)ctx.getParent());
        return retVal;
    }

    @Override
    public JPNode.Builder visitClass_code_block(Proparse.Class_code_blockContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.CODE_BLOCK);
    }

    @Override
    public JPNode.Builder visitEmpty_statement(Proparse.Empty_statementContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDot_comment(Proparse.Dot_commentContext ctx) {
        ProToken start = (ProToken)ctx.getStart();
        StringBuilder sb = new StringBuilder(".");
        for (int zz = 0; zz < ctx.not_state_end().size(); ++zz) {
            sb.append(ctx.not_state_end(zz).getText()).append(' ');
        }
        ProToken last = (ProToken)ctx.state_end().stop;
        start.setType(ABLNodeType.DOT_COMMENT.getType());
        start.setText(sb.toString());
        start.setEndFileIndex(last.getEndFileIndex());
        start.setEndLine(last.getEndLine());
        start.setEndCharPositionInLine(last.getEndCharPositionInLine());
        return new JPNode.Builder(start);
    }

    @Override
    public JPNode.Builder visitFunc_call_statement(Proparse.Func_call_statementContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.EXPR_STATEMENT).setStatement();
    }

    @Override
    public JPNode.Builder visitFunc_call_statement2(Proparse.Func_call_statement2Context ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx).changeType(ABLNodeType.getNodeType(this.support.isMethodOrFunc(ctx.fname.getText())));
    }

    @Override
    public JPNode.Builder visitExpression_statement(Proparse.Expression_statementContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.EXPR_STATEMENT).setStatement();
    }

    @Override
    public JPNode.Builder visitLabeled_block(Proparse.Labeled_blockContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBlock_for(Proparse.Block_forContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBlock_opt_iterator(Proparse.Block_opt_iteratorContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.BLOCK_ITERATOR);
    }

    @Override
    public JPNode.Builder visitBlock_opt_while(Proparse.Block_opt_whileContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBlock_opt_group_by(Proparse.Block_opt_group_byContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBlock_preselect(Proparse.Block_preselectContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitPseudfn(Proparse.PseudfnContext ctx) {
        if (ctx.funargs() == null) {
            return this.visitChildren((RuleNode)ctx);
        }
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBuiltinfunc(Proparse.BuiltinfuncContext ctx) {
        if (ctx.getChild(0) instanceof TerminalNode) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitArgfunc(Proparse.ArgfuncContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        if (holder.getNodeType() == ABLNodeType.COMPARES) {
            holder.changeType(ABLNodeType.COMPARE);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitOptargfunc(Proparse.OptargfuncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRecordfunc(Proparse.RecordfuncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitParameterBufferFor(Proparse.ParameterBufferForContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitParameterBufferRecord(Proparse.ParameterBufferRecordContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitParameterOther(Proparse.ParameterOtherContext ctx) {
        if (ctx.p == null) {
            return this.createTree((RuleNode)ctx, ABLNodeType.INPUT);
        }
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitParameterlist(Proparse.ParameterlistContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.PARAMETER_LIST);
    }

    @Override
    public JPNode.Builder visitEventlist(Proparse.EventlistContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.EVENT_LIST);
    }

    @Override
    public JPNode.Builder visitAnyOrValueValue(Proparse.AnyOrValueValueContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAnyOrValueAny(Proparse.AnyOrValueAnyContext ctx) {
        JPNode.Builder holder = this.createNode((RuleNode)ctx);
        holder.changeType(ABLNodeType.TYPELESS_TOKEN);
        return holder;
    }

    @Override
    public JPNode.Builder visitValueexpression(Proparse.ValueexpressionContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitExpressionMinus(Proparse.ExpressionMinusContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        holder.changeType(ABLNodeType.UNARY_MINUS);
        return holder;
    }

    @Override
    public JPNode.Builder visitExpressionPlus(Proparse.ExpressionPlusContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        holder.changeType(ABLNodeType.UNARY_PLUS);
        return holder;
    }

    @Override
    public JPNode.Builder visitExpressionOp1(Proparse.ExpressionOp1Context ctx) {
        JPNode.Builder holder = this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
        if (holder.getNodeType() == ABLNodeType.STAR) {
            holder.changeType(ABLNodeType.MULTIPLY);
        } else if (holder.getNodeType() == ABLNodeType.SLASH) {
            holder.changeType(ABLNodeType.DIVIDE);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitExpressionOp2(Proparse.ExpressionOp2Context ctx) {
        return this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
    }

    @Override
    public JPNode.Builder visitExpressionComparison(Proparse.ExpressionComparisonContext ctx) {
        JPNode.Builder holder = this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
        if (holder.getNodeType() == ABLNodeType.LEFTANGLE) {
            holder.changeType(ABLNodeType.LTHAN);
        } else if (holder.getNodeType() == ABLNodeType.LTOREQUAL) {
            holder.changeType(ABLNodeType.LE);
        } else if (holder.getNodeType() == ABLNodeType.RIGHTANGLE) {
            holder.changeType(ABLNodeType.GTHAN);
        } else if (holder.getNodeType() == ABLNodeType.GTOREQUAL) {
            holder.changeType(ABLNodeType.GE);
        } else if (holder.getNodeType() == ABLNodeType.GTORLT) {
            holder.changeType(ABLNodeType.NE);
        } else if (holder.getNodeType() == ABLNodeType.EQUAL) {
            holder.changeType(ABLNodeType.EQ);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitExpressionStringComparison(Proparse.ExpressionStringComparisonContext ctx) {
        return this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
    }

    @Override
    public JPNode.Builder visitExpressionNot(Proparse.ExpressionNotContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitExpressionAnd(Proparse.ExpressionAndContext ctx) {
        return this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
    }

    @Override
    public JPNode.Builder visitExpressionOr(Proparse.ExpressionOrContext ctx) {
        return this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
    }

    @Override
    public JPNode.Builder visitExprtNoReturnValue(Proparse.ExprtNoReturnValueContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.WIDGET_REF);
    }

    @Override
    public JPNode.Builder visitExprtWidName(Proparse.ExprtWidNameContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.WIDGET_REF);
    }

    @Override
    public JPNode.Builder visitExprtExprt2(Proparse.ExprtExprt2Context ctx) {
        if (ctx.attr_colon() != null) {
            return this.createTree((RuleNode)ctx, ABLNodeType.WIDGET_REF);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitExprt2ParenExpr(Proparse.Exprt2ParenExprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitExprt2ParenCall(Proparse.Exprt2ParenCallContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        holder.changeType(ABLNodeType.getNodeType(this.support.isMethodOrFunc(ctx.fname.getText())));
        return holder;
    }

    @Override
    public JPNode.Builder visitExprt2New(Proparse.Exprt2NewContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitExprt2ParenCall2(Proparse.Exprt2ParenCall2Context ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        holder.changeType(ABLNodeType.LOCAL_METHOD_REF);
        return holder;
    }

    @Override
    public JPNode.Builder visitExprt2Field(Proparse.Exprt2FieldContext ctx) {
        if (ctx.ENTERED() != null) {
            return this.createTree((RuleNode)ctx, ABLNodeType.ENTERED_FUNC);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitWidattrWidName(Proparse.WidattrWidNameContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.WIDGET_REF);
    }

    @Override
    public JPNode.Builder visitWidattrExprt2(Proparse.WidattrExprt2Context ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.WIDGET_REF);
    }

    @Override
    public JPNode.Builder visitGwidget(Proparse.GwidgetContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.WIDGET_REF);
    }

    @Override
    public JPNode.Builder visitFiln(Proparse.FilnContext ctx) {
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFieldn(Proparse.FieldnContext ctx) {
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitField(Proparse.FieldContext ctx) {
        JPNode.Builder holder = this.createTree((RuleNode)ctx, ABLNodeType.FIELD_REF);
        if (ctx.getParent() instanceof Proparse.Message_optContext && this.support.isInlineVar(ctx.getText())) {
            holder.setInlineVar();
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitField_frame_or_browse(Proparse.Field_frame_or_browseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitArray_subscript(Proparse.Array_subscriptContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.ARRAY_SUBSCRIPT);
    }

    @Override
    public JPNode.Builder visitMethod_param_list(Proparse.Method_param_listContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.METHOD_PARAM_LIST);
    }

    @Override
    public JPNode.Builder visitInuic(Proparse.InuicContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRecordAsFormItem(Proparse.RecordAsFormItemContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FORM_ITEM);
    }

    @Override
    public JPNode.Builder visitRecord(Proparse.RecordContext ctx) {
        return this.visitChildren((RuleNode)ctx).changeType(ABLNodeType.RECORD_NAME).setStoreType(this.support.getRecordExpression((RuleContext)ctx));
    }

    @Override
    public JPNode.Builder visitBlocklabel(Proparse.BlocklabelContext ctx) {
        return this.visitChildren((RuleNode)ctx).changeType(ABLNodeType.BLOCK_LABEL);
    }

    @Override
    public JPNode.Builder visitIdentifierUKW(Proparse.IdentifierUKWContext ctx) {
        return this.visitChildren((RuleNode)ctx).changeType(ABLNodeType.ID);
    }

    @Override
    public JPNode.Builder visitNew_identifier(Proparse.New_identifierContext ctx) {
        return this.visitChildren((RuleNode)ctx).changeType(ABLNodeType.ID);
    }

    @Override
    public JPNode.Builder visitFilename(Proparse.FilenameContext ctx) {
        ProToken start;
        ProToken last = start = (ProToken)ctx.t1.start;
        StringBuilder sb = new StringBuilder(ctx.t1.getText());
        for (int zz = 1; zz < ctx.filename_part().size(); ++zz) {
            last = (ProToken)ctx.filename_part((int)zz).start;
            sb.append(last.getText());
        }
        start.setType(ABLNodeType.FILENAME.getType());
        start.setText(sb.toString());
        start.setEndFileIndex(last.getEndFileIndex());
        start.setEndLine(last.getEndLine());
        start.setEndCharPositionInLine(last.getEndCharPositionInLine());
        return new JPNode.Builder(start);
    }

    @Override
    public JPNode.Builder visitType_name(Proparse.Type_nameContext ctx) {
        return this.visitChildren((RuleNode)ctx).changeType(ABLNodeType.TYPE_NAME).setClassname(this.support.lookupClassName(ctx.getText()));
    }

    @Override
    public JPNode.Builder visitType_name2(Proparse.Type_name2Context ctx) {
        return this.visitChildren((RuleNode)ctx).changeType(ABLNodeType.TYPE_NAME);
    }

    @Override
    public JPNode.Builder visitAatraceclosestate(Proparse.AatraceclosestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.CLOSE);
    }

    @Override
    public JPNode.Builder visitAatraceonoffstate(Proparse.AatraceonoffstateContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        if (ctx.OFF() != null) {
            holder.setStatement(ABLNodeType.OFF);
        } else {
            holder.setStatement(ABLNodeType.ON);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitAatracestate(Proparse.AatracestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAccumulatestate(Proparse.AccumulatestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAggregatephrase(Proparse.AggregatephraseContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.AGGREGATE_PHRASE);
    }

    @Override
    public JPNode.Builder visitAggregate_opt(Proparse.Aggregate_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAll_except_fields(Proparse.All_except_fieldsContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAnalyzestate(Proparse.AnalyzestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAnnotation(Proparse.AnnotationContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitApplystate(Proparse.ApplystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitApplystate2(Proparse.Applystate2Context ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAssign_opt(Proparse.Assign_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAssign_opt2(Proparse.Assign_opt2Context ctx) {
        return this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
    }

    @Override
    public JPNode.Builder visitAssignstate(Proparse.AssignstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAssignstate2(Proparse.Assignstate2Context ctx) {
        JPNode.Builder node1 = this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
        JPNode.Builder holder = new JPNode.Builder(ABLNodeType.ASSIGN).setStatement().setDown(node1);
        JPNode.Builder lastNode = node1;
        for (int zz = 3; zz < ctx.getChildCount(); ++zz) {
            lastNode = lastNode.setRight((JPNode.Builder)this.visit(ctx.getChild(zz))).getLast();
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitAssign_equal(Proparse.Assign_equalContext ctx) {
        return this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
    }

    @Override
    public JPNode.Builder visitAssign_field(Proparse.Assign_fieldContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.ASSIGN_FROM_BUFFER);
    }

    @Override
    public JPNode.Builder visitAt_expr(Proparse.At_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAtphrase(Proparse.AtphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitAtphraseab(Proparse.AtphraseabContext ctx) {
        JPNode.Builder builder = this.createTreeFromFirstNode((RuleNode)ctx);
        if (builder.getNodeType() == ABLNodeType.COLUMNS) {
            builder.changeType(ABLNodeType.COLUMN);
        } else if (builder.getNodeType() == ABLNodeType.COLOF) {
            builder.changeType(ABLNodeType.COLUMNOF);
        }
        return builder;
    }

    @Override
    public JPNode.Builder visitBellstate(Proparse.BellstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBuffercomparestate(Proparse.BuffercomparestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBuffercompare_save(Proparse.Buffercompare_saveContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBuffercompare_result(Proparse.Buffercompare_resultContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBuffercompares_block(Proparse.Buffercompares_blockContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.CODE_BLOCK);
    }

    @Override
    public JPNode.Builder visitBuffercompare_when(Proparse.Buffercompare_whenContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBuffercompares_end(Proparse.Buffercompares_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBuffercopystate(Proparse.BuffercopystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBuffercopy_assign(Proparse.Buffercopy_assignContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBy_expr(Proparse.By_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCache_expr(Proparse.Cache_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCallstate(Proparse.CallstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCasesensNot(Proparse.CasesensNotContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.NOT_CASESENS);
    }

    @Override
    public JPNode.Builder visitCasestate(Proparse.CasestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCase_block(Proparse.Case_blockContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.CODE_BLOCK);
    }

    @Override
    public JPNode.Builder visitCase_when(Proparse.Case_whenContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCaseExpression1(Proparse.CaseExpression1Context ctx) {
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCaseExpression2(Proparse.CaseExpression2Context ctx) {
        return this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
    }

    @Override
    public JPNode.Builder visitCase_expr_term(Proparse.Case_expr_termContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCase_otherwise(Proparse.Case_otherwiseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCase_end(Proparse.Case_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCatchstate(Proparse.CatchstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCatch_end(Proparse.Catch_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitChoosestate(Proparse.ChoosestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitChoose_field(Proparse.Choose_fieldContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FORM_ITEM);
    }

    @Override
    public JPNode.Builder visitEnumstate(Proparse.EnumstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDefenumstate(Proparse.DefenumstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.ENUM);
    }

    @Override
    public JPNode.Builder visitEnum_end(Proparse.Enum_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitClassstate(Proparse.ClassstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitClass_inherits(Proparse.Class_inheritsContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitClass_implements(Proparse.Class_implementsContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitClass_end(Proparse.Class_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitClearstate(Proparse.ClearstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitClosequerystate(Proparse.ClosequerystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.QUERY);
    }

    @Override
    public JPNode.Builder visitClosestoredprocedurestate(Proparse.ClosestoredprocedurestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.STOREDPROCEDURE);
    }

    @Override
    public JPNode.Builder visitClosestored_where(Proparse.Closestored_whereContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCollatephrase(Proparse.CollatephraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitColor_anyorvalue(Proparse.Color_anyorvalueContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitColor_expr(Proparse.Color_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitColorspecification(Proparse.ColorspecificationContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitColor_display(Proparse.Color_displayContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitColor_prompt(Proparse.Color_promptContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        if (holder.getNodeType() == ABLNodeType.PROMPTFOR) {
            holder.changeType(ABLNodeType.PROMPT);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitColorstate(Proparse.ColorstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitColumn_expr(Proparse.Column_exprContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        if (holder.getNodeType() == ABLNodeType.COLUMNS) {
            holder.changeType(ABLNodeType.COLUMN);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitColumnformat(Proparse.ColumnformatContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FORMAT_PHRASE);
    }

    @Override
    public JPNode.Builder visitColumnformat_opt(Proparse.Columnformat_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitComboboxphrase(Proparse.ComboboxphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCombobox_opt(Proparse.Combobox_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCompilestate(Proparse.CompilestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCompile_opt(Proparse.Compile_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCompile_lang(Proparse.Compile_langContext ctx) {
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCompile_lang2(Proparse.Compile_lang2Context ctx) {
        return this.visitChildren((RuleNode)ctx).changeType(ABLNodeType.TYPELESS_TOKEN);
    }

    @Override
    public JPNode.Builder visitCompile_into(Proparse.Compile_intoContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCompile_equal(Proparse.Compile_equalContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCompile_append(Proparse.Compile_appendContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCompile_page(Proparse.Compile_pageContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitConnectstate(Proparse.ConnectstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitConstructorstate(Proparse.ConstructorstateContext ctx) {
        JPNode.Builder holder = this.createStatementTreeFromFirstNode((RuleNode)ctx);
        JPNode.Builder typeName = holder.getDown();
        if (typeName.getNodeType() != ABLNodeType.TYPE_NAME) {
            typeName = typeName.getRight();
        }
        if (typeName.getNodeType() == ABLNodeType.TYPE_NAME) {
            typeName.setClassname(this.support.getClassName());
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitConstructor_end(Proparse.Constructor_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitContexthelpid_expr(Proparse.Contexthelpid_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitConvertphrase(Proparse.ConvertphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCopylobstate(Proparse.CopylobstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCopylob_for(Proparse.Copylob_forContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCopylob_starting(Proparse.Copylob_startingContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFor_tenant(Proparse.For_tenantContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCreatestate(Proparse.CreatestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCreate_whatever_state(Proparse.Create_whatever_stateContext ctx) {
        JPNode.Builder holder = this.createStatementTreeFromFirstNode((RuleNode)ctx);
        holder.setStatement(holder.getDown().getNodeType());
        return holder;
    }

    @Override
    public JPNode.Builder visitCreatealiasstate(Proparse.CreatealiasstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.ALIAS);
    }

    @Override
    public JPNode.Builder visitCreate_connect(Proparse.Create_connectContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCreatebrowsestate(Proparse.CreatebrowsestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.BROWSE);
    }

    @Override
    public JPNode.Builder visitCreatequerystate(Proparse.CreatequerystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.QUERY);
    }

    @Override
    public JPNode.Builder visitCreatebufferstate(Proparse.CreatebufferstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.BUFFER);
    }

    @Override
    public JPNode.Builder visitCreatebuffer_name(Proparse.Createbuffer_nameContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCreatedatabasestate(Proparse.CreatedatabasestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.DATABASE);
    }

    @Override
    public JPNode.Builder visitCreatedatabase_from(Proparse.Createdatabase_fromContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitCreateserverstate(Proparse.CreateserverstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.SERVER);
    }

    @Override
    public JPNode.Builder visitCreateserversocketstate(Proparse.CreateserversocketstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.SERVERSOCKET);
    }

    @Override
    public JPNode.Builder visitCreatesocketstate(Proparse.CreatesocketstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.SOCKET);
    }

    @Override
    public JPNode.Builder visitCreatetemptablestate(Proparse.CreatetemptablestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.TEMPTABLE);
    }

    @Override
    public JPNode.Builder visitCreatewidgetstate(Proparse.CreatewidgetstateContext ctx) {
        if (ctx.create_connect() == null) {
            return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.WIDGET);
        }
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.AUTOMATION_OBJECT);
    }

    @Override
    public JPNode.Builder visitCreatewidgetpoolstate(Proparse.CreatewidgetpoolstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.WIDGETPOOL);
    }

    @Override
    public JPNode.Builder visitCurrentvaluefunc(Proparse.CurrentvaluefuncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDatatype_var(Proparse.Datatype_varContext ctx) {
        JPNode.Builder builder = this.visitChildren((RuleNode)ctx);
        if (builder.getNodeType() == ABLNodeType.IN) {
            builder.changeType(ABLNodeType.INTEGER);
        } else if (builder.getNodeType() == ABLNodeType.LOG) {
            builder.changeType(ABLNodeType.LOGICAL);
        } else if (builder.getNodeType() == ABLNodeType.ROW) {
            builder.changeType(ABLNodeType.ROWID);
        } else if (builder.getNodeType() == ABLNodeType.WIDGET) {
            builder.changeType(ABLNodeType.WIDGETHANDLE);
        } else if (ctx.id != null) {
            builder.changeType(ABLNodeType.getNodeType(this.support.abbrevDatatype(ctx.id.getText())));
        }
        return builder;
    }

    @Override
    public JPNode.Builder visitDdeadvisestate(Proparse.DdeadvisestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.ADVISE);
    }

    @Override
    public JPNode.Builder visitDdeexecutestate(Proparse.DdeexecutestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.EXECUTE);
    }

    @Override
    public JPNode.Builder visitDdegetstate(Proparse.DdegetstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.GET);
    }

    @Override
    public JPNode.Builder visitDdeinitiatestate(Proparse.DdeinitiatestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.INITIATE);
    }

    @Override
    public JPNode.Builder visitDderequeststate(Proparse.DderequeststateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.REQUEST);
    }

    @Override
    public JPNode.Builder visitDdesendstate(Proparse.DdesendstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.SEND);
    }

    @Override
    public JPNode.Builder visitDdeterminatestate(Proparse.DdeterminatestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.TERMINATE);
    }

    @Override
    public JPNode.Builder visitDecimals_expr(Proparse.Decimals_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDefault_expr(Proparse.Default_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDefinebrowsestate(Proparse.DefinebrowsestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.BROWSE);
    }

    @Override
    public JPNode.Builder visitDefinebufferstate(Proparse.DefinebufferstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.BUFFER);
    }

    @Override
    public JPNode.Builder visitDefinedatasetstate(Proparse.DefinedatasetstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.DATASET);
    }

    @Override
    public JPNode.Builder visitDefinedatasourcestate(Proparse.DefinedatasourcestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.DATASOURCE);
    }

    @Override
    public JPNode.Builder visitDefineeventstate(Proparse.DefineeventstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.EVENT);
    }

    @Override
    public JPNode.Builder visitDefineframestate(Proparse.DefineframestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.FRAME);
    }

    @Override
    public JPNode.Builder visitDefineimagestate(Proparse.DefineimagestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.IMAGE);
    }

    @Override
    public JPNode.Builder visitDefinemenustate(Proparse.DefinemenustateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.MENU);
    }

    @Override
    public JPNode.Builder visitDefineparameterstate(Proparse.DefineparameterstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.PARAMETER);
    }

    @Override
    public JPNode.Builder visitDefineparam_var(Proparse.Defineparam_varContext ctx) {
        JPNode.Builder retVal = this.visitChildren((RuleNode)ctx).moveRightToDown();
        if (retVal.getDown().getNodeType() == ABLNodeType.CLASS) {
            retVal.moveRightToDown();
        }
        return retVal;
    }

    @Override
    public JPNode.Builder visitDefinepropertystate(Proparse.DefinepropertystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.PROPERTY);
    }

    @Override
    public JPNode.Builder visitDefinequerystate(Proparse.DefinequerystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.QUERY);
    }

    @Override
    public JPNode.Builder visitDefinerectanglestate(Proparse.DefinerectanglestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.RECTANGLE);
    }

    @Override
    public JPNode.Builder visitDefinestreamstate(Proparse.DefinestreamstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.STREAM);
    }

    @Override
    public JPNode.Builder visitDefinesubmenustate(Proparse.DefinesubmenustateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.SUBMENU);
    }

    @Override
    public JPNode.Builder visitDefinetemptablestate(Proparse.DefinetemptablestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.TEMPTABLE);
    }

    @Override
    public JPNode.Builder visitDefineworktablestate(Proparse.DefineworktablestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.WORKTABLE);
    }

    @Override
    public JPNode.Builder visitDefinevariablestate(Proparse.DefinevariablestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.VARIABLE);
    }

    @Override
    public JPNode.Builder visitDefine_share(Proparse.Define_shareContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDef_browse_display(Proparse.Def_browse_displayContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDef_browse_display_item(Proparse.Def_browse_display_itemContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FORM_ITEM);
    }

    @Override
    public JPNode.Builder visitDef_browse_enable(Proparse.Def_browse_enableContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDef_browse_enable_item(Proparse.Def_browse_enable_itemContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FORM_ITEM);
    }

    @Override
    public JPNode.Builder visitDefinebuttonstate(Proparse.DefinebuttonstateContext ctx) {
        JPNode.Builder builder = this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.BUTTON);
        if (builder.getDown().getNodeType() == ABLNodeType.BUTTONS) {
            builder.getDown().changeType(ABLNodeType.BUTTON);
        }
        return builder;
    }

    @Override
    public JPNode.Builder visitButton_opt(Proparse.Button_optContext ctx) {
        if (ctx.IMAGEDOWN() != null || ctx.IMAGE() != null || ctx.IMAGEUP() != null || ctx.IMAGEINSENSITIVE() != null || ctx.MOUSEPOINTER() != null || ctx.NOFOCUS() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitData_relation(Proparse.Data_relationContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitParent_id_relation(Proparse.Parent_id_relationContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitField_mapping_phrase(Proparse.Field_mapping_phraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDatarelation_nested(Proparse.Datarelation_nestedContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitEvent_signature(Proparse.Event_signatureContext ctx) {
        if (ctx.SIGNATURE() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.createTree((RuleNode)ctx, ABLNodeType.SIGNATURE);
    }

    @Override
    public JPNode.Builder visitEvent_delegate(Proparse.Event_delegateContext ctx) {
        if (ctx.DELEGATE() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.createTree((RuleNode)ctx, ABLNodeType.DELEGATE);
    }

    @Override
    public JPNode.Builder visitDefineimage_opt(Proparse.Defineimage_optContext ctx) {
        if (ctx.STRETCHTOFIT() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitMenu_list_item(Proparse.Menu_list_itemContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitMenu_item_opt(Proparse.Menu_item_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDefineproperty_accessor(Proparse.Defineproperty_accessorContext ctx) {
        if (ctx.SET().isEmpty()) {
            return this.createTree((RuleNode)ctx, ABLNodeType.PROPERTY_GETTER);
        }
        return this.createTree((RuleNode)ctx, ABLNodeType.PROPERTY_SETTER);
    }

    @Override
    public JPNode.Builder visitRectangle_opt(Proparse.Rectangle_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDef_table_beforetable(Proparse.Def_table_beforetableContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDef_table_like(Proparse.Def_table_likeContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDef_table_useindex(Proparse.Def_table_useindexContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDef_table_field(Proparse.Def_table_fieldContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        if (holder.getNodeType() == ABLNodeType.FIELDS) {
            holder.changeType(ABLNodeType.FIELD);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitDef_table_index(Proparse.Def_table_indexContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDeletestate(Proparse.DeletestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDeletealiasstate(Proparse.DeletealiasstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.ALIAS);
    }

    @Override
    public JPNode.Builder visitDeleteobjectstate(Proparse.DeleteobjectstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.OBJECT);
    }

    @Override
    public JPNode.Builder visitDeleteprocedurestate(Proparse.DeleteprocedurestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.PROCEDURE);
    }

    @Override
    public JPNode.Builder visitDeletewidgetstate(Proparse.DeletewidgetstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.WIDGET);
    }

    @Override
    public JPNode.Builder visitDeletewidgetpoolstate(Proparse.DeletewidgetpoolstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.WIDGETPOOL);
    }

    @Override
    public JPNode.Builder visitDelimiter_constant(Proparse.Delimiter_constantContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDestructorstate(Proparse.DestructorstateContext ctx) {
        JPNode.Builder holder = this.createStatementTreeFromFirstNode((RuleNode)ctx);
        JPNode.Builder typeName = holder.getDown();
        if (typeName.getNodeType() != ABLNodeType.TYPE_NAME) {
            typeName = typeName.getRight();
        }
        if (typeName.getNodeType() == ABLNodeType.TYPE_NAME) {
            typeName.setClassname(this.support.getClassName());
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitDestructor_end(Proparse.Destructor_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDictionarystate(Proparse.DictionarystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDisablestate(Proparse.DisablestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDisabletriggersstate(Proparse.DisabletriggersstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.TRIGGERS);
    }

    @Override
    public JPNode.Builder visitDisconnectstate(Proparse.DisconnectstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDisplaystate(Proparse.DisplaystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDisplay_item(Proparse.Display_itemContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FORM_ITEM);
    }

    @Override
    public JPNode.Builder visitDisplay_with(Proparse.Display_withContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDostate(Proparse.DostateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDownstate(Proparse.DownstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDynamiccurrentvaluefunc(Proparse.DynamiccurrentvaluefuncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitDynamicnewstate(Proparse.DynamicnewstateContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.ASSIGN_DYNAMIC_NEW).setStatement();
    }

    @Override
    public JPNode.Builder visitField_equal_dynamic_new(Proparse.Field_equal_dynamic_newContext ctx) {
        return this.createTreeFromSecondNode((RuleNode)ctx).setOperator();
    }

    @Override
    public JPNode.Builder visitDynamic_new(Proparse.Dynamic_newContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitEditorphrase(Proparse.EditorphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitEditor_opt(Proparse.Editor_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitEmptytemptablestate(Proparse.EmptytemptablestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitEnablestate(Proparse.EnablestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitEditingphrase(Proparse.EditingphraseContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.EDITING_PHRASE);
    }

    @Override
    public JPNode.Builder visitEntryfunc(Proparse.EntryfuncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitExcept_fields(Proparse.Except_fieldsContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitExcept_using_fields(Proparse.Except_using_fieldsContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitExportstate(Proparse.ExportstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitExtentphrase(Proparse.ExtentphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitField_form_item(Proparse.Field_form_itemContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FORM_ITEM);
    }

    @Override
    public JPNode.Builder visitField_list(Proparse.Field_listContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FIELD_LIST);
    }

    @Override
    public JPNode.Builder visitFields_fields(Proparse.Fields_fieldsContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        if (holder.getNodeType() == ABLNodeType.FIELD) {
            holder.changeType(ABLNodeType.FIELDS);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitFieldoption(Proparse.FieldoptionContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFillinphrase(Proparse.FillinphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFinallystate(Proparse.FinallystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFinally_end(Proparse.Finally_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFindstate(Proparse.FindstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFont_expr(Proparse.Font_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitForstate(Proparse.ForstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFormat_expr(Proparse.Format_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitForm_item(Proparse.Form_itemContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FORM_ITEM);
    }

    @Override
    public JPNode.Builder visitFormstate(Proparse.FormstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFormatphrase(Proparse.FormatphraseContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FORMAT_PHRASE);
    }

    @Override
    public JPNode.Builder visitFormat_opt(Proparse.Format_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFrame_widgetname(Proparse.Frame_widgetnameContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFramephrase(Proparse.FramephraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFrame_exp_col(Proparse.Frame_exp_colContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.WITH_COLUMNS);
    }

    @Override
    public JPNode.Builder visitFrame_exp_down(Proparse.Frame_exp_downContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.WITH_DOWN);
    }

    @Override
    public JPNode.Builder visitBrowse_opt(Proparse.Browse_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFrame_opt(Proparse.Frame_optContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        if (holder.getNodeType() == ABLNodeType.COLUMNS) {
            holder.changeType(ABLNodeType.COLUMN);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitFrameviewas(Proparse.FrameviewasContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFrameviewas_opt(Proparse.Frameviewas_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFrom_pos(Proparse.From_posContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFunctionstate(Proparse.FunctionstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitExt_functionstate(Proparse.Ext_functionstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFunction_end(Proparse.Function_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFunction_params(Proparse.Function_paramsContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.PARAMETER_LIST);
    }

    @Override
    public JPNode.Builder visitFunctionParamBufferFor(Proparse.FunctionParamBufferForContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitFunctionParamStandard(Proparse.FunctionParamStandardContext ctx) {
        if (ctx.qualif == null) {
            return this.createTree((RuleNode)ctx, ABLNodeType.INPUT);
        }
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitGetstate(Proparse.GetstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitGetkeyvaluestate(Proparse.GetkeyvaluestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitGoonphrase(Proparse.GoonphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitHeader_background(Proparse.Header_backgroundContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitHelp_const(Proparse.Help_constContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitHidestate(Proparse.HidestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitIfstate(Proparse.IfstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitIf_else(Proparse.If_elseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitIn_expr(Proparse.In_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitIn_window_expr(Proparse.In_window_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitImagephrase_opt(Proparse.Imagephrase_optContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        return holder;
    }

    @Override
    public JPNode.Builder visitImportstate(Proparse.ImportstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitIn_widgetpool_expr(Proparse.In_widgetpool_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitInitial_constant(Proparse.Initial_constantContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitInputclearstate(Proparse.InputclearstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.CLEAR);
    }

    @Override
    public JPNode.Builder visitInputclosestate(Proparse.InputclosestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.CLOSE);
    }

    @Override
    public JPNode.Builder visitInputfromstate(Proparse.InputfromstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.FROM);
    }

    @Override
    public JPNode.Builder visitInputthroughstate(Proparse.InputthroughstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.THROUGH);
    }

    @Override
    public JPNode.Builder visitInputoutputclosestate(Proparse.InputoutputclosestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.CLOSE);
    }

    @Override
    public JPNode.Builder visitInputoutputthroughstate(Proparse.InputoutputthroughstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.THROUGH);
    }

    @Override
    public JPNode.Builder visitInsertstate(Proparse.InsertstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitInterfacestate(Proparse.InterfacestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitInterface_inherits(Proparse.Interface_inheritsContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitInterface_end(Proparse.Interface_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitIoPhraseAnyTokensSub3(Proparse.IoPhraseAnyTokensSub3Context ctx) {
        ProToken start;
        ProToken last = start = (ProToken)ctx.getStart();
        StringBuilder sb = new StringBuilder(start.getText());
        for (int zz = 1; zz < ctx.not_io_opt().size(); ++zz) {
            last = (ProToken)ctx.not_io_opt((int)zz).start;
            sb.append(last.getText());
        }
        start.setType(ABLNodeType.FILENAME.getType());
        start.setText(sb.toString());
        start.setEndFileIndex(last.getEndFileIndex());
        start.setEndLine(last.getEndLine());
        start.setEndCharPositionInLine(last.getEndCharPositionInLine());
        return new JPNode.Builder(start);
    }

    @Override
    public JPNode.Builder visitIo_opt(Proparse.Io_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitIo_osdir(Proparse.Io_osdirContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitIo_printer(Proparse.Io_printerContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitLabel_constant(Proparse.Label_constantContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitLdbnamefunc(Proparse.LdbnamefuncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitLdbname_opt1(Proparse.Ldbname_opt1Context ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitLeavestate(Proparse.LeavestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitLengthfunc(Proparse.LengthfuncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitLike_field(Proparse.Like_fieldContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitLike_widgetname(Proparse.Like_widgetnameContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitLoadstate(Proparse.LoadstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitLoad_opt(Proparse.Load_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitMessagestate(Proparse.MessagestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitMessage_item(Proparse.Message_itemContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.FORM_ITEM);
    }

    @Override
    public JPNode.Builder visitMessage_opt(Proparse.Message_optContext ctx) {
        JPNode.Builder builder = this.createTreeFromFirstNode((RuleNode)ctx);
        for (JPNode.Builder tmp = builder.getDown(); tmp != null; tmp = tmp.getRight()) {
            if (tmp.getNodeType() != ABLNodeType.BUTTON) continue;
            tmp.changeType(ABLNodeType.BUTTONS);
        }
        return builder;
    }

    @Override
    public JPNode.Builder visitMethodstate(Proparse.MethodstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitMethod_end(Proparse.Method_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitNamespace_prefix(Proparse.Namespace_prefixContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitNamespace_uri(Proparse.Namespace_uriContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitNextstate(Proparse.NextstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitNextpromptstate(Proparse.NextpromptstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitNextvaluefunc(Proparse.NextvaluefuncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitNullphrase(Proparse.NullphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOnstate(Proparse.OnstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOnstate_run_params(Proparse.Onstate_run_paramsContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.PARAMETER_LIST);
    }

    @Override
    public JPNode.Builder visitOn___phrase(Proparse.On___phraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOn_undo(Proparse.On_undoContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOn_action(Proparse.On_actionContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOpenquerystate(Proparse.OpenquerystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.QUERY);
    }

    @Override
    public JPNode.Builder visitOpenquery_opt(Proparse.Openquery_optContext ctx) {
        if (ctx.MAXROWS() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOsappendstate(Proparse.OsappendstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOscommandstate(Proparse.OscommandstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOscopystate(Proparse.OscopystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOscreatedirstate(Proparse.OscreatedirstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOsdeletestate(Proparse.OsdeletestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOsrenamestate(Proparse.OsrenamestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitOutputclosestate(Proparse.OutputclosestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.CLOSE);
    }

    @Override
    public JPNode.Builder visitOutputthroughstate(Proparse.OutputthroughstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.THROUGH);
    }

    @Override
    public JPNode.Builder visitOutputtostate(Proparse.OutputtostateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.TO);
    }

    @Override
    public JPNode.Builder visitPagestate(Proparse.PagestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitPause_expr(Proparse.Pause_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitPausestate(Proparse.PausestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitPause_opt(Proparse.Pause_optContext ctx) {
        if (ctx.MESSAGE() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitProcedure_expr(Proparse.Procedure_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitProcedurestate(Proparse.ProcedurestateContext ctx) {
        JPNode.Builder holder = this.createStatementTreeFromFirstNode((RuleNode)ctx);
        holder.getDown().changeType(ABLNodeType.ID);
        return holder;
    }

    @Override
    public JPNode.Builder visitExt_procedurestate(Proparse.Ext_procedurestateContext ctx) {
        JPNode.Builder holder = this.createStatementTreeFromFirstNode((RuleNode)ctx);
        holder.getDown().changeType(ABLNodeType.ID);
        holder.getDown().getRight().moveRightToDown();
        return holder;
    }

    @Override
    public JPNode.Builder visitProcedure_opt(Proparse.Procedure_optContext ctx) {
        if (ctx.EXTERNAL() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitProcedure_dll_opt(Proparse.Procedure_dll_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitProcedure_end(Proparse.Procedure_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitProcesseventsstate(Proparse.ProcesseventsstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitPromptforstate(Proparse.PromptforstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx).changeType(ABLNodeType.PROMPTFOR);
    }

    @Override
    public JPNode.Builder visitPublishstate(Proparse.PublishstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitPublish_opt1(Proparse.Publish_opt1Context ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitPutstate(Proparse.PutstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitPutcursorstate(Proparse.PutcursorstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.CURSOR);
    }

    @Override
    public JPNode.Builder visitPutscreenstate(Proparse.PutscreenstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.SCREEN);
    }

    @Override
    public JPNode.Builder visitPutkeyvaluestate(Proparse.PutkeyvaluestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitQuery_queryname(Proparse.Query_querynameContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitQuerytuningphrase(Proparse.QuerytuningphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitQuerytuning_opt(Proparse.Querytuning_optContext ctx) {
        if (ctx.CACHESIZE() != null || ctx.DEBUG() != null || ctx.HINT() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitQuitstate(Proparse.QuitstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRadiosetphrase(Proparse.RadiosetphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRadioset_opt(Proparse.Radioset_optContext ctx) {
        if (ctx.RADIOBUTTONS() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRadio_label(Proparse.Radio_labelContext ctx) {
        JPNode.Builder holder = this.visitChildren((RuleNode)ctx);
        if (holder.getNodeType() != ABLNodeType.QSTRING) {
            holder.changeType(ABLNodeType.UNQUOTEDSTRING);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitRawfunc(Proparse.RawfuncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRawtransferstate(Proparse.RawtransferstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitReadkeystate(Proparse.ReadkeystateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRepeatstate(Proparse.RepeatstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRecord_fields(Proparse.Record_fieldsContext ctx) {
        JPNode.Builder holder = this.createTreeFromFirstNode((RuleNode)ctx);
        if (holder.getNodeType() == ABLNodeType.FIELD) {
            holder.changeType(ABLNodeType.FIELDS);
        }
        return holder;
    }

    @Override
    public JPNode.Builder visitRecordphrase(Proparse.RecordphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRecord_opt(Proparse.Record_optContext ctx) {
        if (ctx.LEFT() != null || ctx.OF() != null || ctx.WHERE() != null || ctx.USEINDEX() != null || ctx.USING() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitReleasestate(Proparse.ReleasestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitReleaseexternalstate(Proparse.ReleaseexternalstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.EXTERNAL);
    }

    @Override
    public JPNode.Builder visitReleaseobjectstate(Proparse.ReleaseobjectstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.OBJECT);
    }

    @Override
    public JPNode.Builder visitRepositionstate(Proparse.RepositionstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitReposition_opt(Proparse.Reposition_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitReturnstate(Proparse.ReturnstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRoutinelevelstate(Proparse.RoutinelevelstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitBlocklevelstate(Proparse.BlocklevelstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRow_expr(Proparse.Row_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRunstate(Proparse.RunstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRunOptPersistent(Proparse.RunOptPersistentContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRunOptSingleRun(Proparse.RunOptSingleRunContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRunOptSingleton(Proparse.RunOptSingletonContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRunOptServer(Proparse.RunOptServerContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRunOptAsync(Proparse.RunOptAsyncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRun_event(Proparse.Run_eventContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRun_set(Proparse.Run_setContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitRunstoredprocedurestate(Proparse.RunstoredprocedurestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.STOREDPROCEDURE);
    }

    @Override
    public JPNode.Builder visitRunsuperstate(Proparse.RunsuperstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.SUPER);
    }

    @Override
    public JPNode.Builder visitSavecachestate(Proparse.SavecachestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitScrollstate(Proparse.ScrollstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSeekstate(Proparse.SeekstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSelectionlistphrase(Proparse.SelectionlistphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSelectionlist_opt(Proparse.Selectionlist_optContext ctx) {
        if (ctx.LISTITEMS() != null || ctx.LISTITEMPAIRS() != null || ctx.INNERCHARS() != null || ctx.INNERLINES() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSerialize_name(Proparse.Serialize_nameContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSetstate(Proparse.SetstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitShowstatsstate(Proparse.ShowstatsstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSizephrase(Proparse.SizephraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSkipphrase(Proparse.SkipphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSliderphrase(Proparse.SliderphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSlider_opt(Proparse.Slider_optContext ctx) {
        if (ctx.MAXVALUE() != null || ctx.MINVALUE() != null || ctx.TICMARKS() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSlider_frequency(Proparse.Slider_frequencyContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSpacephrase(Proparse.SpacephraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitStatusstate(Proparse.StatusstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitStatus_opt(Proparse.Status_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitStop_after(Proparse.Stop_afterContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitStopstate(Proparse.StopstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitStream_name_or_handle(Proparse.Stream_name_or_handleContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSubscribestate(Proparse.SubscribestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSubscribe_run(Proparse.Subscribe_runContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSubstringfunc(Proparse.SubstringfuncContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSystemdialogcolorstate(Proparse.SystemdialogcolorstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.COLOR);
    }

    @Override
    public JPNode.Builder visitSystemdialogfontstate(Proparse.SystemdialogfontstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.FONT);
    }

    @Override
    public JPNode.Builder visitSysdiafont_opt(Proparse.Sysdiafont_optContext ctx) {
        if (ctx.MAXSIZE() != null || ctx.MINSIZE() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSystemdialoggetdirstate(Proparse.SystemdialoggetdirstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.GETDIR);
    }

    @Override
    public JPNode.Builder visitSystemdialoggetdir_opt(Proparse.Systemdialoggetdir_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSystemdialoggetfilestate(Proparse.SystemdialoggetfilestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.GETFILE);
    }

    @Override
    public JPNode.Builder visitSysdiagetfile_opt(Proparse.Sysdiagetfile_optContext ctx) {
        if (ctx.FILTERS() != null || ctx.DEFAULTEXTENSION() != null || ctx.INITIALDIR() != null || ctx.UPDATE() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSysdiagetfile_initfilter(Proparse.Sysdiagetfile_initfilterContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSystemdialogprintersetupstate(Proparse.SystemdialogprintersetupstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx, ABLNodeType.PRINTERSETUP);
    }

    @Override
    public JPNode.Builder visitSysdiapri_opt(Proparse.Sysdiapri_optContext ctx) {
        if (ctx.NUMCOPIES() != null) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSystemhelpstate(Proparse.SystemhelpstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSystemhelp_window(Proparse.Systemhelp_windowContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitSystemhelp_opt(Proparse.Systemhelp_optContext ctx) {
        if (ctx.children.size() > 1) {
            return this.createTreeFromFirstNode((RuleNode)ctx);
        }
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitText_opt(Proparse.Text_optContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTextphrase(Proparse.TextphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitThisobjectstate(Proparse.ThisobjectstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTitle_expr(Proparse.Title_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTime_expr(Proparse.Time_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTitlephrase(Proparse.TitlephraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTo_expr(Proparse.To_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitToggleboxphrase(Proparse.ToggleboxphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTooltip_expr(Proparse.Tooltip_exprContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTransactionmodeautomaticstate(Proparse.TransactionmodeautomaticstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTriggerphrase(Proparse.TriggerphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTrigger_block(Proparse.Trigger_blockContext ctx) {
        return this.createTree((RuleNode)ctx, ABLNodeType.CODE_BLOCK);
    }

    @Override
    public JPNode.Builder visitTrigger_on(Proparse.Trigger_onContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTriggers_end(Proparse.Triggers_endContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTriggerprocedurestate(Proparse.TriggerprocedurestateContext ctx) {
        JPNode.Builder node = this.createStatementTreeFromFirstNode((RuleNode)ctx);
        if (ctx.buff != null) {
            if (ctx.newBuff != null) {
                this.support.defBuffer(ctx.newBuff.getText(), ctx.buff.getText());
            }
            if (ctx.oldBuff != null) {
                this.support.defBuffer(ctx.oldBuff.getText(), ctx.buff.getText());
            }
        }
        return node;
    }

    @Override
    public JPNode.Builder visitTrigger_of(Proparse.Trigger_ofContext ctx) {
        JPNode.Builder node = this.createTreeFromFirstNode((RuleNode)ctx);
        if (ctx.id != null) {
            this.support.defVar(ctx.id.getText());
        }
        return node;
    }

    @Override
    public JPNode.Builder visitTrigger_table_label(Proparse.Trigger_table_labelContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitTrigger_old(Proparse.Trigger_oldContext ctx) {
        JPNode.Builder node = this.createTreeFromFirstNode((RuleNode)ctx);
        this.support.defVar(ctx.id.getText());
        return node;
    }

    @Override
    public JPNode.Builder visitUnderlinestate(Proparse.UnderlinestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitUndostate(Proparse.UndostateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitUndo_action(Proparse.Undo_actionContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitUnloadstate(Proparse.UnloadstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitUnsubscribestate(Proparse.UnsubscribestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitUpstate(Proparse.UpstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitUpdate_field(Proparse.Update_fieldContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitUpdatestate(Proparse.UpdatestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitUsestate(Proparse.UsestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitUsing_row(Proparse.Using_rowContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitUsingstate(Proparse.UsingstateContext ctx) {
        JPNode.Builder using = (JPNode.Builder)this.visit((ParseTree)ctx.USING());
        using.setStatement();
        ProToken typ = (ProToken)ctx.type.start;
        typ.setNodeType(ABLNodeType.TYPE_NAME);
        if (ctx.star != null) {
            typ.setText(typ.getText() + "*");
            typ.setEndFileIndex(((ProToken)ctx.star).getEndFileIndex());
            typ.setEndLine(((ProToken)ctx.star).getEndLine());
            typ.setEndCharPositionInLine(((ProToken)ctx.star).getEndCharPositionInLine());
        }
        JPNode.Builder child1 = new JPNode.Builder(typ);
        using.setDown(child1);
        JPNode.Builder last = child1.getLast();
        if (ctx.using_from() != null) {
            last = last.setRight((JPNode.Builder)this.visit((ParseTree)ctx.using_from())).getRight();
        }
        last = last.setRight((JPNode.Builder)this.visit((ParseTree)ctx.state_end())).getRight();
        this.support.usingState(typ.getText());
        return using;
    }

    @Override
    public JPNode.Builder visitUsing_from(Proparse.Using_fromContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitValidatephrase(Proparse.ValidatephraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitValidatestate(Proparse.ValidatestateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitViewstate(Proparse.ViewstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitViewasphrase(Proparse.ViewasphraseContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitWaitforstate(Proparse.WaitforstateContext ctx) {
        return this.createStatementTreeFromFirstNode((RuleNode)ctx).changeType(ABLNodeType.WAITFOR);
    }

    @Override
    public JPNode.Builder visitWaitfor_or(Proparse.Waitfor_orContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitWaitfor_focus(Proparse.Waitfor_focusContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitWaitfor_set(Proparse.Waitfor_setContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitWhen_exp(Proparse.When_expContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitWidget_id(Proparse.Widget_idContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitXml_data_type(Proparse.Xml_data_typeContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitXml_node_name(Proparse.Xml_node_nameContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    @Override
    public JPNode.Builder visitXml_node_type(Proparse.Xml_node_typeContext ctx) {
        return this.createTreeFromFirstNode((RuleNode)ctx);
    }

    public JPNode.Builder visitChildren(RuleNode ctx) {
        return this.createNode(ctx);
    }

    public JPNode.Builder visitTerminal(TerminalNode node) {
        ProToken t;
        ProToken tok = (ProToken)node.getSymbol();
        ProToken lastHiddenTok = null;
        ProToken firstHiddenTok = null;
        ProToken proToken = t = node.getSymbol().getTokenIndex() > 0 ? (ProToken)this.stream.get(node.getSymbol().getTokenIndex() - 1) : null;
        while (t != null && t.getChannel() == 1) {
            if (firstHiddenTok == null) {
                firstHiddenTok = t;
            } else {
                lastHiddenTok.setHiddenBefore(t);
            }
            lastHiddenTok = t;
            t = t.getTokenIndex() > 0 ? (ProToken)this.stream.get(t.getTokenIndex() - 1) : null;
        }
        if (firstHiddenTok != null) {
            tok.setHiddenBefore(firstHiddenTok);
        }
        return new JPNode.Builder(tok);
    }

    protected JPNode.Builder aggregateResult(JPNode.Builder aggregate, JPNode.Builder nextResult) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private JPNode.Builder createNode(RuleNode ctx) {
        if (ctx.getChildCount() == 0) {
            return null;
        }
        JPNode.Builder firstNode = (JPNode.Builder)this.visit(ctx.getChild(0));
        JPNode.Builder lastNode = firstNode == null ? null : firstNode.getLast();
        for (int zz = 1; zz < ctx.getChildCount(); ++zz) {
            JPNode.Builder xx = (JPNode.Builder)this.visit(ctx.getChild(zz));
            if (lastNode != null) {
                lastNode = lastNode.setRight(xx).getLast();
                continue;
            }
            if (xx == null) continue;
            firstNode = xx;
            lastNode = firstNode.getLast();
        }
        return firstNode;
    }

    private JPNode.Builder createTreeFromFirstNode(RuleNode ctx) {
        if (ctx.getChildCount() == 0) {
            return null;
        }
        JPNode.Builder node = (JPNode.Builder)this.visit(ctx.getChild(0));
        JPNode.Builder firstChild = node.getDown();
        JPNode.Builder lastChild = firstChild == null ? null : firstChild.getLast();
        for (int zz = 1; zz < ctx.getChildCount(); ++zz) {
            JPNode.Builder xx = (JPNode.Builder)this.visit(ctx.getChild(zz));
            if (lastChild != null) {
                lastChild = lastChild.setRight(xx).getLast();
                continue;
            }
            if (xx == null) continue;
            firstChild = xx;
            lastChild = firstChild.getLast();
        }
        node.setDown(firstChild);
        node.setRuleNode(ctx);
        return node;
    }

    private JPNode.Builder createStatementTreeFromFirstNode(RuleNode ctx) {
        return this.createTreeFromFirstNode(ctx).setStatement();
    }

    private JPNode.Builder createStatementTreeFromFirstNode(RuleNode ctx, ABLNodeType state2) {
        return this.createTreeFromFirstNode(ctx).setStatement(state2);
    }

    private JPNode.Builder createTreeFromSecondNode(RuleNode ctx) {
        assert (ctx.getChildCount() >= 3);
        JPNode.Builder node = (JPNode.Builder)this.visit(ctx.getChild(1));
        if (node == null) {
            return null;
        }
        JPNode.Builder left = (JPNode.Builder)this.visit(ctx.getChild(0));
        JPNode.Builder right = (JPNode.Builder)this.visit(ctx.getChild(2));
        node.setDown(left);
        left.getLast().setRight(right);
        JPNode.Builder lastNode = node.getLast();
        for (int zz = 3; zz < ctx.getChildCount(); ++zz) {
            lastNode = lastNode.setRight((JPNode.Builder)this.visit(ctx.getChild(zz))).getLast();
        }
        node.setRuleNode(ctx);
        return node;
    }

    private JPNode.Builder createTree(RuleNode ctx, ABLNodeType parentType) {
        return new JPNode.Builder(parentType).setDown(this.createNode(ctx));
    }

    private JPNode.Builder createTree(RuleNode ctx, ABLNodeType parentType, ABLNodeType tail) {
        JPNode.Builder node = new JPNode.Builder(parentType);
        JPNode.Builder down = this.createNode(ctx);
        node.setDown(down);
        if (down == null) {
            node.setDown(new JPNode.Builder(tail));
        } else {
            down.getLast().setRight(new JPNode.Builder(tail));
        }
        return node;
    }
}

