/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.proparse.antlr4.ProToken;
import org.prorefactor.proparse.antlr4.ProgressLexer;
import org.prorefactor.proparse.antlr4.StringFuncs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Lexer.class);
    private static final int EOF_CHAR = -1;
    private int currChar;
    private int currInt;
    private int currFile;
    private int currLine;
    private int currCol;
    private boolean currMacro;
    private boolean prevMacro;
    private int prevFile;
    private int prevLine;
    private int prevCol;
    private int currStringType;
    private StringBuilder currText = new StringBuilder();
    private final ProgressLexer prepro;
    private boolean mergeNameDotInId = false;
    private boolean gettingAmpIfDefArg = false;
    private boolean preserve = false;
    private int preserveFile;
    private int preserveLine;
    private int preserveCol;
    private int preserveSource;
    private int preserveChar;
    private int textStartFile;
    private int textStartLine;
    private int textStartCol;
    private int textStartSource;
    private Set<Integer> comments = new HashSet<Integer>();
    private Set<Integer> loc = new HashSet<Integer>();

    Lexer(ProgressLexer prepro) {
        this.prepro = prepro;
        this.getChar();
    }

    public ProToken nextToken() {
        LOGGER.trace("Entering nextToken()");
        if (this.preserve) {
            this.textStartFile = this.preserveFile;
            this.textStartLine = this.preserveLine;
            this.textStartCol = this.preserveCol;
            this.textStartSource = this.preserveSource;
            this.currText.setLength(1);
            this.currText.setCharAt(0, (char)this.preserveChar);
            this.preserveDrop();
            if (this.preserveChar == 46) {
                return this.periodStart();
            }
            if (this.preserveChar == 58) {
                return this.colon();
            }
        }
        if (this.currInt == -101) {
            this.textStartFile = this.prepro.getTextStart().getFile();
            this.textStartLine = this.prepro.getTextStart().getLine();
            this.textStartCol = this.prepro.getTextStart().getCol();
            this.textStartSource = this.prepro.getTextStart().getSourceNum();
            this.getChar();
            return this.makeToken(ABLNodeType.PROPARSEDIRECTIVE, this.prepro.getProparseDirectiveText());
        }
        if (this.currInt == -102) {
            this.textStartFile = this.prepro.getTextStart().getFile();
            this.textStartLine = this.prepro.getTextStart().getLine();
            this.textStartCol = this.prepro.getTextStart().getCol();
            this.textStartSource = this.prepro.getTextStart().getSourceNum();
            this.getChar();
            return this.makeToken(ABLNodeType.INCLUDEDIRECTIVE, this.prepro.getIncludeDirectiveText());
        }
        this.textStartFile = this.prepro.getFileIndex();
        this.textStartLine = this.prepro.getLine2();
        this.textStartCol = this.prepro.getColumn();
        this.textStartSource = this.prepro.getSourceNum();
        this.currText.setLength(1);
        this.currText.setCharAt(0, (char)this.currInt);
        if (this.gettingAmpIfDefArg) {
            this.getChar();
            this.gettingAmpIfDefArg = false;
            return this.ampIfDefArg();
        }
        switch (this.currChar) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                this.getChar();
                return this.whitespace();
            }
            case 34: 
            case 39: {
                if (this.prepro.isEscapeCurrent()) {
                    this.getChar();
                    return this.id(ABLNodeType.FILENAME);
                }
                this.currStringType = this.currInt;
                this.getChar();
                return this.quotedString();
            }
            case 47: {
                this.getChar();
                if (this.currChar == 42) {
                    return this.comment();
                }
                if (this.currChar == 47) {
                    return this.singleLineComment();
                }
                if (this.currChar == 40 || this.currIsSpace()) {
                    return this.makeToken(ABLNodeType.SLASH);
                }
                this.append();
                this.getChar();
                return this.id(ABLNodeType.FILENAME);
            }
            case 58: {
                this.getChar();
                return this.colon();
            }
            case 38: {
                this.getChar();
                return this.ampText();
            }
            case 64: {
                this.getChar();
                if (this.currIsSpace()) {
                    return this.makeToken(ABLNodeType.LEXAT);
                }
                this.append();
                this.getChar();
                return this.id(ABLNodeType.ANNOTATION);
            }
            case 91: {
                this.getChar();
                return this.makeToken(ABLNodeType.LEFTBRACE);
            }
            case 93: {
                this.getChar();
                return this.makeToken(ABLNodeType.RIGHTBRACE);
            }
            case 94: {
                this.getChar();
                return this.makeToken(ABLNodeType.CARET);
            }
            case 44: {
                this.getChar();
                return this.makeToken(ABLNodeType.COMMA);
            }
            case 33: {
                this.getChar();
                return this.makeToken(ABLNodeType.EXCLAMATION);
            }
            case 61: {
                this.getChar();
                return this.makeToken(ABLNodeType.EQUAL);
            }
            case 40: {
                this.getChar();
                return this.makeToken(ABLNodeType.LEFTPAREN);
            }
            case 41: {
                this.getChar();
                return this.makeToken(ABLNodeType.RIGHTPAREN);
            }
            case 59: {
                this.getChar();
                return this.makeToken(ABLNodeType.SEMI);
            }
            case 42: {
                this.getChar();
                return this.makeToken(ABLNodeType.STAR);
            }
            case 63: {
                this.getChar();
                return this.makeToken(ABLNodeType.UNKNOWNVALUE);
            }
            case 96: {
                this.getChar();
                return this.makeToken(ABLNodeType.BACKTICK);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.getChar();
                return this.digitStart();
            }
            case 46: {
                this.getChar();
                return this.periodStart();
            }
            case 62: {
                this.getChar();
                if (this.currChar == 61) {
                    this.append();
                    this.getChar();
                    return this.makeToken(ABLNodeType.GTOREQUAL);
                }
                return this.makeToken(ABLNodeType.RIGHTANGLE);
            }
            case 60: {
                this.getChar();
                if (this.currChar == 62) {
                    this.append();
                    this.getChar();
                    return this.makeToken(ABLNodeType.GTORLT);
                }
                if (this.currChar == 61) {
                    this.append();
                    this.getChar();
                    return this.makeToken(ABLNodeType.LTOREQUAL);
                }
                return this.makeToken(ABLNodeType.LEFTANGLE);
            }
            case 43: {
                this.getChar();
                return this.plusMinusStart(ABLNodeType.PLUS);
            }
            case 45: {
                this.getChar();
                return this.plusMinusStart(ABLNodeType.MINUS);
            }
            case 35: 
            case 37: 
            case 124: {
                this.getChar();
                return this.id(ABLNodeType.FILENAME);
            }
        }
        if (this.currInt == -1) {
            this.getChar();
            return this.makeToken(ABLNodeType.EOF_ANTLR4, "");
        }
        this.getChar();
        return this.id(ABLNodeType.ID);
    }

    ProToken getAmpIfDefArg() {
        LOGGER.trace("Entering getAmpIfDefArg()");
        this.gettingAmpIfDefArg = true;
        return this.nextToken();
    }

    private ProToken ampIfDefArg() {
        LOGGER.trace("Entering ampIfDefArg()");
        while (this.currChar != 41) {
            if (this.currChar == 47) {
                this.getChar();
                if (this.currChar != 42) {
                    this.append('/');
                    continue;
                }
                String s = this.currText.toString();
                this.comment();
                this.currText.replace(0, this.currText.length(), s);
                continue;
            }
            this.append();
            this.getChar();
        }
        return this.makeToken(ABLNodeType.ID);
    }

    ProToken colon() {
        LOGGER.trace("Entering colon()");
        if (this.currChar == 58) {
            this.append();
            this.getChar();
            return this.makeToken(ABLNodeType.DOUBLECOLON);
        }
        if (this.currIsSpace()) {
            return this.makeToken(ABLNodeType.LEXCOLON);
        }
        return this.makeToken(ABLNodeType.OBJCOLON);
    }

    ProToken whitespace() {
        LOGGER.trace("Entering whitespace()");
        block3: while (true) {
            switch (this.currChar) {
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    this.append();
                    this.getChar();
                    continue block3;
                }
            }
            break;
        }
        return this.makeToken(ABLNodeType.WS);
    }

    ProToken comment() {
        LOGGER.trace("Entering comment()");
        this.prepro.setDoingComment(true);
        this.append();
        int commentLevel = 1;
        while (commentLevel > 0) {
            this.getChar();
            this.unEscapedAppend();
            if (this.currChar == 47) {
                this.getChar();
                this.unEscapedAppend();
                if (this.currChar != 42) continue;
                ++commentLevel;
                continue;
            }
            if (this.currChar == 42) {
                while (this.currChar == 42) {
                    this.getChar();
                    this.unEscapedAppend();
                    if (this.currChar != 47) continue;
                    --commentLevel;
                }
                continue;
            }
            if (this.currInt != -1) continue;
            this.prepro.lexicalThrow("Missing end of comment");
        }
        this.prepro.setDoingComment(false);
        this.getChar();
        return this.makeToken(ABLNodeType.COMMENT);
    }

    ProToken singleLineComment() {
        LOGGER.trace("Entering singleLineComment()");
        this.prepro.setDoingComment(true);
        this.append();
        while (true) {
            this.getChar();
            if (this.currInt == -1 || !this.prepro.isEscapeCurrent() && (this.currChar == 13 || this.currChar == 10)) {
                this.prepro.setDoingComment(false);
                return this.makeToken(ABLNodeType.COMMENT);
            }
            this.unEscapedAppend();
        }
    }

    ProToken quotedString() {
        LOGGER.trace("Entering quotedString()");
        while (true) {
            if (this.currInt == -1) {
                this.prepro.lexicalThrow("Unmatched quote");
            }
            this.unEscapedAppend();
            if (this.currInt == this.currStringType && !this.prepro.isEscapeCurrent()) {
                this.getChar();
                if (this.currInt != this.currStringType) break;
                this.unEscapedAppend();
            }
            this.getChar();
        }
        if (this.currChar == 58) {
            boolean isStringAttributes = false;
            this.preserveCurrent();
            String theText = ":";
            block4: while (true) {
                this.getChar();
                switch (this.currChar) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 99: 
                    case 108: 
                    case 114: 
                    case 116: 
                    case 117: 
                    case 120: {
                        theText = theText + (char)this.currInt;
                        isStringAttributes = true;
                        continue block4;
                    }
                }
                break;
            }
            if (isStringAttributes) {
                this.append(theText);
                this.preserveDrop();
            } else {
                --this.prevCol;
                ProToken tok = this.makeToken(ABLNodeType.QSTRING);
                ++this.prevCol;
                return tok;
            }
        }
        return this.makeToken(ABLNodeType.QSTRING);
    }

    ProToken digitStart() {
        LOGGER.trace("Entering digitStart()");
        ABLNodeType ttype = ABLNodeType.NUMBER;
        block8: while (true) {
            switch (this.currChar) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.append();
                    this.getChar();
                    continue block8;
                }
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.append();
                    this.getChar();
                    if (ttype == ABLNodeType.FILENAME) continue block8;
                    ttype = ABLNodeType.ID;
                    continue block8;
                }
                case 43: 
                case 45: {
                    this.append();
                    this.getChar();
                    continue block8;
                }
                case 47: {
                    this.append();
                    this.getChar();
                    if (ttype != ABLNodeType.NUMBER) continue block8;
                    ttype = ABLNodeType.LEXDATE;
                    continue block8;
                }
                case 92: {
                    this.append();
                    this.getChar();
                    ttype = ABLNodeType.FILENAME;
                    continue block8;
                }
                case 46: {
                    if (!this.prepro.isNameDot()) break block8;
                    this.append();
                    this.getChar();
                    continue block8;
                }
            }
            break;
        }
        return this.makeToken(ttype);
    }

    ProToken plusMinusStart(ABLNodeType inputType) {
        LOGGER.trace("Entering plusMinusStart()");
        ABLNodeType ttype = ABLNodeType.NUMBER;
        block5: while (true) {
            switch (this.currChar) {
                case 43: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.append();
                    this.getChar();
                    continue block5;
                }
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 47: 
                case 92: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.append();
                    this.getChar();
                    ttype = ABLNodeType.FILENAME;
                    continue block5;
                }
                case 46: {
                    if (!this.prepro.isNameDot()) break block5;
                    this.append();
                    this.getChar();
                    continue block5;
                }
            }
            break;
        }
        if (this.currText.length() == 1) {
            return this.makeToken(inputType);
        }
        return this.makeToken(ttype);
    }

    ProToken periodStart() {
        LOGGER.trace("Entering periodStart()");
        if (!Character.isDigit(this.currChar)) {
            if (this.prepro.isNameDot()) {
                return this.makeToken(ABLNodeType.NAMEDOT);
            }
            return this.makeToken(ABLNodeType.PERIOD);
        }
        ABLNodeType ttype = ABLNodeType.NUMBER;
        block4: while (true) {
            switch (this.currChar) {
                case 43: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.append();
                    this.getChar();
                    continue block4;
                }
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 47: 
                case 92: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.append();
                    this.getChar();
                    ttype = ABLNodeType.FILENAME;
                    continue block4;
                }
            }
            break;
        }
        return this.makeToken(ttype);
    }

    ProToken id(ABLNodeType inputTokenType) {
        LOGGER.trace("Entering id()");
        ABLNodeType ttype = inputTokenType;
        block5: while (true) {
            switch (this.currChar) {
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 59: 
                case 64: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.append();
                    this.getChar();
                    continue block5;
                }
                case 39: 
                case 92: {
                    this.append();
                    this.getChar();
                    if (ttype != ABLNodeType.ID) continue block5;
                    ttype = ABLNodeType.FILENAME;
                    continue block5;
                }
                case 46: {
                    if (!this.mergeNameDotInId || !this.prepro.isNameDot()) break block5;
                    this.append();
                    this.getChar();
                    continue block5;
                }
                default: {
                    if (this.currInt < 128 || this.currInt > 255) break block5;
                    this.append();
                    this.getChar();
                    continue block5;
                }
            }
            break;
        }
        if (ttype == ABLNodeType.ID) {
            ttype = ABLNodeType.getLiteral(this.currText.toString(), ttype);
        }
        return this.makeToken(ttype);
    }

    ProToken ampText() {
        ProToken t;
        LOGGER.trace("Entering ampText()");
        block3: while (true) {
            if (Character.isLetterOrDigit(this.currInt) || this.currInt >= 128 && this.currInt <= 255) {
                this.append();
                this.getChar();
                continue;
            }
            switch (this.currChar) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 45: 
                case 95: {
                    this.append();
                    this.getChar();
                    continue block3;
                }
            }
            if (this.currChar != 47) break;
            this.preserveCurrent();
            this.getChar();
            if (this.currChar != 42) break;
            String s = this.currText.toString();
            this.comment();
            this.currText.replace(0, this.currText.length(), s);
            this.preserveDrop();
        }
        if ((t = this.directive()) != null) {
            return t;
        }
        return this.makeToken(ABLNodeType.FILENAME);
    }

    ProToken directive() {
        LOGGER.trace("Entering directive()");
        String macroType = this.currText.toString().toLowerCase();
        if ("&global-define".startsWith(macroType) && macroType.length() >= 4) {
            this.appendToEOL();
            this.macroDefine(935);
            this.getChar();
            return this.makeToken(ABLNodeType.AMPGLOBALDEFINE);
        }
        if ("&scoped-define".startsWith(macroType) && macroType.length() >= 4) {
            this.appendToEOL();
            this.macroDefine(943);
            this.getChar();
            return this.makeToken(ABLNodeType.AMPSCOPEDDEFINE);
        }
        if ("&undefine".startsWith(macroType) && macroType.length() >= 5) {
            while (Character.isWhitespace(this.currChar)) {
                this.append();
                this.getChar();
            }
            while (!Character.isWhitespace(this.currChar) && this.currInt != -1) {
                this.append();
                this.getChar();
            }
            if (this.currChar == 13) {
                this.append();
                this.getChar();
                if (this.currChar == 10) {
                    this.append();
                    this.getChar();
                }
            } else if (this.currInt != -1) {
                this.append();
                this.getChar();
            }
            this.macroUndefine();
            return this.makeToken(ABLNodeType.AMPUNDEFINE);
        }
        if ("&analyze-suspend".equals(macroType)) {
            this.appendToEOL();
            String analyzeSuspend = "";
            if (this.currText.toString().indexOf(32) != -1) {
                analyzeSuspend = Joiner.on((char)',').join((Iterable)Splitter.on((char)' ').omitEmptyStrings().trimResults().splitToList((CharSequence)this.currText.toString().substring(this.currText.toString().indexOf(32) + 1)));
            }
            this.getChar();
            this.prepro.analyzeSuspend(analyzeSuspend);
            this.prepro.getLstListener().analyzeSuspend(analyzeSuspend, this.textStartLine);
            return this.makeToken(ABLNodeType.AMPANALYZESUSPEND);
        }
        if ("&analyze-resume".equals(macroType)) {
            this.appendToEOL();
            this.getChar();
            this.prepro.analyzeResume();
            this.prepro.getLstListener().analyzeResume(this.textStartLine);
            return this.makeToken(ABLNodeType.AMPANALYZERESUME);
        }
        if ("&message".equals(macroType)) {
            this.appendToEOL();
            this.getChar();
            return this.makeToken(ABLNodeType.AMPMESSAGE);
        }
        if ("&if".equals(macroType)) {
            return this.makeToken(ABLNodeType.AMPIF);
        }
        if ("&then".equals(macroType)) {
            return this.makeToken(ABLNodeType.AMPTHEN);
        }
        if ("&elseif".equals(macroType)) {
            return this.makeToken(ABLNodeType.AMPELSEIF);
        }
        if ("&else".equals(macroType)) {
            return this.makeToken(ABLNodeType.AMPELSE);
        }
        if ("&endif".equals(macroType)) {
            return this.makeToken(ABLNodeType.AMPENDIF);
        }
        return null;
    }

    void append() {
        this.currText.append((char)this.currInt);
    }

    void append(char c) {
        this.currText.append(c);
    }

    void append(String theText) {
        this.currText.append(theText);
    }

    private void appendToEOL() {
        while (true) {
            if (this.currChar == 47) {
                this.append();
                this.getChar();
                if (this.currChar != 42) continue;
                this.comment();
                continue;
            }
            if (this.currInt == -1) break;
            this.append();
            if (this.currChar == 10 && (!this.prepro.wasEscape() || this.prepro.wasEscape() && !this.currText.toString().endsWith("~\n"))) break;
            this.getChar();
        }
    }

    boolean currIsSpace() {
        return this.currInt == -1 || Character.isWhitespace(this.currChar);
    }

    void getChar() {
        this.currInt = this.prepro.getChar();
        this.currChar = Character.toLowerCase(this.currInt);
        this.prevFile = this.currFile;
        this.prevLine = this.currLine;
        this.prevCol = this.currCol;
        this.prevMacro = this.currMacro;
        this.currFile = this.prepro.getFileIndex();
        this.currLine = this.prepro.getLine2();
        this.currCol = this.prepro.getColumn();
        this.currMacro = this.prepro.getMacroExpansion();
    }

    void macroDefine(int defType) {
        LOGGER.trace("Entering macroDefine({})", (Object)defType);
        if (this.prepro.isConsuming() || this.prepro.isLexOnly()) {
            return;
        }
        int it = 0;
        int end = this.currText.length();
        while (!Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        while (Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        int start = it;
        while (!Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        String macroName = this.currText.substring(start, it);
        while (it != end && Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        String defText = StringFuncs.stripComments(this.currText.substring(it));
        defText = defText.trim();
        this.prepro.getLstListener().define(this.textStartLine, this.textStartCol, macroName.toLowerCase(Locale.ENGLISH), defText, defType == 935 ? 1 : 2);
        if (defType == 935) {
            this.prepro.defGlobal(macroName.toLowerCase(), defText);
        } else {
            this.prepro.defScoped(macroName.toLowerCase(), defText);
        }
    }

    void macroUndefine() {
        LOGGER.trace("Entering macroUndefine()");
        if (this.prepro.isConsuming()) {
            return;
        }
        int it = 0;
        int end = this.currText.length();
        while (!Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        while (Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        int start = it;
        while (it != end && !Character.isWhitespace(this.currText.charAt(it))) {
            ++it;
        }
        String macroName = this.currText.substring(start, it);
        this.prepro.getLstListener().undefine(this.textStartLine, this.textStartCol, macroName);
        this.prepro.undef(macroName.toLowerCase());
    }

    ProToken makeToken(ABLNodeType type) {
        return this.makeToken(type, this.currText.toString());
    }

    ProToken makeToken(ABLNodeType type, String text) {
        if (this.textStartFile == 0 && type == ABLNodeType.COMMENT) {
            int numLines = this.currText.toString().length() - this.currText.toString().replace("\n", "").length();
            for (int zz = this.textStartLine; zz <= this.textStartLine + numLines; ++zz) {
                this.comments.add(zz);
            }
        } else if (this.textStartFile == 0 && type != ABLNodeType.WS && type != ABLNodeType.EOF_ANTLR4 && this.textStartLine > 0) {
            this.loc.add(this.textStartLine);
        }
        ProToken tok = new ProToken(type, text);
        tok.setText(text);
        tok.setFileIndex(this.textStartFile);
        tok.setLine(this.textStartLine);
        tok.setCharPositionInLine(this.textStartCol);
        tok.setEndFileIndex(this.prevFile);
        tok.setEndLine(this.prevLine);
        tok.setEndCharPositionInLine(this.prevCol);
        tok.setMacroExpansion(this.prevMacro);
        tok.setMacroSourceNum(this.textStartSource);
        tok.setAnalyzeSuspend(this.prepro.getCurrentAnalyzeSuspend());
        return tok;
    }

    public int getLoc() {
        return this.loc.size();
    }

    public int getCommentedLines() {
        return this.comments.size();
    }

    void preserveCurrent() {
        this.preserve = true;
        this.preserveFile = this.prepro.getFileIndex();
        this.preserveLine = this.prepro.getLine2();
        this.preserveCol = this.prepro.getColumn();
        this.preserveSource = this.prepro.getSourceNum();
        this.preserveChar = this.currChar;
    }

    void preserveDrop() {
        this.preserve = false;
    }

    void unEscapedAppend() {
        if (this.prepro.wasEscape()) {
            this.append(this.prepro.getEscapeText());
            if (this.prepro.isEscapeAppend()) {
                this.append();
            }
        } else {
            this.append();
        }
    }

    public ProgressLexer getPreprocessor() {
        return this.prepro;
    }

    public void setMergeNameDotInId(boolean merge) {
        this.mergeNameDotInId = merge;
    }
}

