/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import java.util.ArrayList;
import java.util.LinkedList;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ListTokenSource;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.ProparseRuntimeException;
import org.prorefactor.proparse.antlr4.Lexer;
import org.prorefactor.proparse.antlr4.PreproEval;
import org.prorefactor.proparse.antlr4.PreprocessorErrorListener;
import org.prorefactor.proparse.antlr4.PreprocessorParser;
import org.prorefactor.proparse.antlr4.ProToken;
import org.prorefactor.proparse.antlr4.ProgressLexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostLexer
implements TokenSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostLexer.class);
    private final Lexer lexer;
    private final ProgressLexer prepro;
    private final PreproEval eval;
    private final LinkedList<PreproIfState> preproIfVec = new LinkedList();
    private ProToken currToken;

    public PostLexer(Lexer lexer) {
        this.lexer = lexer;
        this.prepro = lexer.getPreprocessor();
        this.eval = new PreproEval(this.prepro.getProparseSettings());
    }

    public ProToken nextToken() {
        LOGGER.trace("Entering nextToken()");
        block7: while (true) {
            this.getNextToken();
            switch (this.currToken.getType()) {
                case 939: {
                    this.preproIf();
                    continue block7;
                }
                case 941: {
                    this.throwMessage("Unexpected &THEN");
                    continue block7;
                }
                case 937: {
                    this.preproElseif();
                    continue block7;
                }
                case 936: {
                    this.preproElse();
                    continue block7;
                }
                case 938: {
                    this.preproEndif();
                    continue block7;
                }
            }
            break;
        }
        return this.currToken;
    }

    private ProToken defined() {
        LOGGER.trace("Entering defined()");
        this.getNextToken();
        if (this.currToken.getType() == 906) {
            this.getNextToken();
        }
        if (this.currToken.getType() != 897) {
            this.throwMessage("Bad DEFINED function in &IF preprocessor condition");
        }
        ProToken argToken = this.lexer.getAmpIfDefArg();
        this.getNextToken();
        if (this.currToken.getType() != 898) {
            this.throwMessage("Bad DEFINED function in &IF preprocessor condition");
        }
        return new ProToken(ABLNodeType.NUMBER, this.prepro.defined(argToken.getText().trim().toLowerCase()));
    }

    private void getNextToken() {
        this.currToken = this.lexer.nextToken();
    }

    private void preproconsume() {
        LOGGER.trace("Entering preproconsume()");
        int thisIfLevel = this.preproIfVec.size();
        this.prepro.incrementConsuming();
        block7: while (thisIfLevel <= this.preproIfVec.size() && this.preproIfVec.get(thisIfLevel - 1).consuming) {
            this.getNextToken();
            switch (this.currToken.getType()) {
                case 939: {
                    this.preproIf();
                    continue block7;
                }
                case 937: {
                    this.preproElseif();
                    continue block7;
                }
                case 936: {
                    this.preproElse();
                    continue block7;
                }
                case 938: {
                    this.preproEndif();
                    continue block7;
                }
                case -1: {
                    this.throwMessage("Unexpected end of input when consuming discarded &IF/&ELSEIF/&ELSE text");
                    continue block7;
                }
            }
        }
        this.prepro.decrementConsuming();
    }

    private void preproIf() {
        LOGGER.trace("Entering preproIf()");
        int currLine = this.currToken.getLine();
        int currCol = this.currToken.getCharPositionInLine();
        PreproIfState preproIfState = new PreproIfState();
        this.preproIfVec.add(preproIfState);
        boolean isTrue = this.preproIfCond(!this.prepro.isConsuming());
        if (isTrue) {
            this.prepro.getLstListener().preproIf(currLine, currCol, true);
            preproIfState.done = true;
        } else {
            this.prepro.getLstListener().preproIf(currLine, currCol, false);
            preproIfState.consuming = true;
            this.preproconsume();
        }
    }

    private void preproElse() {
        LOGGER.trace("Entering preproElse()");
        PreproIfState preproIfState = this.preproIfVec.getLast();
        if (!preproIfState.done) {
            preproIfState.consuming = false;
            this.prepro.getLstListener().preproElse(this.currToken.getLine(), this.currToken.getCharPositionInLine());
        } else {
            if (!preproIfState.consuming) {
                this.prepro.getLstListener().preproElse(this.currToken.getLine(), this.currToken.getCharPositionInLine());
                preproIfState.consuming = true;
                this.preproconsume();
            }
            this.prepro.getLstListener().preproElse(this.currToken.getLine(), this.currToken.getCharPositionInLine());
        }
    }

    private void preproElseif() {
        LOGGER.trace("Entering preproElseif()");
        int currLine = this.currToken.getLine();
        int currCol = this.currToken.getCharPositionInLine();
        boolean evaluate = true;
        if (this.prepro.getConsuming() - 1 > 0) {
            evaluate = false;
        }
        if (this.preproIfVec.getLast().done) {
            evaluate = false;
        }
        boolean isTrue = this.preproIfCond(evaluate);
        this.prepro.getLstListener().preproElseIf(currLine, currCol);
        PreproIfState preproIfState = this.preproIfVec.getLast();
        if (isTrue && !preproIfState.done) {
            preproIfState.done = true;
            preproIfState.consuming = false;
        } else if (!preproIfState.consuming) {
            preproIfState.consuming = true;
            this.preproconsume();
        }
    }

    private void preproEndif() {
        LOGGER.trace("Entering preproEndif()");
        this.prepro.getLstListener().preproEndIf(this.currToken.getLine(), this.currToken.getCharPositionInLine());
        if (!this.preproIfVec.isEmpty()) {
            this.preproIfVec.removeLast();
        }
    }

    private boolean preproIfCond(boolean evaluate) {
        LOGGER.trace("Entering preproIfCond()");
        ArrayList<ProToken> tokenVector = new ArrayList<ProToken>();
        boolean done = false;
        block8: while (!done) {
            this.getNextToken();
            switch (this.currToken.getType()) {
                case -1: {
                    this.throwMessage("Unexpected end of input after &IF or &ELSEIF");
                    continue block8;
                }
                case 941: {
                    done = true;
                    continue block8;
                }
                case 193: {
                    if (!evaluate) continue block8;
                    tokenVector.add(this.defined());
                    continue block8;
                }
                case 906: 
                case 907: 
                case 930: {
                    continue block8;
                }
            }
            if (!evaluate) continue;
            tokenVector.add(this.currToken);
        }
        if (tokenVector.isEmpty() || !evaluate) {
            return false;
        }
        CommonTokenStream cts = new CommonTokenStream((TokenSource)new ListTokenSource(tokenVector));
        PreprocessorParser parser = new PreprocessorParser((TokenStream)cts);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new PreprocessorErrorListener(this.prepro, tokenVector));
        try {
            return this.eval.visitPreproIfEval(parser.preproIfEval());
        }
        catch (ParseCancellationException caught) {
            return false;
        }
    }

    private void throwMessage(String msg) {
        throw new ProparseRuntimeException("File '" + this.prepro.getFilename(0) + "' - Current position '" + this.prepro.getFilename(this.currToken.getFileIndex()) + "':" + this.currToken.getLine() + " - " + msg);
    }

    public int getLine() {
        return this.currToken.getLine();
    }

    public int getCharPositionInLine() {
        return this.currToken.getCharPositionInLine();
    }

    public CharStream getInputStream() {
        return this.currToken.getInputStream();
    }

    public String getSourceName() {
        return "<unknown>";
    }

    public void setTokenFactory(TokenFactory<?> factory) {
        throw new UnsupportedOperationException("Unable to override ProTokenFactory");
    }

    public TokenFactory<?> getTokenFactory() {
        return null;
    }

    private static class PreproIfState {
        private boolean consuming = false;
        private boolean done = false;

        private PreproIfState() {
        }
    }
}

