/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.proparse.antlr4.PreprocessorParser;
import org.prorefactor.proparse.antlr4.PreprocessorParserBaseVisitor;
import org.prorefactor.proparse.antlr4.ProEvalException;
import org.prorefactor.proparse.antlr4.StringFuncs;
import org.prorefactor.refactor.settings.IProparseSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreproEval
extends PreprocessorParserBaseVisitor<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreproEval.class);
    private final IProparseSettings settings;

    public PreproEval(IProparseSettings settings) {
        this.settings = settings;
    }

    @Override
    public Boolean visitPreproIfEval(PreprocessorParser.PreproIfEvalContext ctx) {
        LOGGER.trace("Entering visitPreproIfEval()");
        Object o = this.visit((ParseTree)ctx.expr());
        LOGGER.trace("Exiting visitPreproIfEval() with return value '{}'", o);
        return o != null && PreproEval.getBool(o);
    }

    @Override
    public Object visitAnd(PreprocessorParser.AndContext ctx) {
        Object o1 = this.visit((ParseTree)ctx.expr(0));
        Object o2 = this.visit((ParseTree)ctx.expr(1));
        boolean b1 = o1 != null && PreproEval.getBool(o1);
        boolean b2 = o2 != null && PreproEval.getBool(o2);
        return b1 && b2;
    }

    @Override
    public Object visitOr(PreprocessorParser.OrContext ctx) {
        Object o1 = this.visit((ParseTree)ctx.expr(0));
        Object o2 = this.visit((ParseTree)ctx.expr(1));
        boolean b1 = o1 != null && PreproEval.getBool(o1);
        boolean b2 = o2 != null && PreproEval.getBool(o2);
        return b1 || b2;
    }

    @Override
    public Object visitStringOp(PreprocessorParser.StringOpContext ctx) {
        Object o1 = this.visit((ParseTree)ctx.expr(0));
        Object o2 = this.visit((ParseTree)ctx.expr(1));
        if (ctx.op.getType() == 447) {
            return PreproEval.matches(o1, o2);
        }
        return PreproEval.getString(o1).toLowerCase().startsWith(PreproEval.getString(o2).toLowerCase());
    }

    @Override
    public Object visitComparison(PreprocessorParser.ComparisonContext ctx) {
        Object o1 = this.visit((ParseTree)ctx.expr(0));
        Object o2 = this.visit((ParseTree)ctx.expr(1));
        switch (ctx.op.getType()) {
            case 241: 
            case 894: {
                return PreproEval.compare(o1, o2, Compare.EQ);
            }
            case 476: 
            case 892: {
                return PreproEval.compare(o1, o2, Compare.NE);
            }
            case 341: 
            case 884: {
                return PreproEval.compare(o1, o2, Compare.GT);
            }
            case 443: 
            case 883: {
                return PreproEval.compare(o1, o2, Compare.LT);
            }
            case 311: 
            case 891: {
                return PreproEval.compare(o1, o2, Compare.GE);
            }
            case 418: 
            case 893: {
                return PreproEval.compare(o1, o2, Compare.LE);
            }
        }
        return null;
    }

    @Override
    public Object visitPlus(PreprocessorParser.PlusContext ctx) {
        if (ctx.op.getType() == 896) {
            return PreproEval.opPlus(this.visit((ParseTree)ctx.expr(0)), this.visit((ParseTree)ctx.expr(1)));
        }
        return PreproEval.opMinus(this.visit((ParseTree)ctx.expr(0)), this.visit((ParseTree)ctx.expr(1)));
    }

    @Override
    public Object visitMultiply(PreprocessorParser.MultiplyContext ctx) {
        switch (ctx.op.getType()) {
            case 901: 
            case 993: {
                return PreproEval.opMultiply(this.visit((ParseTree)ctx.expr(0)), this.visit((ParseTree)ctx.expr(1)));
            }
            case 900: 
            case 994: {
                return PreproEval.opDivide(this.visit((ParseTree)ctx.expr(0)), this.visit((ParseTree)ctx.expr(1)));
            }
            case 467: {
                Double m1 = (double)PreproEval.getFloat(this.visit((ParseTree)ctx.expr(0))) + 0.5;
                Double m2 = (double)PreproEval.getFloat(this.visit((ParseTree)ctx.expr(1))) + 0.5;
                return m1.intValue() % m2.intValue();
            }
        }
        return null;
    }

    @Override
    public Object visitNot(PreprocessorParser.NotContext ctx) {
        return !PreproEval.getBool(this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public Object visitUnaryMinus(PreprocessorParser.UnaryMinusContext ctx) {
        Object o = this.visit((ParseTree)ctx.expr());
        if (o instanceof Integer) {
            return (Integer)o * -1;
        }
        return Float.valueOf(((Float)o).floatValue() * -1.0f);
    }

    @Override
    public Object visitNumber(PreprocessorParser.NumberContext ctx) {
        return PreproEval.getNumber(ctx.NUMBER().getText());
    }

    @Override
    public Object visitQuotedString(PreprocessorParser.QuotedStringContext ctx) {
        return StringFuncs.qstringStrip(ctx.QSTRING().getText());
    }

    @Override
    public Object visitTrueExpr(PreprocessorParser.TrueExprContext ctx) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitFalseExpr(PreprocessorParser.FalseExprContext ctx) {
        return Boolean.FALSE;
    }

    @Override
    public Object visitExprInParen(PreprocessorParser.ExprInParenContext ctx) {
        return this.visit((ParseTree)ctx.expr());
    }

    @Override
    public Object visitUnknownExpr(PreprocessorParser.UnknownExprContext ctx) {
        return null;
    }

    @Override
    public Object visitIntegerFunction(PreprocessorParser.IntegerFunctionContext ctx) {
        return PreproEval.integer(this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public Object visitInt64Function(PreprocessorParser.Int64FunctionContext ctx) {
        return PreproEval.integer(this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public Object visitDecimalFunction(PreprocessorParser.DecimalFunctionContext ctx) {
        return PreproEval.decimal(this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public Object visitLeftTrimFunction(PreprocessorParser.LeftTrimFunctionContext ctx) {
        Object ch = null;
        if (ctx.trimChars != null) {
            ch = this.visit((ParseTree)ctx.trimChars);
        }
        return PreproEval.lefttrim(this.visit((ParseTree)ctx.expr(0)), ch);
    }

    @Override
    public Object visitRightTrimFunction(PreprocessorParser.RightTrimFunctionContext ctx) {
        if (ctx.trimChars != null) {
            return StringFuncs.rtrim(PreproEval.getString(this.visit((ParseTree)ctx.expr(0))), PreproEval.getString(this.visit((ParseTree)ctx.trimChars)));
        }
        return StringFuncs.rtrim(PreproEval.getString(this.visit((ParseTree)ctx.expr(0))));
    }

    @Override
    public Object visitPropathFunction(PreprocessorParser.PropathFunctionContext ctx) {
        return PreproEval.propath(this.settings);
    }

    @Override
    public Object visitProversionFunction(PreprocessorParser.ProversionFunctionContext ctx) {
        return this.settings.getProversion();
    }

    @Override
    public Object visitEntryFunction(PreprocessorParser.EntryFunctionContext ctx) {
        Object element = this.visit((ParseTree)ctx.element);
        Object list = this.visit((ParseTree)ctx.list);
        Object ch = null;
        if (ctx.character != null) {
            ch = this.visit((ParseTree)ctx.character);
        }
        return PreproEval.entry(element, list, ch);
    }

    @Override
    public Object visitIndexFunction(PreprocessorParser.IndexFunctionContext ctx) {
        Object source = this.visit((ParseTree)ctx.source);
        Object target = this.visit((ParseTree)ctx.target);
        Object start = null;
        if (ctx.starting != null) {
            start = this.visit((ParseTree)ctx.starting);
        }
        return PreproEval.index(source, target, start);
    }

    @Override
    public Object visitLengthFunction(PreprocessorParser.LengthFunctionContext ctx) {
        return this.visit((ParseTree)ctx.expr(0)).toString().length();
    }

    @Override
    public Object visitLookupFunction(PreprocessorParser.LookupFunctionContext ctx) {
        Object expr = this.visit((ParseTree)ctx.expr(0));
        Object list = this.visit((ParseTree)ctx.list);
        Object ch = null;
        if (ctx.character != null) {
            ch = this.visit((ParseTree)ctx.character);
        }
        return PreproEval.lookup(expr, list, ch);
    }

    @Override
    public Object visitMaximumFunction(PreprocessorParser.MaximumFunctionContext ctx) {
        Object ret = null;
        for (PreprocessorParser.ExprContext expr : ctx.expr()) {
            Object o = this.visit((ParseTree)expr);
            if (ret != null && !PreproEval.compare(o, ret, Compare.GT).booleanValue()) continue;
            ret = o;
        }
        return ret;
    }

    @Override
    public Object visitMinimumFunction(PreprocessorParser.MinimumFunctionContext ctx) {
        Object ret = null;
        for (PreprocessorParser.ExprContext expr : ctx.expr()) {
            Object o = this.visit((ParseTree)expr);
            if (ret != null && !PreproEval.compare(o, ret, Compare.LT).booleanValue()) continue;
            ret = o;
        }
        return ret;
    }

    @Override
    public Object visitNumEntriesFunction(PreprocessorParser.NumEntriesFunctionContext ctx) {
        Object list = this.visit((ParseTree)ctx.list);
        Object ch = null;
        if (ctx.character != null) {
            ch = this.visit((ParseTree)ctx.character);
        }
        return PreproEval.numentries(list, ch);
    }

    @Override
    public Object visitOpsysFunction(PreprocessorParser.OpsysFunctionContext ctx) {
        return this.settings.getOpSys().getName();
    }

    @Override
    public Object visitRandomFunction(PreprocessorParser.RandomFunctionContext ctx) {
        return 4;
    }

    @Override
    public Object visitReplaceFunction(PreprocessorParser.ReplaceFunctionContext ctx) {
        return PreproEval.replace(PreproEval.getString(this.visit((ParseTree)ctx.source)), PreproEval.getString(this.visit((ParseTree)ctx.from)), PreproEval.getString(this.visit((ParseTree)ctx.to)));
    }

    @Override
    public Object visitRIndexFunction(PreprocessorParser.RIndexFunctionContext ctx) {
        Object source = this.visit((ParseTree)ctx.source);
        Object target = this.visit((ParseTree)ctx.target);
        Object start = null;
        if (ctx.starting != null) {
            start = this.visit((ParseTree)ctx.starting);
        }
        return PreproEval.rindex(source, target, start);
    }

    @Override
    public Object visitSubstringFunction(PreprocessorParser.SubstringFunctionContext ctx) {
        Object o = this.visit((ParseTree)ctx.expr(0));
        Object pos = this.visit((ParseTree)ctx.position);
        Object len = ctx.length == null ? null : this.visit((ParseTree)ctx.length);
        SubstringType type = SubstringType.CHARACTER;
        if (ctx.type != null && ctx.type.getText() != null) {
            type = SubstringType.valueOf(StringFuncs.qstringStrip(ctx.type.getText()).toUpperCase().trim());
        }
        if (type != SubstringType.CHARACTER) {
            throw new ProEvalException("FIXED / COLUMN / RAW options of SUBSTRING function not yet supported");
        }
        return PreproEval.substring(o, pos, len, type);
    }

    @Override
    public Object visitTrimFunction(PreprocessorParser.TrimFunctionContext ctx) {
        Object expr = this.visit((ParseTree)ctx.expr(0));
        if (ctx.trimChars != null) {
            return StringFuncs.trim(PreproEval.getString(expr), PreproEval.getString(this.visit((ParseTree)ctx.trimChars)));
        }
        return PreproEval.getString(expr).trim();
    }

    @Override
    public Object visitKeywordFunction(PreprocessorParser.KeywordFunctionContext ctx) {
        String str = PreproEval.getString(this.visit((ParseTree)ctx.expr()));
        ABLNodeType nodeType = ABLNodeType.getLiteral(str);
        if (nodeType == null) {
            return null;
        }
        if (nodeType.isReservedKeyword()) {
            return nodeType.getText().toUpperCase();
        }
        return null;
    }

    @Override
    public Object visitKeywordAllFunction(PreprocessorParser.KeywordAllFunctionContext ctx) {
        String str = PreproEval.getString(this.visit((ParseTree)ctx.expr()));
        ABLNodeType nodeType = ABLNodeType.getLiteral(str);
        if (nodeType == null) {
            return null;
        }
        return nodeType.getText().toUpperCase();
    }

    @Override
    public Object visitDbTypeFunction(PreprocessorParser.DbTypeFunctionContext ctx) {
        return "PROGRESS";
    }

    static Boolean compare(Object left, Object right, Compare test) {
        Integer result = PreproEval.compare(left, right);
        if (result == null) {
            if (test == Compare.NE) {
                return true;
            }
            return null;
        }
        switch (test) {
            case EQ: {
                return result == 0;
            }
            case GE: {
                return result >= 0;
            }
            case GT: {
                return result > 0;
            }
            case LE: {
                return result <= 0;
            }
            case LT: {
                return result < 0;
            }
            case NE: {
                return result != 0;
            }
        }
        throw new IllegalArgumentException("Undefined state for Compare object");
    }

    private static Integer compare(Object left, Object right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return ((Boolean)left).compareTo((Boolean)right);
        }
        if (left instanceof String && right instanceof String) {
            return PreproEval.compareStringHelper(left).compareTo(PreproEval.compareStringHelper(right));
        }
        if (left instanceof Number && right instanceof Number) {
            Double fl = ((Number)left).doubleValue();
            Double fr = ((Number)right).doubleValue();
            return fl.compareTo(fr);
        }
        throw new ProEvalException("Incompatible data types in comparison expression.");
    }

    static String compareStringHelper(Object o) {
        return StringFuncs.rtrim(((String)o).toLowerCase());
    }

    static Float decimal(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return Float.valueOf(PreproEval.getNumber((String)o).floatValue());
        }
        if (o instanceof Boolean) {
            return Float.valueOf((Boolean)o != false ? 1.0f : 0.0f);
        }
        throw new ProEvalException("Error converting to DECIMAL.");
    }

    static String entry(Object oa, Object ob, Object odelim) {
        if (oa == null || ob == null) {
            return null;
        }
        int pos = PreproEval.getInt(oa);
        String b = PreproEval.getString(ob);
        String delim = odelim == null ? "," : PreproEval.getString(odelim);
        if (delim.isEmpty()) {
            delim = " ";
        }
        if (pos < 1) {
            throw new ProEvalException("ENTRY function received non-positive number");
        }
        Pattern regex = Pattern.compile(delim = delim.substring(0, 1), 18);
        String[] array = regex.split(b);
        if (pos > array.length) {
            return "";
        }
        return array[pos - 1];
    }

    static boolean getBool(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).length() != 0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Integer) {
            return (Integer)obj != 0;
        }
        throw new ProEvalException("Unknown datatype passed to getBool");
    }

    static float getFloat(Object obj) {
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        throw new ProEvalException("Incompatible datatype");
    }

    static int getInt(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new ProEvalException("Incompatible datatype");
    }

    static Number getNumber(String str) {
        String nbr = str.trim();
        if (nbr.length() == 0) {
            return 0;
        }
        if (nbr.endsWith("-")) {
            nbr = "-" + nbr.substring(0, nbr.length() - 1);
        }
        if (nbr.startsWith("+")) {
            nbr = nbr.substring(1);
        }
        try {
            if (nbr.indexOf(46) > -1) {
                return Float.valueOf(Float.parseFloat(nbr));
            }
            return Integer.parseInt(nbr);
        }
        catch (NumberFormatException e) {
            throw new ProEvalException("Lexical cast to number from '" + str + "' failed");
        }
    }

    static String getString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new ProEvalException("Incompatible datatype");
    }

    static Integer index(Object x, Object y, Object z) {
        if (x == null || y == null) {
            return 0;
        }
        String a = PreproEval.getString(x);
        String b = PreproEval.getString(y);
        if (a.length() == 0 || b.length() == 0) {
            return 0;
        }
        int startIndex = 0;
        if (z != null) {
            startIndex = PreproEval.getInt(z);
        }
        String source = a.toLowerCase();
        String target = b.toLowerCase();
        return source.indexOf(target, startIndex - 1) + 1;
    }

    static Integer integer(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return Math.round(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return Math.round(PreproEval.getNumber((String)o).floatValue());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        throw new ProEvalException("Error converting to INTEGER.");
    }

    static String lefttrim(Object a, Object b) {
        if (b != null) {
            String t = PreproEval.getString(b);
            return StringFuncs.ltrim(PreproEval.getString(a), t);
        }
        return StringFuncs.ltrim(PreproEval.getString(a));
    }

    static Integer lookup(Object x, Object y, Object z) {
        if (x == null || y == null) {
            return null;
        }
        String a = PreproEval.getString(x);
        String b = PreproEval.getString(y);
        if (a.length() == 0 && b.length() == 0) {
            return 1;
        }
        a = a.toLowerCase();
        b = b.toLowerCase();
        String delim = z == null ? "," : ((String)z).toLowerCase();
        Pattern regex = Pattern.compile(delim, 16);
        List<String> expr = Arrays.asList(regex.split(a));
        List<String> list = Arrays.asList(regex.split(b));
        if (expr.size() == 1) {
            return list.indexOf(a) + 1;
        }
        int exprSize = expr.size();
        int listSize = list.size();
        for (int index = 0; index < listSize; ++index) {
            int end = index + exprSize;
            if (end >= listSize) {
                return 0;
            }
            if (!list.subList(index, end).equals(expr)) continue;
            return index + 1;
        }
        return 0;
    }

    static Boolean matches(Object y, Object z) {
        String a = PreproEval.getString(y).toLowerCase();
        String b = PreproEval.getString(z).toLowerCase();
        if (b.length() == 1 && b.charAt(0) == '*') {
            return true;
        }
        if (a.length() == 0) {
            return b.length() == 0;
        }
        if (b.length() == 0) {
            return false;
        }
        if (b.charAt(0) == '.') {
            return PreproEval.matches(a.substring(1), b.substring(1));
        }
        if (b.charAt(0) == '*') {
            return PreproEval.matches(a, b.substring(1)) != false || PreproEval.matches(a.substring(1), b) != false;
        }
        if (b.charAt(0) == '~') {
            return a.charAt(0) == b.charAt(1) && PreproEval.matches(a.substring(1), b.substring(2)) != false;
        }
        return a.charAt(0) == b.charAt(0) && PreproEval.matches(a.substring(1), b.substring(1)) != false;
    }

    static Integer numentries(Object a, Object b) {
        String sa = PreproEval.getString(a);
        if (sa.length() == 0) {
            return 0;
        }
        String sb = b != null ? PreproEval.getString(b) : ",";
        Pattern regex = Pattern.compile(sb, 18);
        return regex.split(sa, -2).length;
    }

    static Object opDivide(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left / (Integer)right;
        }
        if (left instanceof Number && right instanceof Number) {
            Double fl = ((Number)left).doubleValue();
            Double fr = ((Number)right).doubleValue();
            return fl / fr;
        }
        throw new ProEvalException("Incompatible data type in expression.");
    }

    static Object opMinus(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left - (Integer)right;
        }
        if (left instanceof Number && right instanceof Number) {
            Double fl = ((Number)left).doubleValue();
            Double fr = ((Number)right).doubleValue();
            return fl - fr;
        }
        throw new ProEvalException("Incompatible data type in expression.");
    }

    static Object opMultiply(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left * (Integer)right;
        }
        if (left instanceof Number && right instanceof Number) {
            Double fl = ((Number)left).doubleValue();
            Double fr = ((Number)right).doubleValue();
            return fl * fr;
        }
        throw new ProEvalException("Incompatible data type in expression.");
    }

    static Object opPlus(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String && right instanceof String) {
            return (String)left + right;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return (Integer)left + (Integer)right;
        }
        if (left instanceof Number && right instanceof Number) {
            Double fl = ((Number)left).doubleValue();
            Double fr = ((Number)right).doubleValue();
            return fl + fr;
        }
        throw new ProEvalException("Incompatible data type in expression.");
    }

    static String propath(IProparseSettings settings) {
        StringBuilder bldr = new StringBuilder();
        boolean delim = false;
        for (String p : settings.getPropathAsList()) {
            if (delim) {
                bldr.append(',');
            }
            bldr.append(p);
            delim = true;
        }
        return bldr.toString();
    }

    static String replace(String source, String from, String to) {
        Pattern regex = Pattern.compile(from, 18);
        return regex.matcher(source).replaceAll(to);
    }

    static Integer rindex(Object a, Object b, Object c) {
        String source = PreproEval.getString(a).toLowerCase();
        String target = PreproEval.getString(b).toLowerCase();
        if (source.length() == 0 || target.length() == 0) {
            return 0;
        }
        if (c != null) {
            return source.lastIndexOf(target, PreproEval.getInt(c) - 1) + 1;
        }
        return source.lastIndexOf(target) + 1;
    }

    static String string(Object a) {
        if (a == null) {
            return "?";
        }
        if (a instanceof Boolean) {
            return (Boolean)a != false ? "yes" : "no";
        }
        return a.toString();
    }

    static String substring(Object a, Object b, Object c, SubstringType type) {
        String str = PreproEval.getString(a);
        int pos = PreproEval.getInt(b) - 1;
        if (pos >= str.length()) {
            return "";
        }
        int len = -1;
        if (c != null) {
            len = PreproEval.getInt(c);
        }
        if (len == -1) {
            return str.substring(pos);
        }
        int endpos = pos + len;
        if (endpos > str.length()) {
            endpos = str.length();
        }
        return str.substring(pos, endpos);
    }

    private static enum SubstringType {
        CHARACTER,
        FIXED,
        COLUMN,
        RAW;

    }

    static enum Compare {
        EQ,
        NE,
        GT,
        GE,
        LT,
        LE;

    }
}

