/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.prorefactor.proparse.antlr4.PostLexer;
import org.prorefactor.proparse.antlr4.ProToken;
import org.prorefactor.proparse.antlr4.ProgressLexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreprocessorErrorListener
extends BaseErrorListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostLexer.class);
    private final ProgressLexer lexer;
    private final List<ProToken> tokens;

    public PreprocessorErrorListener(ProgressLexer lexer, List<ProToken> tokens) {
        this.lexer = lexer;
        this.tokens = tokens;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        LOGGER.error("Unexpected symbol '{}' in preprocessor expression '{}' at position {}", new Object[]{((Token)offendingSymbol).getText(), this.getExpressionAsString(), charPositionInLine});
        if (this.tokens.isEmpty()) {
            LOGGER.error("Exception found while analyzing '{}'", (Object)this.lexer.getFilename(0));
        } else if (this.tokens.get(0).getFileIndex() == 0) {
            LOGGER.error("Exception found while analyzing '{}' at line {}", (Object)this.lexer.getFilename(0), (Object)this.tokens.get(0).getLine());
        } else {
            LOGGER.error("Exception found in file '{}' at line {} while analyzing '{}'", new Object[]{this.lexer.getFilename(this.tokens.get(0).getFileIndex()), this.tokens.get(0).getLine(), this.lexer.getFilename(0)});
        }
    }

    private String getExpressionAsString() {
        StringBuilder sb = new StringBuilder();
        for (ProToken tok : this.tokens) {
            sb.append(tok.getText()).append(' ');
        }
        return sb.toString();
    }
}

