/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamHiddenTokenFilter;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.JPNodeMetrics;
import org.prorefactor.core.ProparseRuntimeException;
import org.prorefactor.macrolevel.IPreprocessorEventListener;
import org.prorefactor.macrolevel.IncludeRef;
import org.prorefactor.macrolevel.PreprocessorEventListener;
import org.prorefactor.proparse.IntegerIndex;
import org.prorefactor.proparse.antlr4.FunctionKeywordTokenFilter;
import org.prorefactor.proparse.antlr4.IPreprocessor;
import org.prorefactor.proparse.antlr4.IncludeFile;
import org.prorefactor.proparse.antlr4.IncludeFileNotFoundException;
import org.prorefactor.proparse.antlr4.InputSource;
import org.prorefactor.proparse.antlr4.Lexer;
import org.prorefactor.proparse.antlr4.MultiChannelTokenSource;
import org.prorefactor.proparse.antlr4.NoOpPostLexer;
import org.prorefactor.proparse.antlr4.PostLexer;
import org.prorefactor.proparse.antlr4.ProToken;
import org.prorefactor.proparse.antlr4.TokenList;
import org.prorefactor.refactor.RefactorSession;
import org.prorefactor.refactor.settings.IProparseSettings;
import org.prorefactor.refactor.settings.ProparseSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressLexer
implements TokenSource,
IPreprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressLexer.class);
    private static final Pattern regexNumberedArg = Pattern.compile("\\{\\d+\\}");
    private static final Pattern regexEmptyCurlies = Pattern.compile("\\{\\s*\\}");
    private static final int EOF_CHAR = -1;
    private static final int SKIP_CHAR = -100;
    public static final int PROPARSE_DIRECTIVE = -101;
    public static final int INCLUDE_DIRECTIVE = -102;
    private final IProparseSettings ppSettings;
    private final boolean lexOnly;
    private final IntegerIndex<String> filenameList;
    private int consuming = 0;
    private int currChar;
    private int currFile;
    private int currSourceNum;
    private int currLine;
    private int currCol;
    private boolean currMacroExpansion;
    private boolean doingComment;
    private boolean escapeAppend;
    private boolean escapeCurrent;
    private boolean wasEscape;
    private String escapeText;
    private boolean nameDot;
    private String proparseDirectiveText;
    private String includeDirectiveText;
    private FilePos textStart;
    private IPreprocessorEventListener lstListener;
    private IncludeFile currentInclude;
    private InputSource currentInput;
    private Map<String, String> globalDefdNames = new HashMap<String, String>();
    private boolean gotLookahead = false;
    private LinkedList<IncludeFile> includeVector = new LinkedList();
    private int laFile;
    private int laLine;
    private int laCol;
    private int laSourceNum;
    private int laChar;
    private int safetyNet = 0;
    private int sequence = 0;
    private int sourceCounter = -1;
    private Lexer lexer;
    private final RefactorSession session;
    private TokenSource wrapper;

    public ProgressLexer(RefactorSession session, InputStream input, String fileName, boolean lexOnly) {
        LOGGER.trace("New ProgressLexer instance {}", (Object)fileName);
        this.filenameList = new IntegerIndex();
        this.ppSettings = session.getProparseSettings();
        this.session = session;
        this.lexOnly = lexOnly;
        try {
            this.currentInput = new InputSource(++this.sourceCounter, fileName, input, session.getCharset(), this.currFile, true);
        }
        catch (IOException caught) {
            throw new UncheckedIOException(caught);
        }
        this.currFile = this.addFilename(fileName);
        this.currentInclude = new IncludeFile(fileName, this.currentInput);
        this.includeVector.add(this.currentInclude);
        this.currSourceNum = this.currentInput.getSourceNum();
        this.lstListener = new PreprocessorEventListener();
        this.lexer = new Lexer(this);
        Object postlexer = lexOnly ? new NoOpPostLexer(this.lexer) : new PostLexer(this.lexer);
        TokenList filter1 = new TokenList((TokenSource)postlexer);
        MultiChannelTokenSource filter2 = new MultiChannelTokenSource(filter1);
        this.wrapper = new FunctionKeywordTokenFilter(filter2);
    }

    public void setMergeNameDotInId(boolean merge) {
        this.lexer.setMergeNameDotInId(merge);
    }

    public String getMainFileName() {
        return this.filenameList.getValue(0);
    }

    public IntegerIndex<String> getFilenameList() {
        return this.filenameList;
    }

    public String getFilename(int fileIndex) {
        return this.filenameList.getValue(fileIndex);
    }

    protected int addFilename(String filename) {
        return this.filenameList.add(filename);
    }

    public org.antlr.v4.runtime.Token nextToken() {
        return this.wrapper.nextToken();
    }

    public int getLine() {
        return this.wrapper.getLine();
    }

    public int getCharPositionInLine() {
        return this.wrapper.getCharPositionInLine();
    }

    public CharStream getInputStream() {
        return this.wrapper.getInputStream();
    }

    public String getSourceName() {
        return this.wrapper.getSourceName();
    }

    public void setTokenFactory(TokenFactory<?> factory) {
        this.wrapper.setTokenFactory(factory);
    }

    public TokenFactory<?> getTokenFactory() {
        return this.wrapper.getTokenFactory();
    }

    @Override
    public String defined(String argName) {
        if (this.currentInclude.isNameDefined(argName)) {
            return "3";
        }
        if (this.currentInclude.getNamedArg(argName) != null) {
            return "2";
        }
        for (IncludeFile incl : this.includeVector) {
            if (!incl.isNameDefined(argName)) continue;
            return "3";
        }
        if (this.globalDefdNames.containsKey(argName)) {
            return "1";
        }
        return "0";
    }

    @Override
    public void defGlobal(String argName, String argVal) {
        LOGGER.trace("Global define '{}': '{}'", (Object)argName, (Object)argVal);
        this.globalDefdNames.put(argName, argVal);
    }

    @Override
    public void defScoped(String argName, String argVal) {
        LOGGER.trace("Scoped define '{}': '{}'", (Object)argName, (Object)argVal);
        this.currentInclude.scopeDefine(argName, argVal);
    }

    @Override
    public String getArgText(int argNum) {
        return this.currentInclude.getNumberedArgument(argNum);
    }

    @Override
    public String getArgText(String argName) {
        LOGGER.trace("getArgText('{}')", (Object)argName);
        String ret = this.currentInclude.getValue(argName);
        if (ret != null) {
            LOGGER.trace("Found scope-defined variable: '{}'", (Object)ret);
            return ret;
        }
        ret = this.currentInclude.getNamedArg(argName);
        if (ret != null) {
            LOGGER.trace("Found named argument: '{}'", (Object)ret);
            return ret;
        }
        for (int i = this.includeVector.size() - 1; i >= 0; --i) {
            ret = this.includeVector.get(i).getValue(argName);
            if (ret == null) continue;
            LOGGER.trace("Found non-local scope-defined variable: '{}'", (Object)ret);
            return ret;
        }
        ret = this.globalDefdNames.get(argName);
        if (ret != null) {
            LOGGER.trace("Found global-defined variable: '{}'", (Object)ret);
            return ret;
        }
        if ("*".equals(argName)) {
            LOGGER.trace("Return all include arugments");
            return this.currentInclude.getAllArguments();
        }
        if ("&*".equals(argName)) {
            LOGGER.trace("Return all named include arugments");
            return this.currentInclude.getAllNamedArgs();
        }
        if ("batch-mode".equals(argName)) {
            return Boolean.toString(this.ppSettings.getBatchMode());
        }
        if ("opsys".equals(argName)) {
            return this.ppSettings.getOpSys().getName();
        }
        if ("process-architecture".equals(argName)) {
            return this.ppSettings.getProcessArchitecture();
        }
        if ("window-system".equals(argName)) {
            return this.ppSettings.getWindowSystem();
        }
        if ("file-name".equals(argName)) {
            ret = this.session.findFile(this.currentInclude.getNumberedArgument(0));
            ret = this.ppSettings.getOpSys() == ProparseSettings.OperatingSystem.UNIX ? ret.replace('\\', '/') : ret.replace('/', '\\');
            return ret;
        }
        if ("line-number".equals(argName)) {
            return Integer.toString(this.getLine2());
        }
        if ("sequence".equals(argName)) {
            return Integer.toString(this.sequence++);
        }
        LOGGER.trace("Nothing found...");
        return "";
    }

    @Override
    public void undef(String argName) {
        if (this.currentInclude.isNameDefined(argName)) {
            this.currentInclude.removeVariable(argName);
            return;
        }
        if (this.currentInclude.undefNamedArg(argName)) {
            return;
        }
        ListIterator<IncludeFile> it = this.includeVector.listIterator(this.includeVector.size());
        while (it.hasPrevious()) {
            IncludeFile incfile = it.previous();
            if (!incfile.isNameDefined(argName)) continue;
            incfile.removeVariable(argName);
            return;
        }
        this.undefHelper(argName, this.globalDefdNames);
    }

    @Override
    public void analyzeSuspend(@Nonnull String analyzeSuspend) {
        this.currentInput.setAnalyzeSuspend(analyzeSuspend);
    }

    @Override
    public void analyzeResume() {
        this.currentInput.setAnalyzeSuspend("");
    }

    private boolean undefHelper(String argName, Map<String, String> names) {
        if (names.containsKey(argName)) {
            names.remove(argName);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getChar() {
        this.wasEscape = false;
        block5: while (true) {
            this.escapeCurrent = false;
            if (this.gotLookahead) {
                this.laUse();
            } else {
                this.getRawChar();
            }
            switch (this.currChar) {
                case 92: 
                case 126: {
                    if (this.currChar == 92 && this.ppSettings.getOpSys() == ProparseSettings.OperatingSystem.WINDOWS && !this.ppSettings.useBackslashAsEscape()) {
                        return this.currChar;
                    }
                    int retChar = this.escape();
                    if (retChar == 46) {
                        this.checkForNameDot();
                    }
                    if (retChar == -100) continue block5;
                    return retChar;
                }
                case 123: {
                    if (this.doingComment) {
                        return this.currChar;
                    }
                    this.macroReference();
                    if (this.currChar == -101 || this.currChar == -102) return this.currChar;
                    continue block5;
                }
                case 46: {
                    this.checkForNameDot();
                    return this.currChar;
                }
            }
            break;
        }
        return this.currChar;
    }

    boolean isLexOnly() {
        return this.lexOnly;
    }

    int getColumn() {
        return this.currCol;
    }

    boolean getMacroExpansion() {
        return this.currMacroExpansion;
    }

    int getFileIndex() {
        return this.currFile;
    }

    int getLine2() {
        return this.currLine;
    }

    int getSourceNum() {
        return this.currSourceNum;
    }

    private int escape() {
        if (this.wasEscape) {
            this.escapeText = this.escapeText + (char)this.currChar;
        } else {
            this.wasEscape = true;
            this.escapeText = Character.toString((char)this.currChar);
            this.escapeAppend = true;
        }
        this.getRawChar();
        int retChar = this.currChar;
        this.escapeCurrent = true;
        switch (this.currChar) {
            case 10: {
                this.escapeText = this.escapeText + (char)this.currChar;
                retChar = -100;
                break;
            }
            case 13: {
                if (!this.gotLookahead) {
                    this.laGet();
                }
                if (this.laChar == 10) {
                    this.escapeText = this.escapeText + "\r\n";
                    this.laUse();
                    retChar = -100;
                    break;
                }
                retChar = 13;
                break;
            }
            case 114: {
                this.escapeText = this.escapeText + (char)this.currChar;
                this.escapeAppend = false;
                retChar = 13;
                break;
            }
            case 110: {
                this.escapeText = this.escapeText + (char)this.currChar;
                this.escapeAppend = false;
                retChar = 10;
                break;
            }
            default: {
                this.escapeAppend = true;
            }
        }
        return retChar;
    }

    private String getFilename() {
        return this.getFilename(this.currentInput.getFileIndex());
    }

    @CheckForNull
    String getCurrentAnalyzeSuspend() {
        return this.currentInput.getAnalyzeSuspend();
    }

    private void getRawChar() {
        this.currLine = this.currentInput.getNextLine();
        this.currCol = this.currentInput.getNextCol();
        this.currChar = this.currentInput.get();
        this.currMacroExpansion = this.currentInput.isMacroExpansion();
        if (this.currChar == 65533) {
            LOGGER.error("Character conversion error in {} at line {} column {} from encoding {}", new Object[]{this.getFilename(), this.currLine, this.currCol, this.session.getCharset().name()});
            this.currChar = 32;
        }
        block5: while (this.currChar == -1) {
            switch (this.popInput()) {
                case 0: {
                    ++this.safetyNet;
                    if (this.safetyNet > 100) {
                        throw new ProparseRuntimeException("Proparse error. Infinite loop caught by preprocessor.");
                    }
                    return;
                }
                case 1: {
                    this.currFile = this.currentInput.getFileIndex();
                    this.currLine = this.currentInput.getNextLine();
                    this.currCol = this.currentInput.getNextCol();
                    this.currSourceNum = this.currentInput.getSourceNum();
                    this.currMacroExpansion = this.currentInput.isMacroExpansion();
                    this.currChar = 32;
                    return;
                }
                case 2: {
                    this.currFile = this.currentInput.getFileIndex();
                    this.currLine = this.currentInput.getNextLine();
                    this.currCol = this.currentInput.getNextCol();
                    this.currChar = this.currentInput.get();
                    this.currSourceNum = this.currentInput.getSourceNum();
                    this.currMacroExpansion = this.currentInput.isMacroExpansion();
                    continue block5;
                }
            }
            throw new IllegalStateException("Proparse error. popInput() returned unexpected value.");
        }
    }

    private String includeRefArg(CharPos cp) {
        boolean gobbleWS = false;
        StringBuilder theRet = new StringBuilder();
        block4: while (cp.pos < cp.chars.length - 1) {
            char c = cp.chars[cp.pos];
            switch (c) {
                case '\"': {
                    if (cp.chars[cp.pos + 1] == '\"') {
                        theRet.append('\"');
                        ++cp.pos;
                        ++cp.pos;
                        continue block4;
                    }
                    gobbleWS = !gobbleWS;
                    ++cp.pos;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (gobbleWS) {
                        theRet.append(c);
                        ++cp.pos;
                        continue block4;
                    }
                    return theRet.toString();
                }
            }
            theRet.append(c);
            ++cp.pos;
        }
        return theRet.toString();
    }

    private void laGet() {
        int saveFile = this.currFile;
        int saveLine = this.currLine;
        int saveCol = this.currCol;
        int saveSourceNum = this.currSourceNum;
        int saveChar = this.currChar;
        this.getRawChar();
        this.gotLookahead = true;
        this.laFile = this.currFile;
        this.laLine = this.currLine;
        this.laCol = this.currCol;
        this.laChar = this.currChar;
        this.laSourceNum = this.currSourceNum;
        this.currFile = saveFile;
        this.currLine = saveLine;
        this.currCol = saveCol;
        this.currSourceNum = saveSourceNum;
        this.currChar = saveChar;
    }

    private void laUse() {
        this.gotLookahead = false;
        this.currFile = this.laFile;
        this.currLine = this.laLine;
        this.currCol = this.laCol;
        this.currSourceNum = this.laSourceNum;
        this.currChar = this.laChar;
    }

    void lexicalThrow(String theMessage) {
        throw new ProparseRuntimeException(this.getFilename() + ":" + Integer.toString(this.getLine2()) + " " + theMessage);
    }

    private void macroReference() {
        ArrayList<IncludeArg> incArgs = new ArrayList<IncludeArg>();
        this.textStart = new FilePos(this.currFile, this.currLine, this.currCol, this.currSourceNum);
        FilePos refPos = new FilePos(this.textStart.file, this.textStart.line, this.textStart.col, this.textStart.sourceNum);
        StringBuilder refTextBldr = new StringBuilder("{");
        char macroChar = (char)this.getChar();
        while ((macroChar != '}' || this.wasEscape) && macroChar != '\uffffffff') {
            refTextBldr.append(macroChar);
            macroChar = (char)this.getChar();
        }
        if (macroChar == '\uffffffff') {
            this.lexicalThrow("Unmatched curly brace");
        }
        refTextBldr.append(macroChar);
        String refText = refTextBldr.toString();
        CharPos cp = new CharPos(refText.toCharArray(), 0);
        int refTextEnd = refText.length();
        int closingCurly = refTextEnd - 1;
        if (refText.toLowerCase().startsWith("{&_proparse_") && this.ppSettings.getProparseDirectives()) {
            this.currChar = -101;
            this.proparseDirectiveText = refText.substring(12, closingCurly).trim();
            ++this.sourceCounter;
            this.lstListener.macroRef(refPos.line, refPos.col, "_proparse");
            return;
        }
        if ("{*}".equals(refText)) {
            this.newMacroRef("*", refPos);
            return;
        }
        if (refText.startsWith("{&*")) {
            this.newMacroRef("&*", refPos);
            return;
        }
        if (regexNumberedArg.matcher(refText).matches()) {
            String theText = refText.substring(1, closingCurly);
            int argNum = Integer.parseInt(theText);
            this.newMacroRef(argNum, refPos);
            return;
        }
        if (regexEmptyCurlies.matcher(refText).matches()) {
            return;
        }
        if (refText.startsWith("{&")) {
            String argName = refText.substring(2, closingCurly).trim().toLowerCase();
            this.newMacroRef(argName, refPos);
            return;
        }
        boolean usingNamed = false;
        cp.pos = 1;
        while (Character.isWhitespace(cp.chars[cp.pos])) {
            ++cp.pos;
        }
        String includeFilename = this.includeRefArg(cp);
        while (Character.isWhitespace(cp.chars[cp.pos])) {
            ++cp.pos;
        }
        if (cp.pos != closingCurly) {
            if (cp.chars[cp.pos] == '&') {
                usingNamed = true;
                while (cp.pos != refTextEnd && cp.chars[cp.pos] == '&') {
                    ++cp.pos;
                    String argName = "";
                    while (cp.pos != refTextEnd && cp.pos != closingCurly && cp.chars[cp.pos] != '=') {
                        if (!Character.isWhitespace(cp.chars[cp.pos])) {
                            argName = argName + cp.chars[cp.pos];
                        }
                        ++cp.pos;
                    }
                    String argVal = "";
                    if (cp.chars[cp.pos] == '=') {
                        ++cp.pos;
                        while (cp.pos != closingCurly && Character.isWhitespace(cp.chars[cp.pos])) {
                            ++cp.pos;
                        }
                        if (cp.pos != closingCurly) {
                            argVal = this.includeRefArg(cp);
                        }
                    }
                    incArgs.add(new IncludeArg(argName, argVal));
                    while (cp.pos != refTextEnd && cp.chars[cp.pos] != '&') {
                        ++cp.pos;
                    }
                }
            } else {
                usingNamed = false;
                while (cp.pos != refTextEnd) {
                    while (Character.isWhitespace(cp.chars[cp.pos])) {
                        ++cp.pos;
                    }
                    if (cp.pos != closingCurly) {
                        incArgs.add(new IncludeArg("", this.includeRefArg(cp)));
                        continue;
                    }
                    break;
                }
            }
        }
        if (this.lexOnly) {
            this.currChar = -102;
            this.includeDirectiveText = refText.trim();
            return;
        }
        if (this.newInclude(includeFilename)) {
            this.currFile = this.currentInput.getFileIndex();
            this.currSourceNum = this.currentInput.getSourceNum();
            this.lstListener.include(refPos.line, refPos.col, this.currFile, includeFilename);
            int argNum = 1;
            for (IncludeArg incarg : incArgs) {
                if (usingNamed) {
                    this.currentInclude.addNamedArgument(incarg.argName, incarg.argVal);
                } else {
                    this.currentInclude.addArgument(incarg.argVal);
                }
                this.lstListener.includeArgument(usingNamed ? incarg.argName : Integer.toString(argNum), incarg.argVal);
                ++argNum;
            }
        }
    }

    private boolean newInclude(String referencedWithName) {
        String fName = referencedWithName.trim();
        if (this.isConsuming() || this.isLexOnly() || fName.length() == 0) {
            return false;
        }
        File ff = this.session.findFile3(fName);
        if (ff == null) {
            throw new UncheckedIOException(new IncludeFileNotFoundException(this.getFilename(), referencedWithName));
        }
        try {
            this.currentInput = new InputSource(++this.sourceCounter, ff, this.session.getCharset(), this.addFilename(fName));
        }
        catch (IOException caught) {
            throw new UncheckedIOException(caught);
        }
        this.currentInclude = new IncludeFile(referencedWithName, this.currentInput);
        this.includeVector.add(this.currentInclude);
        LOGGER.trace("Entering file: {}", (Object)this.getFilename());
        return true;
    }

    private void newMacroRef(String macroName, FilePos refPos) {
        this.lstListener.macroRef(refPos.line, refPos.col, macroName);
        this.newMacroRef2(this.getArgText(macroName), refPos);
    }

    private void newMacroRef(int argNum, FilePos refPos) {
        this.lstListener.macroRef(refPos.line, refPos.col, Integer.toString(argNum));
        this.newMacroRef2(this.getArgText(argNum), refPos);
    }

    private void newMacroRef2(String theText, FilePos refPos) {
        if (theText.length() == 0) {
            ++this.sourceCounter;
            this.lstListener.macroRefEnd();
            return;
        }
        this.currentInput = new InputSource(++this.sourceCounter, theText, refPos.file, refPos.line, refPos.col);
        this.currentInclude.addInputSource(this.currentInput);
        this.currentInput.setNextLine(refPos.line);
        this.currentInput.setNextCol(refPos.col);
    }

    public void parseComplete() {
        while (this.popInput() != 0) {
        }
    }

    private int popInput() {
        InputSource tmp = this.currentInclude.pop();
        if (tmp != null) {
            this.currentInput = tmp;
            this.lstListener.macroRefEnd();
            return 2;
        }
        if (this.includeVector.size() > 1) {
            this.includeVector.removeLast();
            this.currentInclude = this.includeVector.getLast();
            this.currentInput = this.currentInclude.getLastSource();
            this.lstListener.includeEnd();
            LOGGER.trace("Back to file: {}", (Object)this.getFilename());
            return 1;
        }
        return 0;
    }

    private void checkForNameDot() {
        if (!this.gotLookahead) {
            this.laGet();
        }
        this.nameDot = this.laChar != -1 && !Character.isWhitespace(this.laChar);
    }

    public void setDoingComment(boolean doingComment) {
        this.doingComment = doingComment;
    }

    public boolean isEscapeAppend() {
        return this.escapeAppend;
    }

    public boolean isEscapeCurrent() {
        return this.escapeCurrent;
    }

    public String getEscapeText() {
        return this.escapeText;
    }

    public boolean wasEscape() {
        return this.wasEscape;
    }

    public boolean isNameDot() {
        return this.nameDot;
    }

    public String getProparseDirectiveText() {
        return this.proparseDirectiveText;
    }

    public String getIncludeDirectiveText() {
        return this.includeDirectiveText;
    }

    public boolean isConsuming() {
        return this.consuming != 0;
    }

    public int getConsuming() {
        return this.consuming;
    }

    public void incrementConsuming() {
        ++this.consuming;
    }

    public void decrementConsuming() {
        --this.consuming;
    }

    public FilePos getTextStart() {
        return this.textStart;
    }

    public IPreprocessorEventListener getLstListener() {
        return this.lstListener;
    }

    public JPNodeMetrics getMetrics() {
        return new JPNodeMetrics(this.lexer.getLoc(), this.lexer.getCommentedLines());
    }

    public IncludeRef getMacroGraph() {
        return ((PreprocessorEventListener)this.lstListener).getMacroGraph();
    }

    public IProparseSettings getProparseSettings() {
        return this.ppSettings;
    }

    public boolean isAppBuilderCode() {
        return ((PreprocessorEventListener)this.lstListener).isAppBuilderCode();
    }

    public TokenStream getANTLR2TokenStream(boolean hideNonDefaultChannel) {
        ANTRL2TokenStreamWrapper stream = new ANTRL2TokenStreamWrapper();
        if (hideNonDefaultChannel) {
            TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)stream);
            filter.hide(ABLNodeType.WS.getType());
            filter.hide(ABLNodeType.COMMENT.getType());
            filter.hide(ABLNodeType.AMPMESSAGE.getType());
            filter.hide(ABLNodeType.AMPANALYZESUSPEND.getType());
            filter.hide(ABLNodeType.AMPANALYZERESUME.getType());
            filter.hide(ABLNodeType.AMPGLOBALDEFINE.getType());
            filter.hide(ABLNodeType.AMPSCOPEDDEFINE.getType());
            filter.hide(ABLNodeType.AMPUNDEFINE.getType());
            filter.hide(ABLNodeType.PROPARSEDIRECTIVE.getType());
            stream = filter;
        }
        return stream;
    }

    private class ANTRL2TokenStreamWrapper
    implements TokenStream {
        private ANTRL2TokenStreamWrapper() {
        }

        public Token nextToken() {
            return this.convertToken((ProToken)ProgressLexer.this.wrapper.nextToken());
        }

        private Token convertToken(ProToken tok) {
            return new org.prorefactor.core.ProToken(tok.getNodeType() == ABLNodeType.EOF_ANTLR4 ? ABLNodeType.EOF : tok.getNodeType(), tok.getText(), tok.getFileIndex(), Strings.nullToEmpty((String)((String)ProgressLexer.this.filenameList.getValue(tok.getFileIndex()))), tok.getLine(), tok.getCharPositionInLine(), tok.getEndFileIndex(), tok.getEndLine(), tok.getEndCharPositionInLine(), tok.getMacroSourceNum(), tok.getAnalyzeSuspend(), false, tok.isMacroExpansion());
        }
    }

    private static class IncludeArg {
        private final String argName;
        private final String argVal;

        IncludeArg(String argName, String argVal) {
            this.argName = argName;
            this.argVal = argVal;
        }
    }

    public static class FilePos {
        private final int file;
        private final int line;
        private final int col;
        private final int sourceNum;

        public FilePos(int file, int line, int col, int sourceNum) {
            this.file = file;
            this.line = line;
            this.col = col;
            this.sourceNum = sourceNum;
        }

        public int getFile() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }

        public int getCol() {
            return this.col;
        }

        public int getSourceNum() {
            return this.sourceNum;
        }

        public int hashCode() {
            return 13 * this.file + 17 * this.line + 31 * this.col + 37 * this.sourceNum;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FilePos fp = (FilePos)obj;
                return fp.file == this.file && fp.line == this.line && fp.col == this.col && fp.sourceNum == this.sourceNum;
            }
            return false;
        }
    }

    private static class CharPos {
        private final char[] chars;
        private int pos;

        CharPos(char[] c, int p) {
            this.chars = c;
            this.pos = p;
        }
    }
}

