/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import java.util.HashSet;

public class StringFuncs {
    private StringFuncs() {
    }

    public static String escapeLineBreaks(String s) {
        String ret = s.replace("\\", "\\\\");
        ret = ret.replace("\n", "\\n");
        ret = ret.replace("\r", "\\r");
        return ret;
    }

    public static String ltrim(String s) {
        int begin;
        char[] c = s.toCharArray();
        int end = c.length;
        for (begin = 0; begin < end && Character.isWhitespace(c[begin]); ++begin) {
        }
        return s.substring(begin);
    }

    public static String ltrim(String s, String t) {
        int begin;
        HashSet<Character> trimSet = StringFuncs.setOfMatchChars(t);
        char[] c = s.toCharArray();
        int end = c.length;
        for (begin = 0; begin < end && trimSet.contains(Character.valueOf(c[begin])); ++begin) {
        }
        return s.substring(begin);
    }

    public static String qstringStrip(String s) {
        if (s.length() < 2) {
            return s;
        }
        char quoteType = s.charAt(0);
        if (quoteType != '\"' && quoteType != '\'') {
            return s;
        }
        int endQuotePos = s.lastIndexOf(quoteType);
        if (endQuotePos < 1) {
            return s;
        }
        return s.substring(1, endQuotePos);
    }

    static HashSet<Character> setOfMatchChars(String s) {
        HashSet<Character> set = new HashSet<Character>();
        for (char c : s.toLowerCase().toCharArray()) {
            set.add(Character.valueOf(c));
        }
        for (char c : s.toUpperCase().toCharArray()) {
            set.add(Character.valueOf(c));
        }
        return set;
    }

    public static String stripComments(String orig) {
        StringBuilder bldr = new StringBuilder();
        int it = 0;
        int commentLevel = 0;
        char[] c = orig.toCharArray();
        int end = c.length;
        char curr = '\u0000';
        while (it < end) {
            char next;
            char prev = curr;
            curr = c[it];
            char c2 = next = ++it < end ? c[it] : (char)'\u0000';
            if (commentLevel > 0 && curr == '/' && prev == '*') {
                --commentLevel;
                continue;
            }
            if (curr == '/' && next == '*') {
                ++commentLevel;
                continue;
            }
            if (commentLevel != 0) continue;
            bldr.append(curr);
        }
        return bldr.toString();
    }

    public static String rtrim(String s) {
        int end;
        char[] c = s.toCharArray();
        for (end = c.length; end > 0 && Character.isWhitespace(c[end - 1]); --end) {
        }
        return s.substring(0, end);
    }

    public static String rtrim(String s, String t) {
        int end;
        HashSet<Character> trimSet = StringFuncs.setOfMatchChars(t);
        char[] c = s.toCharArray();
        for (end = c.length; end > 0 && trimSet.contains(Character.valueOf(c[end - 1])); --end) {
        }
        return s.substring(0, end);
    }

    public static String trim(String s, String t) {
        int begin;
        HashSet<Character> trimSet = StringFuncs.setOfMatchChars(t);
        char[] c = s.toCharArray();
        int end = c.length;
        for (begin = 0; begin < end && trimSet.contains(Character.valueOf(c[begin])); ++begin) {
        }
        while (end >= begin && trimSet.contains(Character.valueOf(c[end - 1]))) {
            --end;
        }
        return s.substring(begin, end);
    }
}

