/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.proparse.antlr4;

import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.proparse.antlr4.ProToken;

public class TokenList
implements TokenSource {
    private final TokenSource source;
    private final Deque<ProToken> queue = new LinkedList<ProToken>();
    private int currentPosition;
    private ProToken currentToken;

    public TokenList(TokenSource input) {
        this.source = input;
    }

    private void fillHeap() {
        ProToken nxt = (ProToken)this.source.nextToken();
        while (true) {
            this.queue.offer(nxt);
            if (nxt.getNodeType() == ABLNodeType.OBJCOLON) {
                this.reviewObjcolon();
            }
            if (nxt.getNodeType() == ABLNodeType.OBJCOLON || nxt.getNodeType() == ABLNodeType.EOF_ANTLR4) break;
            nxt = (ProToken)this.source.nextToken();
        }
    }

    private void reviewObjcolon() {
        ProToken objColonToken = this.queue.removeLast();
        LinkedList<ProToken> comments = new LinkedList<ProToken>();
        LinkedList<ProToken> clsName = new LinkedList<ProToken>();
        boolean foundNamedot = false;
        ProToken tok = null;
        try {
            tok = this.queue.removeLast();
            while (tok.getNodeType() == ABLNodeType.WS || tok.getNodeType() == ABLNodeType.COMMENT) {
                comments.addFirst(tok);
                tok = this.queue.removeLast();
            }
            foundNamedot = false;
            while (tok.getNodeType() != ABLNodeType.WS && tok.getNodeType() != ABLNodeType.COMMENT) {
                if (this.queue.peekLast() != null && this.queue.peekLast().getNodeType() == ABLNodeType.NAMEDOT) {
                    clsName.addFirst(tok);
                    clsName.addFirst(this.queue.removeLast());
                    tok = this.queue.removeLast();
                } else {
                    if (!tok.getText().startsWith(".")) break;
                    clsName.addFirst(tok);
                    tok = this.queue.removeLast();
                }
                foundNamedot = true;
            }
        }
        catch (NoSuchElementException caught) {
            this.queue.addAll(clsName);
            this.queue.addAll(comments);
            this.queue.add(objColonToken);
            return;
        }
        if (foundNamedot) {
            StringBuilder text = new StringBuilder(tok.getText());
            tok.setType(913);
            for (ProToken zz : clsName) {
                text.append(zz.getText());
                tok.setEndFileIndex(zz.getEndFileIndex());
                tok.setEndLine(zz.getEndLine());
                tok.setEndCharPositionInLine(zz.getEndCharPositionInLine());
            }
            tok.setText(text.toString());
            this.queue.addLast(tok);
            this.queue.addAll(comments);
        } else {
            if (tok.getNodeType().isReservedKeyword() && !tok.getNodeType().isSystemHandleName()) {
                tok.setNodeType(ABLNodeType.ID);
            }
            this.queue.addLast(tok);
            this.queue.addAll(comments);
        }
        this.queue.add(objColonToken);
    }

    public Token nextToken() {
        ProToken tok;
        if (this.currentToken != null && this.currentToken.getType() == -1) {
            return this.currentToken;
        }
        if (this.queue.isEmpty()) {
            this.fillHeap();
        }
        if ((tok = this.queue.poll()) != null) {
            this.currentToken = tok;
            this.currentToken.setTokenIndex(this.currentPosition++);
        }
        return this.currentToken;
    }

    public int getLine() {
        return this.currentToken.getLine();
    }

    public int getCharPositionInLine() {
        return this.currentToken.getCharPositionInLine();
    }

    public CharStream getInputStream() {
        return this.currentToken.getInputStream();
    }

    public String getSourceName() {
        return "<unknown>";
    }

    public void setTokenFactory(TokenFactory<?> factory) {
        throw new UnsupportedOperationException("Unable to change TokenFactory object");
    }

    public TokenFactory<?> getTokenFactory() {
        return this.source.getTokenFactory();
    }
}

