/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.refactor;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import eu.rssw.pct.TypeInfo;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.prorefactor.core.schema.ISchema;
import org.prorefactor.refactor.settings.IProparseSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefactorSession {
    private static final Logger LOG = LoggerFactory.getLogger(RefactorSession.class);
    private final IProparseSettings proparseSettings;
    private final ISchema schema;
    private final Charset charset;
    private final Map<String, TypeInfo> typeInfoMap = new HashMap<String, TypeInfo>();

    @Inject
    public RefactorSession(IProparseSettings proparseSettings, ISchema schema) {
        this(proparseSettings, schema, Charset.defaultCharset());
    }

    public RefactorSession(IProparseSettings proparseSettings, ISchema schema, Charset charset) {
        this.proparseSettings = proparseSettings;
        this.schema = schema;
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public ISchema getSchema() {
        return this.schema;
    }

    public IProparseSettings getProparseSettings() {
        return this.proparseSettings;
    }

    @Nullable
    public TypeInfo getTypeInfo(String clz) {
        if (clz == null) {
            return null;
        }
        TypeInfo info = this.typeInfoMap.get(clz);
        if (info == null) {
            LOG.debug("No TypeInfo found for {}", (Object)clz);
        }
        return info;
    }

    public void injectTypeInfoCollection(Collection<TypeInfo> units) {
        for (TypeInfo info : units) {
            this.injectTypeInfo(info);
        }
    }

    public void injectTypeInfo(TypeInfo unit) {
        if (unit == null || Strings.isNullOrEmpty((String)unit.getTypeName())) {
            return;
        }
        this.typeInfoMap.put(unit.getTypeName(), unit);
    }

    public File findFile3(String fileName) {
        int len = fileName.length();
        if ((len > 0 && (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') || len > 1 && fileName.charAt(1) == ':' || len > 1 && fileName.charAt(0) == '.') && new File(fileName).exists()) {
            return new File(fileName);
        }
        for (String p : this.proparseSettings.getPropathAsList()) {
            String tryPath = p + File.separatorChar + fileName;
            if (!new File(tryPath).exists()) continue;
            return new File(tryPath);
        }
        return null;
    }

    public String findFile(String fileName) {
        int len = fileName.length();
        if ((len > 0 && (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') || len > 1 && fileName.charAt(1) == ':' || len > 1 && fileName.charAt(0) == '.') && new File(fileName).exists()) {
            return fileName;
        }
        for (String p : this.proparseSettings.getPropathAsList()) {
            String tryPath = p + File.separatorChar + fileName;
            if (!new File(tryPath).exists()) continue;
            return tryPath;
        }
        return "";
    }

    public File findFile2(String filename) {
        String[] parts;
        File inFile = new File(filename);
        char c = filename.charAt(0);
        if (inFile.isAbsolute() || c == '.' || c == '/' || c == '\\') {
            if (inFile.exists()) {
                return inFile;
            }
            return null;
        }
        String propath = this.proparseSettings.getPropath();
        for (String part : parts = propath.split(",")) {
            File retFile = new File(part + File.separator + filename);
            if (!retFile.exists()) continue;
            return retFile;
        }
        return null;
    }

    public File findFileForClassName(String className) {
        return this.findFile2(className.replace('.', '/') + ".cls");
    }
}

