/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.refactor.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.prorefactor.refactor.settings.IProparseSettings;

public class ProparseSettings
implements IProparseSettings {
    private final boolean multiParse;
    private final boolean proparseDirectives;
    private final boolean backslashEscape;
    private final OperatingSystem os;
    private final String processArchitecture;
    private final boolean batchMode;
    private final String propath;
    private final String proversion;
    private final List<String> path = new ArrayList<String>();
    private String customWindowSystem;
    private OperatingSystem customOpsys;
    private String customProcessArchitecture;
    private Boolean customBatchMode;
    private String customProversion;

    public ProparseSettings(String propath) {
        this(propath, false);
    }

    public ProparseSettings(String propath, boolean backslashAsEscape) {
        this(true, true, backslashAsEscape, true, OperatingSystem.getOS(), propath, "11.7", "64");
    }

    public ProparseSettings(boolean proparseDirectives, boolean multiParse, boolean backslashEscape, boolean batchMode, OperatingSystem os, String propath, String proversion, String processArchitecture) {
        this.multiParse = multiParse;
        this.proparseDirectives = proparseDirectives;
        this.backslashEscape = backslashEscape;
        this.batchMode = batchMode;
        this.os = os;
        this.propath = propath;
        this.proversion = proversion;
        this.processArchitecture = processArchitecture;
        this.path.addAll(Arrays.asList(propath.split(",")));
    }

    @Override
    public boolean isMultiParse() {
        return this.multiParse;
    }

    @Override
    public boolean getProparseDirectives() {
        return this.proparseDirectives;
    }

    @Override
    public boolean useBackslashAsEscape() {
        return this.backslashEscape;
    }

    @Override
    public boolean getBatchMode() {
        return this.customBatchMode == null ? this.batchMode : this.customBatchMode;
    }

    @Override
    public OperatingSystem getOpSys() {
        return this.customOpsys == null ? this.os : this.customOpsys;
    }

    @Override
    public String getWindowSystem() {
        return this.customWindowSystem == null ? this.os.getWindowSystem() : this.customWindowSystem;
    }

    @Override
    public String getPropath() {
        return this.propath;
    }

    @Override
    public List<String> getPropathAsList() {
        return this.path;
    }

    @Override
    public String getProversion() {
        return this.customProversion == null ? this.proversion : this.customProversion;
    }

    @Override
    public String getProcessArchitecture() {
        return this.customProcessArchitecture == null ? this.processArchitecture : this.customProcessArchitecture;
    }

    public void setCustomBatchMode(boolean customBatchMode) {
        this.customBatchMode = customBatchMode;
    }

    public void setCustomOpsys(String customOpsys) {
        if (OperatingSystem.UNIX.name().equalsIgnoreCase(customOpsys)) {
            this.customOpsys = OperatingSystem.UNIX;
        } else if (OperatingSystem.WINDOWS.name().equalsIgnoreCase(customOpsys)) {
            this.customOpsys = OperatingSystem.WINDOWS;
        }
    }

    public void setCustomProcessArchitecture(String customProcessArchitecture) {
        this.customProcessArchitecture = customProcessArchitecture;
    }

    public void setCustomWindowSystem(String customWindowSystem) {
        this.customWindowSystem = customWindowSystem;
    }

    public void setCustomProversion(String customProversion) {
        this.customProversion = customProversion;
    }

    public static enum OperatingSystem {
        UNIX,
        WINDOWS;


        public String getName() {
            return this == WINDOWS ? "WIN32" : "UNIX";
        }

        public String getWindowSystem() {
            return this == WINDOWS ? "MS-WIN95" : "TTY";
        }

        public int getNumber() {
            return this == WINDOWS ? 1 : 2;
        }

        public static OperatingSystem getOS() {
            return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 ? WINDOWS : UNIX;
        }
    }
}

