/*
 * Decompiled with CFR 0.152.
 */
package org.prorefactor.treeparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.prorefactor.core.ABLNodeType;
import org.prorefactor.core.JPNode;
import org.prorefactor.core.nodetypes.RecordNameNode;
import org.prorefactor.core.schema.IField;
import org.prorefactor.treeparser.BufferScope;
import org.prorefactor.treeparser.FieldLookupResult;
import org.prorefactor.treeparser.TreeParserSymbolScope;
import org.prorefactor.treeparser.symbols.Event;
import org.prorefactor.treeparser.symbols.Symbol;
import org.prorefactor.treeparser.symbols.TableBuffer;
import org.prorefactor.treeparser.symbols.widgets.Frame;

public class Block {
    private List<Frame> frames = new ArrayList<Frame>();
    private Block parent;
    private Frame defaultFrame = null;
    private JPNode blockStatementNode;
    private Set<BufferScope> bufferScopes = new HashSet<BufferScope>();
    private TreeParserSymbolScope symbolScope;

    public Block(Block parent, JPNode node) {
        this.blockStatementNode = node;
        this.parent = parent;
        this.symbolScope = parent.symbolScope;
    }

    public Block(TreeParserSymbolScope symbolScope, JPNode node) {
        this.blockStatementNode = node;
        this.symbolScope = symbolScope;
        this.parent = symbolScope.getParentScope() != null ? symbolScope.getParentScope().getRootBlock() : null;
    }

    public void addBufferScopeReferences(BufferScope bufferScope) {
        if (this.blockStatementNode.getNodeType() != ABLNodeType.DO) {
            this.bufferScopes.add(bufferScope);
        }
        if (this.parent != null && bufferScope.getSymbol().getScope().getRootBlock() != this) {
            this.parent.addBufferScopeReferences(bufferScope);
        }
    }

    public Block addFrame(Frame frame) {
        if (this.canScopeFrame()) {
            this.frames.add(frame);
            return this;
        }
        return this.parent.addFrame(frame);
    }

    public void addHiddenCursor(RecordNameNode node) {
        TableBuffer symbol = node.getTableBuffer();
        BufferScope buff = new BufferScope(this, symbol, BufferScope.Strength.HIDDEN_CURSOR);
        this.bufferScopes.add(buff);
        node.setBufferScope(buff);
    }

    public void addStrongBufferScope(RecordNameNode node) {
        TableBuffer symbol = node.getTableBuffer();
        BufferScope buff = new BufferScope(this, symbol, BufferScope.Strength.STRONG);
        this.bufferScopes.add(buff);
        this.addBufferScopeReferences(buff);
        node.setBufferScope(buff);
    }

    public BufferScope addWeakBufferScope(TableBuffer symbol) {
        BufferScope buff = this.getBufferScope(symbol, BufferScope.Strength.WEAK);
        if (buff == null) {
            buff = new BufferScope(this, symbol, BufferScope.Strength.WEAK);
        }
        this.addBufferScopeReferences(buff);
        this.bufferScopes.add(buff);
        return buff;
    }

    private boolean canScopeBufferReference(TableBuffer symbol) {
        switch (this.blockStatementNode.getType()) {
            case 291: 
            case 648: 
            case 979: {
                return true;
            }
        }
        return symbol.getScope().getRootBlock() == this;
    }

    private boolean canScopeFrame() {
        if (this.blockStatementNode.getNodeType() == ABLNodeType.REPEAT || this.blockStatementNode.getNodeType() == ABLNodeType.FOR) {
            return true;
        }
        return this.isRootBlock();
    }

    private BufferScope findBufferScope(TableBuffer symbol) {
        for (BufferScope buff : this.bufferScopes) {
            if (buff.getSymbol() != symbol || buff.getBlock() != this) continue;
            return buff;
        }
        if (this.parent != null && symbol.getScope().getRootBlock() != this) {
            return this.parent.findBufferScope(symbol);
        }
        return null;
    }

    public TableBuffer[] getBlockBuffers() {
        HashSet<TableBuffer> set = new HashSet<TableBuffer>();
        for (BufferScope buff : this.bufferScopes) {
            if (buff.getBlock() != this) continue;
            set.add(buff.getSymbol());
        }
        return set.toArray(new TableBuffer[set.size()]);
    }

    public BufferScope getBufferForReference(TableBuffer symbol) {
        BufferScope buffer = this.getBufferScope(symbol, BufferScope.Strength.REFERENCE);
        if (buffer == null) {
            buffer = this.getBufferForReferenceSub(symbol);
        }
        this.addBufferScopeReferences(buffer);
        return buffer;
    }

    private BufferScope getBufferForReferenceSub(TableBuffer symbol) {
        if (!this.canScopeBufferReference(symbol)) {
            return this.parent.getBufferForReferenceSub(symbol);
        }
        return new BufferScope(this, symbol, BufferScope.Strength.REFERENCE);
    }

    private BufferScope getBufferScope(TableBuffer symbol, BufferScope.Strength creating) {
        BufferScope buff = this.findBufferScope(symbol);
        if (buff != null) {
            return buff;
        }
        return this.getBufferScopeSub(symbol, creating);
    }

    private BufferScope getBufferScopeSub(TableBuffer symbol, BufferScope.Strength creating) {
        BufferScope buff;
        if (this.parent != null && symbol.getScope().getRootBlock() != this && (buff = this.parent.getBufferScopeSub(symbol, creating)) != null) {
            return buff;
        }
        BufferScope raiseBuff = null;
        for (BufferScope buff2 : this.bufferScopes) {
            if (buff2.getSymbol() != symbol) continue;
            if (buff2.isStrong()) {
                return null;
            }
            if (creating != BufferScope.Strength.REFERENCE && buff2.getStrength() != BufferScope.Strength.REFERENCE) continue;
            raiseBuff = buff2;
        }
        if (raiseBuff == null) {
            return null;
        }
        if (!this.canScopeBufferReference(symbol)) {
            return null;
        }
        for (BufferScope buff2 : this.bufferScopes) {
            if (buff2.getSymbol() != symbol) continue;
            buff2.setBlock(this);
            buff2.setStrength(BufferScope.Strength.REFERENCE);
        }
        return raiseBuff;
    }

    public Frame getDefaultFrame() {
        if (this.defaultFrame != null) {
            return this.defaultFrame;
        }
        if (!this.canScopeFrame()) {
            return this.parent.getDefaultFrame();
        }
        return null;
    }

    public List<Frame> getFrames() {
        return new ArrayList<Frame>(this.frames);
    }

    public JPNode getNode() {
        return this.blockStatementNode;
    }

    public Block getParent() {
        return this.parent;
    }

    public TreeParserSymbolScope getSymbolScope() {
        return this.symbolScope;
    }

    public boolean isBufferLocal(BufferScope buff) {
        Block block = this;
        while (block.parent != null) {
            if (buff.getBlock() == block) {
                return true;
            }
            block = block.parent;
        }
        return false;
    }

    public boolean isMethodBlock() {
        return this.symbolScope.getRootBlock() == this && this.symbolScope.getParentScope() != null;
    }

    public boolean isProgramBlock() {
        return this.symbolScope.getRootBlock() == this && this.symbolScope.getParentScope() == null;
    }

    public boolean isRootBlock() {
        return this.symbolScope.getRootBlock() == this;
    }

    public FieldLookupResult lookupField(String name, boolean getBufferScope) {
        FieldLookupResult result = new FieldLookupResult();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            result.variable = this.symbolScope.lookupVariable(name);
            if (result.variable != null) {
                return result;
            }
            result.fieldLevelWidget = this.symbolScope.lookupFieldLevelWidget(name);
            if (result.fieldLevelWidget != null) {
                return result;
            }
            Symbol s = this.symbolScope.lookupSymbol(1194, name);
            if (s != null) {
                result.event = (Event)s;
                return result;
            }
            result = this.lookupUnqualifiedField(name);
            if (result == null) {
                TableBuffer tableBuff;
                result = new FieldLookupResult();
                IField field = this.symbolScope.getRootScope().lookupUnqualifiedField(name);
                if (field != null) {
                    tableBuff = this.symbolScope.getRootScope().getLocalTableBuffer(field.getTable());
                } else {
                    field = this.symbolScope.getRootScope().getRefactorSession().getSchema().lookupUnqualifiedField(name);
                    if (field == null) {
                        return null;
                    }
                    tableBuff = this.symbolScope.getUnnamedBuffer(field.getTable());
                }
                result.field = tableBuff.getFieldBuffer(field);
            }
            result.isUnqualified = true;
            if (name.length() < result.field.getName().length()) {
                result.isAbbreviated = true;
            }
        } else {
            String[] parts;
            String tblPart;
            String fieldPart = name.substring(lastDot + 1);
            String tablePart = name.substring(0, lastDot);
            TableBuffer tableBuff = this.symbolScope.getBufferSymbol(tablePart);
            if (tableBuff == null) {
                return null;
            }
            IField field = tableBuff.getTable().lookupField(fieldPart);
            if (field == null) {
                return null;
            }
            result.field = tableBuff.getFieldBuffer(field);
            if (fieldPart.length() < result.field.getName().length()) {
                result.isAbbreviated = true;
            }
            if (tableBuff.isDefaultSchema() && (tblPart = (parts = tablePart.split("\\."))[parts.length - 1]).length() < tableBuff.getTable().getName().length()) {
                result.isAbbreviated = true;
            }
        }
        if (getBufferScope) {
            BufferScope buffScope;
            result.bufferScope = buffScope = this.getBufferForReference(result.field.getBuffer());
        }
        return result;
    }

    protected FieldLookupResult lookupUnqualifiedField(String name) {
        HashMap<TableBuffer, BufferScope> buffs = new HashMap<TableBuffer, BufferScope>();
        FieldLookupResult result = null;
        for (BufferScope buff : this.bufferScopes) {
            TableBuffer symbol = buff.getSymbol();
            if (buff.getBlock() == this) {
                buffs.put(symbol, buff);
                continue;
            }
            BufferScope buffSeen = (BufferScope)buffs.get(symbol);
            if (buffSeen != null && (buffSeen.getBlock() == this || buffSeen.isStrong())) continue;
            buffs.put(symbol, buff);
        }
        for (BufferScope buffScope : buffs.values()) {
            IField field;
            TableBuffer tableBuff = buffScope.getSymbol();
            if (buffScope.isStrong() && !this.isBufferLocal(buffScope) || buffScope.isWeak() && !this.isBufferLocal(buffScope) && !tableBuff.isDefault() || (field = tableBuff.getTable().lookupField(name)) == null) continue;
            result = new FieldLookupResult();
            result.field = tableBuff.getFieldBuffer(field);
            if (tableBuff.isDefaultSchema()) continue;
            return result;
        }
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.lookupUnqualifiedField(name);
        }
        return null;
    }

    public void setDefaultFrameExplicit(Frame frame) {
        this.defaultFrame = frame;
        this.frames.add(frame);
    }

    public Block setDefaultFrameImplicit(Frame frame) {
        if (this.canScopeFrame()) {
            this.defaultFrame = frame;
            this.frames.add(frame);
            return this;
        }
        return this.parent.setDefaultFrameImplicit(frame);
    }

    public void setParent(Block parent) {
        this.parent = parent;
    }

    public String toString() {
        return "Block " + this.blockStatementNode.toString();
    }
}

